/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.make.GwtCompilerWorkspaceConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.impl.GwtCompilerWorkspaceState;

@State(name="GwtCompilerConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GwtCompilerWorkspaceConfigurationImpl
extends GwtCompilerWorkspaceConfiguration
implements PersistentStateComponent<GwtCompilerWorkspaceState> {
    private Set<String> myModulesToShowCompilerOutput = new HashSet<String>();

    public GwtCompilerWorkspaceState getState() {
        GwtCompilerWorkspaceState state = new GwtCompilerWorkspaceState();
        state.getModulesToShowCompilerOutput().addAll(this.myModulesToShowCompilerOutput);
        Collections.sort(state.getModulesToShowCompilerOutput());
        return state;
    }

    public void loadState(GwtCompilerWorkspaceState state) {
        this.myModulesToShowCompilerOutput.clear();
        this.myModulesToShowCompilerOutput.addAll(state.getModulesToShowCompilerOutput());
    }

    @Override
    public boolean isShowCompilerOutput(@NotNull GwtFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/make/GwtCompilerWorkspaceConfigurationImpl", "isShowCompilerOutput"));
        }
        return this.myModulesToShowCompilerOutput.contains(facet.getModule().getName());
    }

    @Override
    public void setShowCompilerOutput(@NotNull GwtFacet facet, boolean show) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/make/GwtCompilerWorkspaceConfigurationImpl", "setShowCompilerOutput"));
        }
        String name = facet.getModule().getName();
        if (show) {
            this.myModulesToShowCompilerOutput.add(name);
        } else {
            this.myModulesToShowCompilerOutput.remove(name);
        }
    }
}

