/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module;

import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.index.GwtHtmlFileIndex;
import com.intellij.gwt.module.index.GwtModuleRenameToIndex;
import com.intellij.gwt.module.model.GwtEntryPoint;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtModulesManagerImpl
extends GwtModulesManager {
    @NonNls
    private static final String CSS_EXTENSION = ".css";
    private static final Key<CachedValue<MultiMap<String, CssClass>>> CACHED_CSS_CLASS_DECLARATIONS = Key.create((String)"CACHED_CSS_CLASS_DECLARATIONS");
    private static final Key<CachedValue<InheritedModulesInfo>> CACHED_GWT_INHERITED_MODULES = Key.create((String)"CACHED_GWT_INHERITED_MODULES");
    private final Project myProject;
    private final ProjectFileIndex myProjectFileIndex;

    public GwtModulesManagerImpl(Project project) {
        this.myProject = project;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
    }

    @Override
    @NotNull
    public List<GwtModule> getAllGwtModules() {
        List<GwtModule> list = this.getGwtModules(GlobalSearchScope.allScope((Project)this.myProject));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "getAllGwtModules"));
        }
        return list;
    }

    private List<GwtModule> getGwtModules(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModules"));
        }
        GwtModulesFinder finder = new GwtModulesFinder(this.myProject);
        Collection<VirtualFile> candidates = this.getGwtModuleFiles(scope);
        for (VirtualFile file : candidates) {
            if (!this.myProjectFileIndex.isInSource(file) && !this.myProjectFileIndex.isInLibraryClasses(file)) continue;
            finder.processFile(file);
        }
        return finder.getResults();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getGwtModuleFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModuleFiles"));
        }
        Collection collection = DomService.getInstance().getDomFileCandidates(GwtModule.class, this.myProject, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModuleFiles"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<GwtModule> getGwtModules(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModules"));
        }
        List<GwtModule> list = this.getGwtModules(module.getModuleScope(includeTests));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModules"));
        }
        return list;
    }

    @Override
    @Nullable
    public GwtModule findGwtModuleByClientSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModuleByClientSourceFile"));
        }
        List<GwtModule> gwtModules = this.findGwtModulesByClientSourceFile(file);
        return !gwtModules.isEmpty() ? gwtModules.get(0) : null;
    }

    @Override
    @NotNull
    public List<GwtModule> findGwtModulesByClientSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByClientSourceFile"));
        }
        List<GwtModule> list = this.findModulesByClientOrPublicFile(file, true, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByClientSourceFile"));
        }
        return list;
    }

    @NotNull
    private List<GwtModule> findModulesByClientOrPublicFile(VirtualFile file, boolean clientFileAllowed, boolean publicFileAllowed) {
        GwtModulesFinder finder = new GwtModulesFinder(this.myProject);
        for (VirtualFile parent = file.getParent(); parent != null && (this.myProjectFileIndex.isInSource(parent) || this.myProjectFileIndex.isInLibraryClasses(parent)); parent = parent.getParent()) {
            finder.processChildren(parent);
        }
        ArrayList<GwtModule> gwtModules = new ArrayList<GwtModule>();
        for (GwtModule module : finder.getResults()) {
            if (clientFileAllowed && module.isSourceFile(file)) {
                gwtModules.add(module);
            }
            if (!publicFileAllowed || !module.isPublicFile(file)) continue;
            gwtModules.add(module);
            break;
        }
        ArrayList<GwtModule> arrayList = gwtModules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findModulesByClientOrPublicFile"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public XmlFile[] findHtmlFilesByModule(@NotNull GwtModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/module/GwtModulesManagerImpl", "findHtmlFilesByModule"));
        }
        Collection<VirtualFile> htmlFiles = this.getAllHtmlFiles(module);
        if (htmlFiles.isEmpty()) {
            if (XmlFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findHtmlFilesByModule"));
            }
            return XmlFile.EMPTY_ARRAY;
        }
        VirtualFile parent = module.getModuleDirectory();
        VirtualFile defaultFile = parent.findFileByRelativePath("public/" + module.getShortName() + "." + StdFileTypes.HTML.getDefaultExtension());
        ArrayList<XmlFile> result = new ArrayList<XmlFile>();
        for (VirtualFile file : htmlFiles) {
            XmlFile xmlFile;
            FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(file);
            if (viewProvider == null || (xmlFile = (XmlFile)viewProvider.getPsi(StdLanguages.HTML)) == null) continue;
            if (file.equals(defaultFile)) {
                result.add(0, xmlFile);
                continue;
            }
            result.add(xmlFile);
        }
        XmlFile[] xmlFileArray = result.toArray(new XmlFile[result.size()]);
        if (xmlFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findHtmlFilesByModule"));
        }
        return xmlFileArray;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getAllHtmlFiles(GwtModule module) {
        Collection<VirtualFile> collection = GwtHtmlFileIndex.getHtmlFilesByModule(this.myProject, module.getOutputName());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "getAllHtmlFiles"));
        }
        return collection;
    }

    @Override
    @Nullable
    public PsiElement findTagById(@NotNull XmlFile htmlFile, String id) {
        if (htmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlFile", "com/intellij/gwt/module/GwtModulesManagerImpl", "findTagById"));
        }
        Map<String, XmlTag> id2Tag = GwtModulesManagerImpl.getHtmlId2TagMap(htmlFile);
        return (PsiElement)id2Tag.get(id);
    }

    @Override
    public Collection<GwtModule> getGwtModuleToCompile(Module module, boolean includeTests) {
        ArrayList<GwtModule> result = new ArrayList<GwtModule>();
        GwtFacet facet = GwtFacet.getInstance(module);
        for (GwtModule gwtModule : this.getGwtModules(module, includeTests)) {
            if (this.isLibraryModule(gwtModule) || facet != null && !((GwtFacetConfiguration)facet.getConfiguration()).isModuleCompilationEnabled(gwtModule)) continue;
            result.add(gwtModule);
        }
        return result;
    }

    @Override
    public Collection<GwtModule> getCompilableGwtModules(Module module, boolean includeTests) {
        ArrayList<GwtModule> result = new ArrayList<GwtModule>();
        for (GwtModule gwtModule : this.getGwtModules(module, includeTests)) {
            if (this.isLibraryModule(gwtModule)) continue;
            result.add(gwtModule);
        }
        return result;
    }

    private static Map<String, XmlTag> getHtmlId2TagMap(XmlFile htmlFile) {
        final HashMap<String, XmlTag> id2Tag = new HashMap<String, XmlTag>();
        htmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String elementId = tag.getAttributeValue("id");
                if (elementId != null) {
                    id2Tag.put(elementId, tag);
                }
                super.visitXmlTag(tag);
            }
        });
        return id2Tag;
    }

    @Override
    @NotNull
    public Set<CssClass> findCssClasses(GwtModule module, String className) {
        HashSet<CssClass> result = new HashSet<CssClass>();
        for (XmlFile file : this.getInheritedModules(module).getModuleFiles()) {
            GwtModule gwtModule = this.getGwtModuleByXmlFile((PsiFile)file);
            if (gwtModule == null) continue;
            result.addAll(this.getCssClass2DeclarationMap(gwtModule).get((Object)className));
        }
        HashSet<CssClass> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findCssClasses"));
        }
        return hashSet;
    }

    private MultiMap<String, CssClass> getCssClass2DeclarationMap(GwtModule module) {
        CachedValue cachedValue = (CachedValue)module.getModuleXmlFile().getUserData(CACHED_CSS_CLASS_DECLARATIONS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> this.computeCssDeclarations(module), false);
            module.getModuleXmlFile().putUserData(CACHED_CSS_CLASS_DECLARATIONS, (Object)cachedValue);
        }
        return (MultiMap)cachedValue.getValue();
    }

    private CachedValueProvider.Result<MultiMap<String, CssClass>> computeCssDeclarations(GwtModule module) {
        MultiMap cssClass2Declaration = new MultiMap();
        List<StylesheetFile> list = module.getStylesheetFiles();
        for (StylesheetFile stylesheetFile : list) {
            GwtCssDeclarationsManager.collectDeclarations(stylesheetFile, CssClass.class, cssClass2Declaration);
        }
        XmlFile[] htmlFiles = this.findHtmlFilesByModule(module);
        CssResolveManager resolveManager = CssResolveManager.getInstance();
        for (XmlFile htmlFile : htmlFiles) {
            for (CssRuleset cssRuleset : resolveManager.getNewResolver().resolveAll(htmlFile)) {
                GwtCssDeclarationsManager.collectCssClasses(cssRuleset, (MultiMap<String, ? super CssClass>)cssClass2Declaration);
            }
        }
        return CachedValueProvider.Result.create((Object)cssClass2Declaration, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.myProject)});
    }

    @Override
    public String[] getAllCssClassNames(GwtModule module) {
        HashSet classesSet = new HashSet();
        for (XmlFile xmlFile : this.getInheritedModules(module).getModuleFiles()) {
            GwtModule gwtModule = this.getGwtModuleByXmlFile((PsiFile)xmlFile);
            if (gwtModule == null) continue;
            classesSet.addAll(this.getCssClass2DeclarationMap(gwtModule).keySet());
        }
        return ArrayUtil.toStringArray(classesSet);
    }

    @Override
    @Nullable
    public StylesheetFile findPreferableCssFile(GwtModule module) {
        List<StylesheetFile> list = module.getStylesheetFiles();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        XmlFile[] htmlFiles = this.findHtmlFilesByModule(module);
        StylesheetFile result = null;
        for (XmlFile htmlFile : htmlFiles) {
            StylesheetFile[] files = CssResolveManager.getInstance().getNewResolver().resolveStyleSheets(htmlFile, null);
            String expectedFileName = module.getShortName() + CSS_EXTENSION;
            for (StylesheetFile cssFile : files) {
                if (!expectedFileName.equals(cssFile.getName())) continue;
                return cssFile;
            }
            if (files.length <= 0 || result != null) continue;
            result = files[0];
        }
        return result;
    }

    @Override
    public boolean isInheritedOrSelf(GwtModule gwtModule, GwtModule inheritedModule) {
        Set<String> names = this.getInheritedModules(gwtModule).getModuleNames();
        return names.contains(inheritedModule.getQualifiedName());
    }

    @Override
    @NotNull
    public Collection<GwtModule> findAllInheritedModules(@NotNull Collection<GwtModule> modules, @NotNull GlobalSearchScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/gwt/module/GwtModulesManagerImpl", "findAllInheritedModules"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/module/GwtModulesManagerImpl", "findAllInheritedModules"));
        }
        LinkedHashSet<String> allNames = new LinkedHashSet<String>();
        for (GwtModule module : modules) {
            allNames.addAll(this.getInheritedModules(module).getModuleNames());
        }
        ArrayList<GwtModule> result = new ArrayList<GwtModule>();
        for (String name : allNames) {
            ContainerUtil.addIfNotNull(result, (Object)this.findGwtModuleByQualifiedName(name, scope));
        }
        ArrayList<GwtModule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findAllInheritedModules"));
        }
        return arrayList;
    }

    private InheritedModulesInfo getInheritedModules(GwtModule gwtModule) {
        CachedValue cachedValue = (CachedValue)gwtModule.getModuleXmlFile().getUserData(CACHED_GWT_INHERITED_MODULES);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                Module module = gwtModule.getModule();
                GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)this.myProject);
                InheritedModulesInfo inheritedModules = new InheritedModulesInfo();
                GwtModulesManagerImpl.collectAllInherited(gwtModule, scope, inheritedModules);
                Object[] dependencies = new Object[inheritedModules.getModuleFiles().size() + 1];
                dependencies[0] = ProjectRootManager.getInstance((Project)this.myProject);
                int i = 1;
                for (XmlFile xmlFile : inheritedModules.getModuleFiles()) {
                    dependencies[i++] = xmlFile;
                }
                return CachedValueProvider.Result.create((Object)inheritedModules, (Object[])dependencies);
            }, false);
            gwtModule.getModuleXmlFile().putUserData(CACHED_GWT_INHERITED_MODULES, (Object)cachedValue);
        }
        return (InheritedModulesInfo)cachedValue.getValue();
    }

    private static void collectAllInherited(GwtModule gwtModule, GlobalSearchScope scope, InheritedModulesInfo result) {
        XmlFile moduleFile = gwtModule.getModuleXmlFile();
        if (result.getModuleFiles().contains(moduleFile)) {
            return;
        }
        result.getModuleFiles().add(moduleFile);
        result.getModuleNames().add(gwtModule.getQualifiedName());
        result.myHasEntryPoints = result.myHasEntryPoints | !gwtModule.getEntryPoints().isEmpty();
        for (GwtModule module : gwtModule.getInherited(scope)) {
            GwtModulesManagerImpl.collectAllInherited(module, scope, result);
        }
    }

    @Override
    public boolean isLibraryModule(GwtModule module) {
        return module.getEntryPoints().isEmpty() && this.getAllHtmlFiles(module).isEmpty() && !this.getInheritedModules(module).hasEntryPoints();
    }

    @Override
    public boolean isUnderGwtModule(VirtualFile file) {
        GwtModulesFinder finder = new GwtModulesFinder(this.myProject);
        for (VirtualFile parent = file.getParent(); parent != null && this.myProjectFileIndex.isInSource(parent); parent = parent.getParent()) {
            finder.processChildren(parent);
        }
        return !finder.getResults().isEmpty();
    }

    @Override
    @Nullable
    public GwtModule findGwtModuleByQualifiedName(@NotNull String qualifiedName, GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModuleByQualifiedName"));
        }
        List<GwtModule> gwtModules = this.findGwtModulesByQualifiedName(qualifiedName, scope);
        return gwtModules.isEmpty() ? null : gwtModules.get(0);
    }

    @Override
    @NotNull
    public Collection<GwtModule> findGwtModulesByOutputName(@NotNull String outputName, GlobalSearchScope scope) {
        if (outputName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputName", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByOutputName"));
        }
        THashSet gwtModules = new THashSet();
        gwtModules.addAll(this.findGwtModulesByQualifiedName(outputName, scope));
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : GwtModuleRenameToIndex.getGwtXmlFiles(outputName, scope)) {
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof XmlFile)) continue;
            ContainerUtilRt.addIfNotNull((Collection)gwtModules, (Object)this.getGwtModuleByXmlFile(psiFile));
        }
        THashSet tHashSet = gwtModules;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByOutputName"));
        }
        return tHashSet;
    }

    @Nullable
    private static String getPathFromPublicRoot(@NotNull GwtModule gwtModule, @NotNull VirtualFile file) {
        if (gwtModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModule", "com/intellij/gwt/module/GwtModulesManagerImpl", "getPathFromPublicRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "getPathFromPublicRoot"));
        }
        for (VirtualFile root : gwtModule.getPublicRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
        }
        return null;
    }

    @Override
    public List<GwtModule> findGwtModulesByQualifiedName(String qualifiedName, GlobalSearchScope scope) {
        ArrayList<GwtModule> modules = new ArrayList<GwtModule>();
        String name = qualifiedName;
        String packageName = "";
        while (true) {
            int dot;
            PsiPackage psiPackage;
            if ((psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName)) != null) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = psiPackage.getDirectories(scope)) {
                    DomFileElement fileElement;
                    PsiFile psiFile = directory.findFile(name + ".gwt.xml");
                    if (!(psiFile instanceof XmlFile) || (fileElement = DomManager.getDomManager((Project)this.myProject).getFileElement((XmlFile)psiFile, GwtModule.class)) == null) continue;
                    modules.add((GwtModule)fileElement.getRootElement());
                }
            }
            if ((dot = name.indexOf(46)) == -1) break;
            String shortName = name.substring(0, dot);
            packageName = packageName.length() > 0 ? packageName + "." + shortName : shortName;
            name = name.substring(dot + 1);
        }
        return modules;
    }

    @Override
    public String[] getAllIds(@NotNull XmlFile htmlFile) {
        if (htmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlFile", "com/intellij/gwt/module/GwtModulesManagerImpl", "getAllIds"));
        }
        Set<String> idSet = GwtModulesManagerImpl.getHtmlId2TagMap(htmlFile).keySet();
        return ArrayUtil.toStringArray(idSet);
    }

    @Override
    @NotNull
    public List<GwtModule> findModulesByClass(@NotNull PsiElement context, @Nullable String className) {
        PsiClass[] psiClasses;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/module/GwtModulesManagerImpl", "findModulesByClass"));
        }
        if (className == null) {
            List<GwtModule> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findModulesByClass"));
            }
            return list;
        }
        for (PsiClass psiClass : psiClasses = JavaPsiFacade.getInstance((Project)context.getProject()).findClasses(className, context.getResolveScope())) {
            List<GwtModule> modules;
            VirtualFile file;
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (modules = this.findGwtModulesByClientSourceFile(file)).isEmpty()) continue;
            List<GwtModule> list = modules;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findModulesByClass"));
            }
            return list;
        }
        List<GwtModule> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findModulesByClass"));
        }
        return list;
    }

    @Override
    public GwtModule findGwtModuleByEntryPoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModuleByEntryPoint"));
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        List<GwtModule> gwtModules = this.findGwtModulesByClientSourceFile(file);
        for (GwtModule gwtModule : gwtModules) {
            List<GwtEntryPoint> entryPoints = gwtModule.getEntryPoints();
            for (GwtEntryPoint entryPoint : entryPoints) {
                String className = (String)entryPoint.getEntryClass().getValue();
                if (className == null || !className.equals(psiClass.getQualifiedName())) continue;
                return gwtModule;
            }
        }
        return null;
    }

    @Override
    public GwtModule getGwtModule(@NotNull PsiFile gwtXmlFile) {
        if (gwtXmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtXmlFile", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModule"));
        }
        VirtualFile file = gwtXmlFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        GwtModulesFinder finder = new GwtModulesFinder(this.myProject);
        finder.processFile(file);
        return (GwtModule)ContainerUtil.getFirstItem(finder.getResults(), null);
    }

    @Override
    @NotNull
    public List<Pair<GwtModule, String>> findGwtModulesByPublicFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByPublicFile"));
        }
        List<GwtModule> gwtModules = this.findModulesByClientOrPublicFile(file, false, true);
        ArrayList<Pair<GwtModule, String>> pairs = new ArrayList<Pair<GwtModule, String>>();
        for (GwtModule gwtModule : gwtModules) {
            String path = GwtModulesManagerImpl.getPathFromPublicRoot(gwtModule, file);
            if (path == null) continue;
            pairs.add((Pair<GwtModule, String>)Pair.create((Object)gwtModule, (Object)path));
        }
        ArrayList<Pair<GwtModule, String>> arrayList = pairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/module/GwtModulesManagerImpl", "findGwtModulesByPublicFile"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public GwtModule getGwtModuleByXmlFile(@NotNull PsiFile file) {
        DomFileElement fileElement;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "getGwtModuleByXmlFile"));
        }
        if (file instanceof XmlFile && (fileElement = DomManager.getDomManager((Project)this.myProject).getFileElement((XmlFile)file, GwtModule.class)) != null) {
            return (GwtModule)fileElement.getRootElement();
        }
        return null;
    }

    @Override
    public boolean isInheritedOrSelf(GwtModule gwtModule, List<GwtModule> referencedModules) {
        for (GwtModule referencedModule : referencedModules) {
            if (!this.isInheritedOrSelf(gwtModule, referencedModule)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getOutputPath(@NotNull GwtModule gwtModule, @NotNull VirtualFile file) {
        if (gwtModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModule", "com/intellij/gwt/module/GwtModulesManagerImpl", "getOutputPath"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/GwtModulesManagerImpl", "getOutputPath"));
        }
        String path = GwtModulesManagerImpl.getPathFromPublicRoot(gwtModule, file);
        if (path != null) {
            return GwtWebUtil.getOutputPath(gwtModule, path);
        }
        GwtFacet gwtFacet = GwtFacet.getInstance(gwtModule);
        if (gwtFacet != null && gwtFacet.getSdkVersion().isHtmlFilesOutsideSourcesAreAllowed()) {
            return GwtWebUtil.getRelativeToWebRootPath(file, this.myProject);
        }
        return null;
    }

    private static class InheritedModulesInfo {
        private final Set<XmlFile> myModuleFiles = new LinkedHashSet<XmlFile>();
        private final Set<String> myModuleNames = new LinkedHashSet<String>();
        private boolean myHasEntryPoints;

        private InheritedModulesInfo() {
        }

        public boolean hasEntryPoints() {
            return this.myHasEntryPoints;
        }

        public Set<XmlFile> getModuleFiles() {
            return this.myModuleFiles;
        }

        public Set<String> getModuleNames() {
            return this.myModuleNames;
        }
    }

    private static class GwtModulesFinder
    implements ContentIterator {
        private final List<GwtModule> myResults = new ArrayList<GwtModule>();
        private final PsiManager myPsiManager;
        private final DomManager myDomManager;

        public GwtModulesFinder(Project project) {
            this.myPsiManager = PsiManager.getInstance((Project)project);
            this.myDomManager = DomManager.getDomManager((Project)project);
        }

        public boolean processFile(VirtualFile fileOrDir) {
            DomFileElement fileElement;
            PsiFile psiFile;
            if (!fileOrDir.isDirectory() && fileOrDir.getFileType() == StdFileTypes.XML && fileOrDir.getNameWithoutExtension().endsWith(".gwt") && (psiFile = this.myPsiManager.findFile(fileOrDir)) instanceof XmlFile && (fileElement = this.myDomManager.getFileElement((XmlFile)psiFile, GwtModule.class)) != null) {
                this.myResults.add((GwtModule)fileElement.getRootElement());
            }
            return true;
        }

        public List<GwtModule> getResults() {
            return this.myResults;
        }

        public void processChildren(VirtualFile parent) {
            List<VirtualFile> directories = this.getDirectories(parent);
            for (VirtualFile directory : directories) {
                VirtualFile[] files = directory.getChildren();
                if (files == null) continue;
                for (VirtualFile virtualFile : files) {
                    this.processFile(virtualFile);
                }
            }
        }

        private List<VirtualFile> getDirectories(VirtualFile directory) {
            PsiPackage psiPackage;
            PsiDirectory psiDirectory;
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory, (Project)this.myPsiManager.getProject());
            if (module != null && (psiDirectory = this.myPsiManager.findDirectory(directory)) != null && (psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
                PsiDirectory[] psiDirectories;
                ArrayList<VirtualFile> directories = new ArrayList<VirtualFile>();
                for (PsiDirectory dir : psiDirectories = psiPackage.getDirectories(module.getModuleWithDependentsScope())) {
                    directories.add(dir.getVirtualFile());
                }
                return directories;
            }
            return Collections.singletonList(directory);
        }
    }
}

