/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class GwtFilePatternUtil {
    private static final String[] EXCLUDED_FILES = new String[]{"CVS", ".cvsignore", "SCCS", "vssver.scc", ".svn", ".DS_Store", ".git", ".gitattributes", ".gitignore", ".gitmodules", ".hg", ".hgignore", ".hgsub", ".hgsubstate", ".hgtags", ".bzr", ".bzrignore"};
    private static final String[] EXCLUDED_FOLDERS = new String[]{"CVS", "SCCS", ".svn", ".git", ".hg", ".bzr"};
    private static Set<String> ourExcludedFiles = new HashSet<String>();
    private static Set<String> ourCaseInsensitiveExcludedFiles = new HashSet<String>();
    private static Set<String> ourExcludedFolders = new HashSet<String>();
    private static Set<String> ourCaseInsensitiveExcludedFolders = new HashSet<String>();

    private static boolean isFileExcluded(String fileName) {
        if (fileName.startsWith(".#")) {
            return true;
        }
        if (fileName.startsWith("._")) {
            return true;
        }
        if (fileName.endsWith("~")) {
            return true;
        }
        int length = fileName.length();
        if (length >= 2 && fileName.charAt(0) == fileName.charAt(length - 1)) {
            return fileName.charAt(0) == '#' || fileName.charAt(0) == '%';
        }
        return false;
    }

    private GwtFilePatternUtil() {
    }

    public static Pattern createPattern(String pattern, boolean caseSensitive) {
        return Pattern.compile(FileUtil.convertAntToRegexp((String)pattern), caseSensitive ? 0 : 2);
    }

    public static boolean isExcludedByDefault(String path, boolean caseSensitive) {
        int length;
        String[] names;
        String fileName;
        Set<String> excludedFiles;
        if (!caseSensitive) {
            path = StringUtil.toLowerCase((String)path);
        }
        if ((excludedFiles = caseSensitive ? ourExcludedFiles : ourCaseInsensitiveExcludedFiles).contains(fileName = (names = ArrayUtil.toStringArray((Collection)StringUtil.split((String)path, (String)"/")))[(length = names.length) - 1]) || GwtFilePatternUtil.isFileExcluded(fileName)) {
            return true;
        }
        Set<String> excludedFolders = caseSensitive ? ourExcludedFolders : ourCaseInsensitiveExcludedFolders;
        for (int i = 0; i < length - 1; ++i) {
            if (!excludedFolders.contains(names[i])) continue;
            return true;
        }
        return false;
    }

    static {
        for (String fileName : EXCLUDED_FILES) {
            ourExcludedFiles.add(fileName);
            ourCaseInsensitiveExcludedFiles.add(StringUtil.toLowerCase((String)fileName));
        }
        for (String fileName : EXCLUDED_FOLDERS) {
            ourExcludedFolders.add(fileName);
            ourCaseInsensitiveExcludedFolders.add(StringUtil.toLowerCase((String)fileName));
        }
    }
}

