/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.Api;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiClass
implements Comparable<ApiClass> {
    private final String mName;
    private final int mSince;
    private final int mDeprecatedIn;
    private final List<Pair<String, Integer>> mSuperClasses = Lists.newArrayList();
    private final List<Pair<String, Integer>> mInterfaces = Lists.newArrayList();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();
    private final Map<String, Integer> mDeprecatedMembersIn = new HashMap<String, Integer>();
    List<String> members;
    int index;
    int indexOffset;
    int memberOffsetBegin;
    int memberOffsetEnd;
    int memberIndexStart;
    int memberIndexLength;

    ApiClass(String name, int since, int deprecatedIn) {
        this.mName = name;
        this.mSince = since;
        this.mDeprecatedIn = deprecatedIn;
    }

    String getName() {
        return this.mName;
    }

    int getSince() {
        return this.mSince;
    }

    int getDeprecatedIn() {
        return this.mDeprecatedIn;
    }

    int getField(String name, Api info) {
        int tmp;
        ApiClass superClass;
        int min = Integer.MAX_VALUE;
        Integer i = this.mFields.get(name);
        if (i != null) {
            min = i;
        }
        for (Pair<String, Integer> superClassPair : this.mSuperClasses) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null) continue;
            i = superClass.getField(name, info);
            tmp = (Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        for (Pair<String, Integer> superClassPair : this.mInterfaces) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null) continue;
            i = superClass.getField(name, info);
            tmp = (Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    int getMemberDeprecatedIn(String name, Api info) {
        int deprecatedIn = this.findMemberDeprecatedIn(name, info);
        return deprecatedIn < Integer.MAX_VALUE ? deprecatedIn : 0;
    }

    private int findMemberDeprecatedIn(String name, Api info) {
        int tmp;
        ApiClass superClass;
        int min = Integer.MAX_VALUE;
        Integer i = this.mDeprecatedMembersIn.get(name);
        if (i != null) {
            min = i;
        }
        for (Pair<String, Integer> superClassPair : this.mSuperClasses) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null) continue;
            i = superClass.findMemberDeprecatedIn(name, info);
            tmp = (Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        for (Pair<String, Integer> superClassPair : this.mInterfaces) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null) continue;
            i = superClass.findMemberDeprecatedIn(name, info);
            tmp = (Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    int getMethod(String methodSignature, Api info) {
        int tmp;
        ApiClass superClass;
        int min = Integer.MAX_VALUE;
        Integer i = this.mMethods.get(methodSignature);
        if (i != null) {
            min = i;
            if (methodSignature.startsWith("<init>")) {
                return i;
            }
        }
        for (Pair<String, Integer> superClassPair : this.mSuperClasses) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null) continue;
            i = superClass.getMethod(methodSignature, info);
            tmp = (Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        for (Pair<String, Integer> interfacePair : this.mInterfaces) {
            superClass = info.getClass((String)interfacePair.getFirst());
            if (superClass == null) continue;
            i = superClass.getMethod(methodSignature, info);
            tmp = (Integer)interfacePair.getSecond() > i ? (Integer)interfacePair.getSecond() : i;
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    void addField(String name, int since, int deprecatedIn) {
        Integer i = this.mFields.get(name);
        assert (i == null);
        this.mFields.put(name, since);
        if (deprecatedIn > 0) {
            this.mDeprecatedMembersIn.put(name, deprecatedIn);
        }
    }

    void addMethod(String name, int since, int deprecatedIn) {
        int index = name.indexOf(41);
        if (index != -1) {
            name = name.substring(0, index + 1);
        }
        Integer i = this.mMethods.get(name);
        assert (i == null || i == since) : i;
        this.mMethods.put(name, since);
        if (deprecatedIn > 0) {
            this.mDeprecatedMembersIn.put(name, deprecatedIn);
        }
    }

    void addSuperClass(String superClass, int since) {
        ApiClass.addToArray(this.mSuperClasses, superClass, since);
    }

    void addInterface(String interfaceClass, int since) {
        ApiClass.addToArray(this.mInterfaces, interfaceClass, since);
    }

    static void addToArray(List<Pair<String, Integer>> list, String name, int value2) {
        for (Pair<String, Integer> pair : list) {
            if (!name.equals(pair.getFirst())) continue;
            assert (false);
            return;
        }
        list.add((Pair<String, Integer>)Pair.of((Object)name, (Object)value2));
    }

    @Nullable
    public String getPackage() {
        int index = this.mName.lastIndexOf(47);
        if (index != -1) {
            return this.mName.substring(0, index);
        }
        return null;
    }

    @NonNull
    public String getSimpleName() {
        int index = this.mName.lastIndexOf(47);
        if (index != -1) {
            return this.mName.substring(index + 1);
        }
        return this.mName;
    }

    public String toString() {
        return this.mName;
    }

    Set<String> getAllMethods(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllMethods(info, members, true);
        return members;
    }

    List<Pair<String, Integer>> getInterfaces() {
        return this.mInterfaces;
    }

    List<Pair<String, Integer>> getSuperClasses() {
        return this.mSuperClasses;
    }

    private void addAllMethods(Api info, Set<String> set, boolean includeConstructors) {
        ApiClass clz;
        if (!includeConstructors) {
            for (String string : this.mMethods.keySet()) {
                if (string.startsWith("<init>")) continue;
                set.add(string);
            }
        } else {
            for (String string : this.mMethods.keySet()) {
                set.add(string);
            }
        }
        for (Pair pair : this.mSuperClasses) {
            clz = info.getClass((String)pair.getFirst());
            if (clz == null) continue;
            clz.addAllMethods(info, set, false);
        }
        for (Pair pair : this.mInterfaces) {
            clz = info.getClass((String)pair.getFirst());
            if (clz == null) continue;
            clz.addAllMethods(info, set, false);
        }
    }

    Set<String> getAllFields(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllFields(info, members);
        return members;
    }

    private void addAllFields(Api info, Set<String> set) {
        ApiClass clz;
        for (String string : this.mFields.keySet()) {
            set.add(string);
        }
        for (Pair pair : this.mSuperClasses) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            clz.addAllFields(info, set);
        }
        for (Pair pair : this.mInterfaces) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            clz.addAllFields(info, set);
        }
    }

    @Override
    public int compareTo(@NonNull ApiClass other) {
        return this.mName.compareTo(other.mName);
    }
}

