/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class BadHostnameVerifierDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(BadHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("BadHostnameVerifier", "Insecure HostnameVerifier", "This check looks for implementations of `HostnameVerifier` whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.HostnameVerifier");
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass declaration2) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration2.findMethodsByName("verify", false)) {
            if (!evaluator.methodMatches(method, null, false, "java.lang.String", "javax.net.ssl.SSLSession")) continue;
            ComplexVisitor visitor = new ComplexVisitor(context);
            declaration2.accept(visitor);
            if (visitor.isComplex()) {
                return;
            }
            Location location = context.getNameLocation((PsiElement)method);
            String message2 = String.format("`%1$s` always returns `true`, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames", method.getName());
            context.report(ISSUE, location, message2);
            break;
        }
    }

    private static class ComplexVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private boolean mComplex;

        public ComplexVisitor(JavaContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitThrowExpression(UThrowExpression node) {
            this.mComplex = true;
            return super.visitThrowExpression(node);
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            this.mComplex = true;
            return super.visitCallExpression(node);
        }

        @Override
        public boolean visitReturnExpression(UReturnExpression node) {
            UExpression argument = node.getReturnExpression();
            if (argument != null) {
                this.mComplex = !UastLiteralUtils.isTrueLiteral(argument);
            }
            return super.visitReturnExpression(node);
        }

        private boolean isComplex() {
            return this.mComplex;
        }
    }
}

