/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CleanupDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create("Recycle", "Missing `recycle()` calls", "Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", Category.PERFORMANCE, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create("CommitTransaction", "Missing `commit()` calls", "After creating a `FragmentTransaction`, you typically need to commit it as well", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue SHARED_PREF = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String APPLY = "apply";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String EDIT = "edit";
    private static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    public static final String SURFACE_CLS = "android.view.Surface";
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    public static final String CURSOR_CLS = "android.database.Cursor";
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, EDIT);
    }

    @Override
    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return Arrays.asList(SURFACE_TEXTURE_CLS, SURFACE_CLS);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        String name = method.getName();
        if (BEGIN_TRANSACTION.equals(name)) {
            CleanupDetector.checkTransactionCommits(context, call, method);
        } else if (EDIT.equals(name)) {
            CleanupDetector.checkEditorApplied(context, call, method);
        } else {
            CleanupDetector.checkResourceRecycled(context, call, method);
        }
    }

    @Override
    public void visitConstructor(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod constructor) {
        String type2;
        PsiClass containingClass = constructor.getContainingClass();
        if (containingClass != null && (type2 = containingClass.getQualifiedName()) != null) {
            CleanupDetector.checkRecycled(context, node, type2, RELEASE);
        }
    }

    private static void checkResourceRecycled(@NonNull JavaContext context, @NonNull UCallExpression node, @NonNull PsiMethod method) {
        String name = method.getName();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if ((OBTAIN.equals(name) || OBTAIN_NO_HISTORY.equals(name)) && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)MOTION_EVENT_CLS)) {
            CleanupDetector.checkRecycled(context, node, MOTION_EVENT_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)PARCEL_CLS)) {
            CleanupDetector.checkRecycled(context, node, PARCEL_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)VELOCITY_TRACKER_CLS)) {
            CleanupDetector.checkRecycled(context, node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((OBTAIN_STYLED_ATTRIBUTES.equals(name) || OBTAIN_ATTRIBUTES.equals(name) || OBTAIN_TYPED_ARRAY.equals(name)) && (InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"android.content.Context") || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"android.content.res.Resources"))) {
            PsiClass cls;
            PsiType returnType2 = method.getReturnType();
            if (returnType2 instanceof PsiClassType && (cls = ((PsiClassType)returnType2).resolve()) != null && "android.content.res.TypedArray".equals(cls.getQualifiedName())) {
                CleanupDetector.checkRecycled(context, node, "android.content.res.TypedArray", RECYCLE);
            }
        } else if (ACQUIRE_CPC.equals(name) && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)CONTENT_RESOLVER_CLS)) {
            CleanupDetector.checkRecycled(context, node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((QUERY.equals(name) || RAW_QUERY.equals(name) || QUERY_WITH_FACTORY.equals(name) || RAW_QUERY_WITH_FACTORY.equals(name)) && (InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)SQLITE_DATABASE_CLS) || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)CONTENT_RESOLVER_CLS) || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"android.content.ContentProvider") || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)CONTENT_PROVIDER_CLIENT_CLS))) {
            CleanupDetector.checkRecycled(context, node, CURSOR_CLS, CLOSE);
        }
    }

    private static void checkRecycled(@NonNull JavaContext context, @NonNull UCallExpression node, final @NonNull String recycleType, final @NonNull String recycleName) {
        PsiVariable boundVariable = CleanupDetector.getVariableElement(node);
        if (boundVariable == null) {
            return;
        }
        UMethod method = (UMethod)UastUtils.getParentOfType(node, UMethod.class, true);
        if (method == null) {
            return;
        }
        FinishVisitor visitor = new FinishVisitor(context, boundVariable){

            @Override
            protected boolean isCleanupCall(@NonNull UCallExpression call) {
                PsiElement resolved;
                UExpression operand2;
                PsiClass containingClass;
                String methodName2 = call.getMethodName();
                if (!recycleName.equals(methodName2)) {
                    return false;
                }
                PsiMethod method = call.resolve();
                return method != null && InheritanceUtil.isInheritor((PsiClass)(containingClass = method.getContainingClass()), (boolean)false, (String)recycleType) && (operand2 = call.getReceiver()) instanceof UReferenceExpression && (resolved = ((UReferenceExpression)operand2).resolve()) != null && this.mVariables.contains(resolved);
            }
        };
        method.accept(visitor);
        if (visitor.isCleanedUp() || visitor.variableEscapes()) {
            return;
        }
        String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
        String message2 = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
        UElement locationNode = node.getMethodIdentifier();
        if (locationNode == null) {
            locationNode = node;
        }
        Location location = context.getUastLocation(locationNode);
        context.report(RECYCLE_RESOURCE, node, location, message2);
    }

    private static void checkTransactionCommits(@NonNull JavaContext context, @NonNull UCallExpression node, @NonNull PsiMethod calledMethod) {
        if (CleanupDetector.isBeginTransaction(context, calledMethod)) {
            PsiVariable boundVariable = CleanupDetector.getVariableElement(node, true);
            if (boundVariable == null && CleanupDetector.isCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod method = (UMethod)UastUtils.getParentOfType(node, UMethod.class, true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                    @Override
                    protected boolean isCleanupCall(@NonNull UCallExpression call) {
                        UExpression first;
                        PsiElement resolved;
                        List<UExpression> arguments;
                        if (CleanupDetector.isTransactionCommitMethodCall(this.mContext, call)) {
                            List<UExpression> chain = UastUtils.getQualifiedChain(UastUtils.getOutermostQualified(call));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand2 = chain.get(0);
                            if (operand2 != null) {
                                PsiElement resolved2 = UastUtils.tryResolve(operand2);
                                if (resolved2 != null && this.mVariables.contains(resolved2)) {
                                    return true;
                                }
                                if (resolved2 instanceof PsiMethod && operand2 instanceof UCallExpression && CleanupDetector.isCommittedInChainedCalls(this.mContext, (UCallExpression)operand2)) {
                                    while (operand2 instanceof UCallExpression) {
                                        operand2 = ((UCallExpression)operand2).getReceiver();
                                    }
                                    if (operand2 instanceof UReferenceExpression && (resolved2 = ((UReferenceExpression)operand2).resolve()) != null && this.mVariables.contains(resolved2)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.isShowFragmentMethodCall(this.mContext, call) && (arguments = call.getValueArguments()).size() == 2 && (resolved = UastUtils.tryResolve(first = arguments.get(0))) != null && this.mVariables.contains(resolved)) {
                            return true;
                        }
                        return false;
                    }
                };
                method.accept(commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            }
            String message2 = "This transaction should be completed with a `commit()` call";
            context.report(COMMIT_FRAGMENT, node, context.getUastNameLocation(node), message2);
        }
    }

    private static boolean isCommittedInChainedCalls(@NonNull JavaContext context, @NonNull UCallExpression node) {
        UCallExpression methodInvocation;
        UExpression lastExpression;
        List<UExpression> chain = UastUtils.getQualifiedChain(UastUtils.getOutermostQualified(node));
        return !chain.isEmpty() && (lastExpression = chain.get(chain.size() - 1)) instanceof UCallExpression && (CleanupDetector.isTransactionCommitMethodCall(context, methodInvocation = (UCallExpression)lastExpression) || CleanupDetector.isShowFragmentMethodCall(context, methodInvocation));
    }

    private static boolean isTransactionCommitMethodCall(@NonNull JavaContext context, @NonNull UCallExpression call) {
        String methodName2 = call.getMethodName();
        return (COMMIT.equals(methodName2) || COMMIT_ALLOWING_LOSS.equals(methodName2)) && CleanupDetector.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private static boolean isShowFragmentMethodCall(@NonNull JavaContext context, @NonNull UCallExpression call) {
        String methodName2 = call.getMethodName();
        return SHOW.equals(methodName2) && CleanupDetector.isMethodOnFragmentClass(context, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private static boolean isMethodOnFragmentClass(@NonNull JavaContext context, @NonNull UCallExpression call, @NonNull String fragmentClass, @NonNull String v4FragmentClass, boolean returnForUnresolved) {
        PsiMethod method = call.resolve();
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)fragmentClass) || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)v4FragmentClass);
        }
        return returnForUnresolved;
    }

    private static void checkEditorApplied(@NonNull JavaContext context, @NonNull UCallExpression node, @NonNull PsiMethod calledMethod) {
        if (CleanupDetector.isSharedEditorCreation(context, calledMethod)) {
            PsiVariable boundVariable = CleanupDetector.getVariableElement(node, true);
            if (CleanupDetector.isEditorCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod method = (UMethod)UastUtils.getParentOfType(node, UMethod.class, true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                    @Override
                    protected boolean isCleanupCall(@NonNull UCallExpression call) {
                        if (CleanupDetector.isEditorApplyMethodCall(this.mContext, call) || CleanupDetector.isEditorCommitMethodCall(this.mContext, call)) {
                            List<UExpression> chain = UastUtils.getQualifiedChain(UastUtils.getOutermostQualified(call));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand2 = chain.get(0);
                            if (operand2 != null) {
                                PsiElement resolved = UastUtils.tryResolve(operand2);
                                if (resolved != null && this.mVariables.contains(resolved)) {
                                    return true;
                                }
                                if (resolved instanceof PsiMethod && operand2 instanceof UCallExpression && CleanupDetector.isEditorCommittedInChainedCalls(this.mContext, (UCallExpression)operand2)) {
                                    while (operand2 instanceof UCallExpression) {
                                        operand2 = ((UCallExpression)operand2).getReceiver();
                                    }
                                    if (operand2 instanceof UReferenceExpression && (resolved = ((UReferenceExpression)operand2).resolve()) != null && this.mVariables.contains(resolved)) {
                                        return true;
                                    }
                                }
                            }
                        }
                        return false;
                    }
                };
                method.accept(commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            } else if (UastUtils.getParentOfType(node, UReturnExpression.class) != null) {
                return;
            }
            String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
            context.report(SHARED_PREF, node, context.getUastLocation(node), message2);
        }
    }

    private static boolean isSharedEditorCreation(@NonNull JavaContext context, @NonNull PsiMethod method) {
        String methodName2 = method.getName();
        if (EDIT.equals(methodName2)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)ANDROID_CONTENT_SHARED_PREFERENCES);
        }
        return false;
    }

    private static boolean isEditorCommittedInChainedCalls(@NonNull JavaContext context, @NonNull UCallExpression node) {
        UCallExpression methodInvocation;
        UExpression lastExpression;
        List<UExpression> chain = UastUtils.getQualifiedChain(UastUtils.getOutermostQualified(node));
        return !chain.isEmpty() && (lastExpression = chain.get(chain.size() - 1)) instanceof UCallExpression && (CleanupDetector.isEditorCommitMethodCall(context, methodInvocation = (UCallExpression)lastExpression) || CleanupDetector.isEditorApplyMethodCall(context, methodInvocation));
    }

    private static boolean isEditorCommitMethodCall(@NonNull JavaContext context, @NonNull UCallExpression call) {
        PsiMethod method;
        String methodName2 = call.getMethodName();
        if (COMMIT.equals(methodName2) && (method = call.resolve()) != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR)) {
                CleanupDetector.suggestApplyIfApplicable(context, call);
                return true;
            }
        }
        return false;
    }

    private static boolean isEditorApplyMethodCall(@NonNull JavaContext context, @NonNull UCallExpression call) {
        PsiMethod method;
        String methodName2 = call.getMethodName();
        if (APPLY.equals(methodName2) && (method = call.resolve()) != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private static void suggestApplyIfApplicable(@NonNull JavaContext context, @NonNull UCallExpression node) {
        if (context.getProject().getMinSdkVersion().getApiLevel() >= 9) {
            UExpression condition2;
            UElement qualifiedNode = node;
            UElement parent = LintUtils.skipParentheses(node.getContainingElement());
            while (parent instanceof UReferenceExpression) {
                qualifiedNode = parent;
                parent = LintUtils.skipParentheses(parent.getContainingElement());
            }
            boolean returnValueIgnored = true;
            if (parent instanceof UCallExpression || parent instanceof UVariable || parent instanceof UBinaryExpression || parent instanceof UUnaryExpression || parent instanceof UReturnExpression) {
                returnValueIgnored = false;
            } else if (parent instanceof UIfExpression) {
                condition2 = ((UIfExpression)parent).getCondition();
                returnValueIgnored = !condition2.equals(qualifiedNode);
            } else if (parent instanceof UWhileExpression) {
                condition2 = ((UWhileExpression)parent).getCondition();
                returnValueIgnored = !condition2.equals(qualifiedNode);
            } else if (parent instanceof UDoWhileExpression) {
                condition2 = ((UDoWhileExpression)parent).getCondition();
                boolean bl = returnValueIgnored = !condition2.equals(qualifiedNode);
            }
            if (returnValueIgnored) {
                String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
                context.report(SHARED_PREF, node, context.getUastLocation(node), message2);
            }
        }
    }

    @Nullable
    public static PsiVariable getVariableElement(@NonNull UCallExpression rhs) {
        return CleanupDetector.getVariableElement(rhs, false);
    }

    @Nullable
    public static PsiVariable getVariableElement(@NonNull UCallExpression rhs, boolean allowChainedCalls) {
        UElement parent = LintUtils.skipParentheses(UastUtils.getQualifiedParentOrThis(rhs).getContainingElement());
        if (allowChainedCalls) {
            while (parent instanceof UQualifiedReferenceExpression) {
                UElement parentParent = LintUtils.skipParentheses(parent.getContainingElement());
                if (parentParent instanceof UQualifiedReferenceExpression) {
                    parent = LintUtils.skipParentheses(parentParent.getContainingElement());
                    continue;
                }
                if (!(parentParent instanceof UVariable) && !(parentParent instanceof UBinaryExpression)) break;
                parent = parentParent;
                break;
            }
        }
        if (UastExpressionUtils.isAssignment(parent)) {
            PsiElement resolved;
            UBinaryExpression assignment = (UBinaryExpression)parent;
            assert (assignment != null);
            UExpression lhs = assignment.getLeftOperand();
            if (lhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lhs).resolve()) instanceof PsiVariable && !(resolved instanceof PsiField)) {
                return (PsiVariable)resolved;
            }
        } else if (parent instanceof UVariable && !(parent instanceof UField)) {
            return ((UVariable)parent).getPsi();
        }
        return null;
    }

    private static boolean isBeginTransaction(@NonNull JavaContext context, @NonNull PsiMethod method) {
        String methodName2 = method.getName();
        if (BEGIN_TRANSACTION.equals(methodName2)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)FRAGMENT_MANAGER_CLS) || InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)FRAGMENT_MANAGER_V4_CLS)) {
                return true;
            }
        }
        return false;
    }

    private static abstract class FinishVisitor
    extends AbstractUastVisitor {
        protected final JavaContext mContext;
        protected final List<PsiVariable> mVariables;
        private final PsiVariable mOriginalVariableNode;
        private boolean mContainsCleanup;
        private boolean mEscapes;

        public FinishVisitor(JavaContext context, @NonNull PsiVariable variableNode) {
            this.mContext = context;
            this.mOriginalVariableNode = variableNode;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variableNode});
        }

        public boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        @Override
        public boolean visitElement(UElement node) {
            return this.mContainsCleanup || super.visitElement(node);
        }

        protected abstract boolean isCleanupCall(@NonNull UCallExpression var1);

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            if (node.getKind() == UastCallKind.METHOD_CALL) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression call) {
            if (this.mContainsCleanup) {
                return;
            }
            if (!this.mEscapes) {
                for (UExpression expression2 : call.getValueArguments()) {
                    PsiMethod method;
                    PsiElement resolved;
                    if (!(expression2 instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)expression2).resolve()) == null || !this.mVariables.contains(resolved)) continue;
                    boolean wasEscaped = this.mEscapes;
                    this.mEscapes = true;
                    if (!CleanupDetector.OBTAIN.equals(call.getMethodName()) || !JavaEvaluator.isMemberInClass((PsiMember)(method = call.resolve()), CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.mEscapes = wasEscaped;
                }
            }
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
            }
        }

        @Override
        public boolean visitVariable(UVariable variable2) {
            PsiElement resolved;
            UExpression initializer;
            if (variable2 instanceof ULocalVariable && (initializer = variable2.getUastInitializer()) instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mVariables.add(variable2.getPsi());
            }
            return super.visitVariable(variable2);
        }

        @Override
        public boolean visitBinaryExpression(UBinaryExpression expression2) {
            PsiElement lhs;
            PsiElement resolved;
            if (!UastExpressionUtils.isAssignment(expression2)) {
                return super.visitBinaryExpression(expression2);
            }
            boolean clearLhs = false;
            UExpression rhs = expression2.getRightOperand();
            if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                clearLhs = false;
                PsiElement lhs2 = UastUtils.tryResolve(expression2.getLeftOperand());
                if (lhs2 instanceof PsiLocalVariable) {
                    this.mVariables.add((PsiVariable)((PsiLocalVariable)lhs2));
                } else if (lhs2 instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            if (clearLhs && (lhs = UastUtils.tryResolve(expression2.getLeftOperand())) != null && !lhs.equals(this.mOriginalVariableNode) && this.mVariables.contains(lhs)) {
                this.mVariables.remove(lhs);
            }
            return super.visitBinaryExpression(expression2);
        }

        @Override
        public boolean visitReturnExpression(UReturnExpression node) {
            PsiElement resolved;
            UExpression returnValue = node.getReturnExpression();
            if (returnValue instanceof UReferenceExpression && (resolved = ((UReferenceExpression)returnValue).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mEscapes = true;
            }
            return super.visitReturnExpression(node);
        }
    }
}

