/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.checks.ApiLookup;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.inspections.klint.IntellijLintUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInstanceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class IntellijApiDetector
extends ApiDetector {
    public static final Implementation IMPLEMENTATION = new Implementation(IntellijApiDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE);
    @NonNls
    private static final String TARGET_API_FQCN = "android.annotation.TargetApi";

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UFile.class);
    }

    @Override
    public UastVisitor createUastVisitor(final @NonNull JavaContext context) {
        return new AbstractUastVisitor(){

            @Override
            public boolean visitFile(@NotNull UFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/klint/IntellijApiDetector$1", "visitFile"));
                }
                List<UClass> classes2 = file.getClasses();
                if (!classes2.isEmpty()) {
                    file.accept(new ApiCheckVisitor(context, classes2.get(0), file));
                }
                return super.visitFile(file);
            }
        };
    }

    private static int getTargetApi(@NonNull UElement e, @NonNull UFile file) {
        for (UElement element = e; element != null && element != file; element = element.getContainingElement()) {
            if (!(element instanceof UAnnotated)) continue;
            UAnnotated owner = (UAnnotated)element;
            UAnnotation annotation = owner.findAnnotation(TARGET_API_FQCN);
            if (annotation == null) {
                annotation = owner.findAnnotation("android.support.annotation.RequiresApi");
            }
            if (annotation == null) continue;
            for (UNamedExpression pair : annotation.getAttributeValues()) {
                UExpression v = pair.getExpression();
                if (v instanceof ULiteralExpression) {
                    ULiteralExpression literal = (ULiteralExpression)v;
                    Iterator<UExpression> value2 = literal.getValue();
                    if (value2 instanceof Integer) {
                        return (Integer)((Object)value2);
                    }
                    if (!(value2 instanceof String)) continue;
                    return IntellijApiDetector.codeNameToApi((String)((Object)value2));
                }
                if (UastExpressionUtils.isArrayInitializer(v)) {
                    UCallExpression mv = (UCallExpression)v;
                    for (UExpression mmv : mv.getValueArguments()) {
                        if (!(mmv instanceof ULiteralExpression)) continue;
                        ULiteralExpression literal = (ULiteralExpression)mmv;
                        Object value3 = literal.getValue();
                        if (value3 instanceof Integer) {
                            return (Integer)value3;
                        }
                        if (!(value3 instanceof String)) continue;
                        return IntellijApiDetector.codeNameToApi((String)value3);
                    }
                    continue;
                }
                if (!(v instanceof UResolvable)) continue;
                PsiElement resolved = ((UResolvable)((Object)v)).resolve();
                if (resolved != null) {
                    String fqcn = UastLintUtils.getQualifiedName(resolved);
                    return IntellijApiDetector.codeNameToApi(fqcn);
                }
                return IntellijApiDetector.codeNameToApi(v.asRenderString());
            }
        }
        return -1;
    }

    private class ApiCheckVisitor
    extends AbstractUastVisitor {
        private final JavaContext myContext;
        private boolean mySeenSuppress;
        private boolean mySeenTargetApi;
        private final UClass myClass;
        private final UFile myFile;
        private final boolean myCheckAccess;
        private boolean myCheckOverride;
        private String myFrameworkParent;

        public ApiCheckVisitor(JavaContext context, UClass clz, UFile file) {
            this.myContext = context;
            this.myClass = clz;
            this.myFile = file;
            this.myCheckAccess = context.isEnabled(ApiDetector.UNSUPPORTED) || context.isEnabled(ApiDetector.INLINED);
            this.myCheckOverride = context.isEnabled(ApiDetector.OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
            int depth = 0;
            if (this.myCheckOverride) {
                this.myFrameworkParent = null;
                for (UClass superClass = this.myClass.getUastSuperClass(); superClass != null; superClass = superClass.getUastSuperClass()) {
                    String fqcn = superClass.getQualifiedName();
                    if (fqcn == null) {
                        this.myCheckOverride = false;
                        continue;
                    }
                    if (!fqcn.startsWith("android.") && !fqcn.startsWith("java.") && !fqcn.startsWith("javax.")) continue;
                    if (fqcn.equals("java.lang.Object")) break;
                    this.myFrameworkParent = ClassContext.getInternalName(fqcn);
                    break;
                }
                if (this.myFrameworkParent == null) {
                    this.myCheckOverride = false;
                }
            }
        }

        @Override
        public boolean visitAnnotation(@NotNull UAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitAnnotation"));
            }
            String fqcn = annotation.getQualifiedName();
            if (IntellijApiDetector.TARGET_API_FQCN.equals(fqcn) || "android.support.annotation.RequiresApi".equals(fqcn)) {
                this.mySeenTargetApi = true;
            } else if ("android.annotation.SuppressLint".equals(fqcn) || "java.lang.SuppressWarnings".equals(fqcn)) {
                this.mySeenSuppress = true;
            }
            return super.visitAnnotation(annotation);
        }

        @Override
        public boolean visitMethod(@NotNull UMethod method) {
            int minSdk;
            int api;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitMethod"));
            }
            if (method.getModifierList().hasExplicitModifier("default") && !this.isSuppressed(api = 24, method, minSdk = IntellijApiDetector.this.getMinSdk(this.myContext))) {
                Location location = IntellijLintUtils.getUastLocation(this.myContext.file, method);
                String message2 = String.format("Default method requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
            }
            if (!this.myCheckOverride) {
                return super.visitMethod(method);
            }
            int buildSdk = this.myContext.getMainProject().getBuildSdk();
            String name = method.getName();
            assert (this.myFrameworkParent != null);
            String desc = IntellijLintUtils.getInternalDescription(method, false, false);
            if (desc == null) {
                return super.visitMethod(method);
            }
            int api2 = IntellijApiDetector.this.mApiDatabase.getCallVersion(this.myFrameworkParent, name, desc);
            if (api2 > buildSdk && buildSdk != -1) {
                String fqcn;
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)method, this.myFile.getPsi(), ApiDetector.OVERRIDE)) {
                    return super.visitMethod(method);
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    String className = containingClass.getName();
                    String fullClassName = containingClass.getQualifiedName();
                    if (fullClassName != null) {
                        className = fullClassName;
                    }
                    fqcn = className + '#' + name;
                } else {
                    fqcn = name;
                }
                String message3 = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api2, buildSdk, fqcn);
                Object locationNode = method.getNameIdentifier();
                if (locationNode == null) {
                    locationNode = method;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)locationNode);
                this.myContext.report(ApiDetector.OVERRIDE, location, message3);
            }
            return super.visitMethod(method);
        }

        @Override
        public boolean visitClass(@NotNull UClass aClass) {
            String message2;
            PsiModifierList modifierList;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitClass"));
            }
            if (!this.myCheckAccess) {
                return super.visitClass(aClass);
            }
            if (aClass.isAnnotationType() && (modifierList = aClass.getModifierList()) != null) {
                PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                int n = psiAnnotationArray.length;
                for (int i = 0; i < n; ++i) {
                    int minSdk;
                    int api;
                    PsiAnnotation annotation = psiAnnotationArray[i];
                    String name = annotation.getQualifiedName();
                    if (!"java.lang.annotation.Repeatable".equals(name) || this.isSuppressed(api = 24, aClass, minSdk = IntellijApiDetector.this.getMinSdk(this.myContext))) continue;
                    Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)annotation);
                    message2 = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, minSdk);
                    this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
                }
            }
            for (PsiClassType type2 : aClass.getSuperTypes()) {
                Location location;
                int target;
                int minSdk;
                int api;
                String signature = IntellijLintUtils.getInternalName(type2);
                if (signature == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(aClass, this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)aClass, this.myFile.getPsi(), ApiDetector.UNSUPPORTED)) continue;
                if (type2 instanceof PsiClassReferenceType) {
                    PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)type2).getReference();
                    PsiElement element = reference.getElement();
                    if (ApiDetector.isWithinVersionCheckConditional(aClass, api, this.myContext) || IntellijApiDetector.isPrecededByVersionCheckExit(aClass, api, this.myContext)) continue;
                    location = IntellijLintUtils.getLocation(this.myContext.file, element);
                } else {
                    location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)aClass);
                }
                String fqcn = type2.getClassName();
                message2 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
            }
            return super.visitClass(aClass);
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitSimpleNameReferenceExpression"));
            }
            if (!this.myCheckAccess) {
                return super.visitSimpleNameReferenceExpression(expression2);
            }
            PsiElement resolved = expression2.resolve();
            if (resolved != null && resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return super.visitSimpleNameReferenceExpression(expression2);
                }
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return super.visitSimpleNameReferenceExpression(expression2);
                }
                String name = field.getName();
                if (name == null) {
                    return super.visitSimpleNameReferenceExpression(expression2);
                }
                int api = IntellijApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
                if (api == -1) {
                    return super.visitSimpleNameReferenceExpression(expression2);
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, expression2, minSdk)) {
                    return super.visitSimpleNameReferenceExpression(expression2);
                }
                Location location = IntellijLintUtils.getUastLocation(this.myContext.file, expression2);
                String fqcn = containingClass.getQualifiedName();
                String message2 = String.format("Field requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + name);
                Issue issue = ApiDetector.UNSUPPORTED;
                PsiType type2 = field.getType();
                if (PsiType.INT.equals((Object)type2) || PsiType.CHAR.equals((Object)type2) || PsiType.BOOLEAN.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || type2.equalsToText("java.lang.String")) {
                    issue = ApiDetector.INLINED;
                    if (ApiDetector.isBenignConstantUsage(expression2, name, owner)) {
                        return super.visitSimpleNameReferenceExpression(expression2);
                    }
                }
                this.myContext.report(issue, location, message2);
            }
            return super.visitSimpleNameReferenceExpression(expression2);
        }

        @Override
        public boolean visitTryExpression(@NotNull UTryExpression statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitTryExpression"));
            }
            List<PsiResourceListElement> resourceList = statement.getResources();
            if (resourceList != null) {
                int api = 19;
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, statement, minSdk)) {
                    return super.visitTryExpression(statement);
                }
                Location location = IntellijLintUtils.getUastLocation(this.myContext.file, statement.getTryClause());
                String string = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, string);
            }
            for (UCatchClause catchClause : statement.getCatchClauses()) {
                for (PsiParameter psiParameter : catchClause.getParameters()) {
                    PsiTypeElement typeElement = psiParameter.getTypeElement();
                    if (typeElement == null) continue;
                    this.checkCatchTypeElement(statement, typeElement, typeElement.getType());
                }
            }
            return super.visitTryExpression(statement);
        }

        private void checkCatchTypeElement(@NonNull UTryExpression statement, @NotNull PsiTypeElement typeElement, @Nullable PsiType type2) {
            if (typeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "checkCatchTypeElement"));
            }
            PsiClass resolved = null;
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                if ((type2 = disjunctionType.getLeastUpperBound()) instanceof PsiClassType) {
                    resolved = ((PsiClassType)type2).resolve();
                }
                for (PsiElement child : typeElement.getChildren()) {
                    PsiTypeElement childTypeElement;
                    PsiType childType;
                    if (!(child instanceof PsiTypeElement) || type2.equals(childType = (childTypeElement = (PsiTypeElement)child).getType())) continue;
                    this.checkCatchTypeElement(statement, childTypeElement, childType);
                }
            } else if (type2 instanceof PsiClassReferenceType) {
                PsiClassReferenceType referenceType = (PsiClassReferenceType)type2;
                resolved = referenceType.resolve();
            } else if (type2 instanceof PsiClassType) {
                resolved = ((PsiClassType)type2).resolve();
            }
            if (resolved != null) {
                int target;
                String signature = IntellijLintUtils.getInternalName(resolved);
                if (signature == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(statement, this.myFile)) != -1 && api <= target) {
                    return;
                }
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed(statement, this.myFile, ApiDetector.UNSUPPORTED)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)typeElement);
                String fqcn = resolved.getName();
                String message2 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                if (api == 19 && "ReflectiveOperationException".equals(fqcn)) {
                    message2 = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api, minSdk);
                }
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
            }
        }

        private boolean isSuppressed(int api, UElement element, int minSdk) {
            int target;
            if (api <= minSdk) {
                return true;
            }
            if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(element, this.myFile)) != -1 && api <= target) {
                return true;
            }
            if (this.mySeenSuppress && (IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.UNSUPPORTED) || IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.INLINED))) {
                return true;
            }
            if (ApiDetector.isWithinVersionCheckConditional(element, api, this.myContext)) {
                return true;
            }
            return IntellijApiDetector.isPrecededByVersionCheckExit(element, api, this.myContext);
        }

        @Override
        public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitBinaryExpressionWithType"));
            }
            if (this.myCheckAccess) {
                UExpression operand2 = expression2.getOperand();
                PsiType operandType = operand2.getExpressionType();
                PsiType castType = expression2.getType();
                if (castType.equals(operandType)) {
                    return super.visitBinaryExpressionWithType(expression2);
                }
                if (!(operandType instanceof PsiClassType)) {
                    return super.visitBinaryExpressionWithType(expression2);
                }
                if (!(castType instanceof PsiClassType)) {
                    return super.visitBinaryExpressionWithType(expression2);
                }
                PsiClassType classType = (PsiClassType)operandType;
                PsiClassType interfaceType = (PsiClassType)castType;
                this.checkCast(expression2, classType, interfaceType);
            }
            return super.visitBinaryExpressionWithType(expression2);
        }

        private void checkCast(@NotNull UElement node, @NotNull PsiClassType classType, @NotNull PsiClassType interfaceType) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "checkCast"));
            }
            if (classType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "checkCast"));
            }
            if (interfaceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceType", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "checkCast"));
            }
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            String classTypeInternal = IntellijLintUtils.getInternalName(classType);
            String interfaceTypeInternal = IntellijLintUtils.getInternalName(interfaceType);
            if (classTypeInternal == null || interfaceTypeInternal == null || "java/lang/Object".equals(interfaceTypeInternal)) {
                return;
            }
            int api = IntellijApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
            if (api <= minSdk) {
                return;
            }
            if (this.isSuppressed(api, node, minSdk)) {
                return;
            }
            Location location = IntellijLintUtils.getUastLocation(this.myContext.file, node);
            String message2 = String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", classType.getClassName(), interfaceType.getClassName(), api, minSdk);
            this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
        }

        @Override
        public boolean visitVariable(@NotNull UVariable variable2) {
            if (variable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitVariable"));
            }
            if (variable2 instanceof ULocalVariable) {
                if (!this.myCheckAccess) {
                    return super.visitVariable(variable2);
                }
                UExpression initializer = variable2.getUastInitializer();
                if (initializer == null) {
                    return super.visitVariable(variable2);
                }
                PsiType initializerType = initializer.getExpressionType();
                if (initializerType == null || !(initializerType instanceof PsiClassType)) {
                    return super.visitVariable(variable2);
                }
                PsiType interfaceType = variable2.getType();
                if (initializerType.equals(interfaceType)) {
                    return super.visitVariable(variable2);
                }
                if (!(interfaceType instanceof PsiClassType)) {
                    return super.visitVariable(variable2);
                }
                this.checkCast(initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
            }
            return super.visitVariable(variable2);
        }

        @Override
        public boolean visitBinaryExpression(@NotNull UBinaryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitBinaryExpression"));
            }
            if (expression2.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                if (!this.myCheckAccess) {
                    return super.visitBinaryExpression(expression2);
                }
                UExpression rExpression = expression2.getRightOperand();
                PsiType rhsType = rExpression.getExpressionType();
                if (rhsType == null || !(rhsType instanceof PsiClassType)) {
                    return super.visitBinaryExpression(expression2);
                }
                PsiType interfaceType = expression2.getLeftOperand().getExpressionType();
                if (rhsType.equals(interfaceType)) {
                    return super.visitBinaryExpression(expression2);
                }
                if (!(interfaceType instanceof PsiClassType)) {
                    return super.visitBinaryExpression(expression2);
                }
                this.checkCast(rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
            }
            return super.visitBinaryExpression(expression2);
        }

        @Override
        public boolean visitForEachExpression(@NotNull UForEachExpression statement) {
            String expressionOwner;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitForEachExpression"));
            }
            if (!this.myCheckAccess) {
                return super.visitForEachExpression(statement);
            }
            UExpression value2 = statement.getIteratedValue();
            PsiType type2 = value2.getExpressionType();
            if (type2 instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type2)) != null) {
                PsiMethod keySet;
                PsiMethodCallExpression valueCall;
                int target;
                int api = IntellijApiDetector.this.mApiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return super.visitForEachExpression(statement);
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return super.visitForEachExpression(statement);
                }
                if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(statement, this.myFile)) != -1 && api <= target) {
                    return super.visitForEachExpression(statement);
                }
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed(statement, this.myFile, ApiDetector.UNSUPPORTED)) {
                    return super.visitForEachExpression(statement);
                }
                if (ApiDetector.isWithinVersionCheckConditional(statement, api, this.myContext)) {
                    return super.visitForEachExpression(statement);
                }
                if (IntellijApiDetector.isPrecededByVersionCheckExit(statement, api, this.myContext)) {
                    return super.visitForEachExpression(statement);
                }
                Location location = IntellijLintUtils.getUastLocation(this.myContext.file, value2);
                String message2 = String.format("The type of the for loop iterated value is %1$s, which requires API level %2$d (current min is %3$d)", type2.getCanonicalText(), api, minSdk);
                if (value2 instanceof PsiMethodCallExpression && "keySet".equals((valueCall = (PsiMethodCallExpression)value2).getMethodExpression().getReferenceName()) && (keySet = valueCall.resolveMethod()) != null && keySet.getContainingClass() != null && "java.util.concurrent.ConcurrentHashMap".equals(keySet.getContainingClass().getQualifiedName())) {
                    message2 = message2 + "; to work around this, add an explicit cast to (Map) before the `keySet` call.";
                }
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
            }
            return super.visitForEachExpression(statement);
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "visitCallExpression"));
            }
            this.checkMethodCallExpression(node);
            return super.visitCallExpression(node);
        }

        private void checkMethodCallExpression(@NotNull UCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/klint/IntellijApiDetector$ApiCheckVisitor", "checkMethodCallExpression"));
            }
            super.visitCallExpression(expression2);
            if (!this.myCheckAccess) {
                return;
            }
            PsiMethod method = expression2.resolve();
            if (method != null) {
                PsiMethod containingMethod;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() > 0) {
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    List<UExpression> arguments = expression2.getValueArguments();
                    for (int i = 0; i < parameters2.length; ++i) {
                        PsiType parameterType = parameters2[i].getType();
                        if (!(parameterType instanceof PsiClassType)) continue;
                        if (i >= arguments.size()) break;
                        UExpression argument = arguments.get(i);
                        PsiType argumentType = argument.getExpressionType();
                        if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                        this.checkCast(argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                    }
                }
                String fqcn = containingClass.getQualifiedName();
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = IntellijLintUtils.getInternalMethodName(method);
                String desc = IntellijLintUtils.getInternalDescription(method, false, false);
                if (desc == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (UastExpressionUtils.isMethodCall(expression2)) {
                    UExpression qualifier = expression2.getReceiver();
                    if (qualifier != null && !(qualifier instanceof UThisExpression) && !(qualifier instanceof USuperExpression)) {
                        String expressionOwner;
                        PsiType type2 = qualifier.getExpressionType();
                        if (type2 != null && type2 instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type2)) != null && !expressionOwner.equals(owner)) {
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (ApiLookup.isRelevantOwner(expressionOwner)) {
                                    return;
                                }
                            } else {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                            }
                        }
                    } else {
                        UInstanceExpression pte;
                        PsiElement resolved;
                        PsiClass cls = UastUtils.getContainingClass(expression2);
                        if ((qualifier instanceof UThisExpression || qualifier instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)qualifier).resolve()) instanceof PsiClass) {
                            cls = (PsiClass)resolved;
                        }
                        while (cls != null) {
                            String expressionOwner;
                            if (cls instanceof PsiAnonymousClass) {
                                boolean found = false;
                                PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                                PsiClass anonymousBase = anonymousBaseType.resolve();
                                if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                    cls = anonymousBase;
                                    found = true;
                                } else {
                                    PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                    if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                        cls = surroundingBaseType;
                                        found = true;
                                    }
                                }
                                if (!found) break;
                            }
                            if ((expressionOwner = IntellijLintUtils.getInternalName(cls)) == null) break;
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi != -1) {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                                break;
                            }
                            if (ApiLookup.isRelevantOwner(expressionOwner)) {
                                return;
                            }
                            cls = cls.getSuperClass();
                        }
                    }
                }
                if (this.isSuppressed(api, expression2, minSdk)) {
                    return;
                }
                if (UastExpressionUtils.isMethodCall(expression2) && expression2.getReceiver() instanceof USuperExpression && (containingMethod = UastUtils.getContainingMethod(expression2)) != null && name.equals(containingMethod.getName()) && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)containingMethod) && !method.isConstructor()) {
                    return;
                }
                UElement locationNode = expression2.getMethodIdentifier();
                if (locationNode == null) {
                    locationNode = expression2;
                }
                Location location = IntellijLintUtils.getUastLocation(this.myContext.file, locationNode);
                String message2 = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message2);
            }
        }
    }
}

