/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.GlassfishUtil;
import com.intellij.javaee.oss.glassfish.server.GlassfishRemoteEditor;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerModel;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelData;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelDelegate;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class GlassfishRemoteModel
extends GlassfishServerModel
implements SimpleRemoteServerModel {
    @NonNls
    private static final String DATA_ELEMENT = "data";
    public static int DEFAULT_ADMIN_PORT = 4848;
    private static boolean DEFAULT_UPLOAD_WITH_GLASSFISH = true;
    private static boolean DEFAULT_SECURED = false;
    public int ADMIN_PORT = DEFAULT_ADMIN_PORT;
    private boolean myUploadWithGlassfish = DEFAULT_UPLOAD_WITH_GLASSFISH;
    private boolean mySecured = DEFAULT_SECURED;
    public String ADMIN_SERVER_HOST;
    public String CLUSTER_NAME;
    public boolean DEPLOY_ON_CLUSTER = false;
    private SimpleRemoteServerModelDelegate myTransportDelegate = new SimpleRemoteServerModelDelegate().init((SimpleRemoteServerModel)this);

    public SettingsEditor<CommonModel> getEditor() {
        return new GlassfishRemoteEditor();
    }

    public boolean isUploadWithGlassfish() {
        return this.myUploadWithGlassfish;
    }

    public void setUploadWithGlassfish(boolean uploadWithGlassfish) {
        this.myUploadWithGlassfish = uploadWithGlassfish;
    }

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTarget getTransportStagingTarget() {
        return this.myTransportDelegate.getTransportStagingTarget();
    }

    public void setTransportStagingTarget(TransportTarget transportStagingTarget) {
        this.myTransportDelegate.setTransportStagingTarget(transportStagingTarget);
    }

    public String getStagingRemotePath() {
        return this.myTransportDelegate.getStagingRemotePath();
    }

    public void setStagingRemotePath(String stagingRemotePath) {
        this.myTransportDelegate.setStagingRemotePath(stagingRemotePath);
    }

    @Override
    public boolean isSecured() {
        return this.mySecured;
    }

    public void setSecured(boolean secured) {
        this.mySecured = secured;
    }

    public String prepareDeployment(String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(sourcePath, prepareNameOnly);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.ADMIN_PORT <= 0) {
            throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishRemoteModel.error.admin", new Object[0]));
        }
        if (this.myUploadWithGlassfish) {
            CommonModel commonModel = this.getCommonModel();
            if (!JavaeeServerInstanceImpl.isLocalhost((CommonModel)commonModel)) {
                for (DeploymentModel deploymentModel : commonModel.getDeploymentModels()) {
                    if (deploymentModel.getDeploymentSource().isArchive()) continue;
                    throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishRemoteModel.error.cant.upload.exploded", new Object[0]));
                }
            }
        } else {
            this.myTransportDelegate.checkConfiguration();
        }
        super.checkConfiguration();
    }

    public boolean isDeployAllowed() {
        return this.myUploadWithGlassfish || this.myTransportDelegate.isDeployAllowed();
    }

    public boolean isClusterSupported() {
        return GlassfishUtil.isGlassfish31Plus(this.getVersion());
    }

    public boolean isDeployOnCluster() {
        return this.DEPLOY_ON_CLUSTER;
    }

    public String getAdminServerHost() {
        return this.isDeployOnCluster() ? this.ADMIN_SERVER_HOST : this.getServerHost();
    }

    public int getAdminServerPort() {
        return this.ADMIN_PORT;
    }

    protected int getServerPort() {
        return this.isDeployOnCluster() ? this.getCommonModel().getPort() : this.ADMIN_PORT;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            super.readExternal(element);
            this.myUploadWithGlassfish = DEFAULT_UPLOAD_WITH_GLASSFISH;
            this.mySecured = DEFAULT_SECURED;
        } else {
            GlassfishRemoteModelData settings = (GlassfishRemoteModelData)((Object)XmlSerializer.deserialize((Element)dataElement, GlassfishRemoteModelData.class));
            if (settings == null) {
                return;
            }
            this.myTransportDelegate.readFromData((SimpleRemoteServerModelData)settings);
            this.myUploadWithGlassfish = settings.isUploadWithGlassfish();
            this.mySecured = settings.isSecured();
            this.ADMIN_PORT = settings.getAdminPort();
            this.USERNAME = settings.getUsername();
            this.PASSWORD = settings.getPassword();
            this.PRESERVE = settings.isPreserve();
            this.COMPATIBILITY = settings.isCompatibility();
            this.VIRTUAL_SERVER = settings.getVirtualServer();
            this.ADMIN_SERVER_HOST = settings.getAdminServerHost();
            this.CLUSTER_NAME = settings.getClusterName();
            this.DEPLOY_ON_CLUSTER = settings.isDeployOnCluster();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        GlassfishRemoteModelData settings = new GlassfishRemoteModelData();
        this.myTransportDelegate.writeToData((SimpleRemoteServerModelData)settings);
        settings.setUploadWithGlassfish(this.myUploadWithGlassfish);
        settings.setSecured(this.mySecured);
        settings.setAdminPort(this.ADMIN_PORT);
        settings.setUsername(this.USERNAME);
        settings.setPassword(this.PASSWORD);
        settings.setPreserve(this.PRESERVE);
        settings.setCompatibility(this.COMPATIBILITY);
        settings.setVirtualServer(this.VIRTUAL_SERVER);
        settings.setAdminServerHost(this.ADMIN_SERVER_HOST);
        settings.setClusterName(this.CLUSTER_NAME);
        settings.setDeployOnCluster(this.DEPLOY_ON_CLUSTER);
        Element dataElement = XmlSerializer.serialize((Object)((Object)settings), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public Object clone() throws CloneNotSupportedException {
        GlassfishRemoteModel result = (GlassfishRemoteModel)((Object)super.clone());
        result.myTransportDelegate = ((SimpleRemoteServerModelDelegate)this.myTransportDelegate.clone()).init((SimpleRemoteServerModel)result);
        return result;
    }

    static /* synthetic */ boolean access$000() {
        return DEFAULT_UPLOAD_WITH_GLASSFISH;
    }

    static /* synthetic */ boolean access$100() {
        return DEFAULT_SECURED;
    }

    @Tag(value="data")
    public static class GlassfishRemoteModelData
    extends SimpleRemoteServerModelData {
        @Tag(value="username")
        private String myUsername = GlassfishServerModel.doGetDefaultUsername();
        @Tag(value="password")
        private String myPassword = GlassfishServerModel.doGetDefaultPassword();
        @Tag(value="preserve")
        private boolean myPreserve;
        @Tag(value="compatibility")
        private boolean myCompatibility;
        @Tag(value="admin-port")
        private int myAdminPort = DEFAULT_ADMIN_PORT;
        @Tag(value="upload-with-glassfish")
        private boolean myUploadWithGlassfish = GlassfishRemoteModel.access$000();
        @Tag(value="secured")
        private boolean mySecured = GlassfishRemoteModel.access$100();
        @Tag(value="virtual-server")
        private String myVirtualServer;
        @Tag(value="admin-server-host")
        private String myAdminServerHost;
        @Tag(value="cluster-name")
        private String myClusterName;
        @Tag(value="deploy-\u043en-\u0441luster")
        private boolean myDeployOnCluster;

        public int getAdminPort() {
            return this.myAdminPort;
        }

        public void setAdminPort(int adminPort) {
            this.myAdminPort = adminPort;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isPreserve() {
            return this.myPreserve;
        }

        public boolean isCompatibility() {
            return this.myCompatibility;
        }

        public void setPreserve(boolean preserve) {
            this.myPreserve = preserve;
        }

        public void setCompatibility(boolean compatibility) {
            this.myCompatibility = compatibility;
        }

        public boolean isUploadWithGlassfish() {
            return this.myUploadWithGlassfish;
        }

        public void setUploadWithGlassfish(boolean uploadWithGlassfish) {
            this.myUploadWithGlassfish = uploadWithGlassfish;
        }

        public boolean isSecured() {
            return this.mySecured;
        }

        public void setSecured(boolean secured) {
            this.mySecured = secured;
        }

        public String getVirtualServer() {
            return this.myVirtualServer;
        }

        public void setVirtualServer(String virtualServer) {
            this.myVirtualServer = virtualServer;
        }

        public String getAdminServerHost() {
            return this.myAdminServerHost;
        }

        public void setAdminServerHost(String adminServerHost) {
            this.myAdminServerHost = adminServerHost;
        }

        public String getClusterName() {
            return this.myClusterName;
        }

        public void setClusterName(String clusterName) {
            this.myClusterName = clusterName;
        }

        public boolean isDeployOnCluster() {
            return this.myDeployOnCluster;
        }

        public void setDeployOnCluster(boolean deployOnCluster) {
            this.myDeployOnCluster = deployOnCluster;
        }
    }
}

