/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.guice.GuiceBundle;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProviderDialog
extends DialogWrapper
implements DocumentListener {
    private JTextField providerNameField = null;
    private JTextField providedClassField = null;
    private FixedSizeButton classChooserButton = null;
    private final Project project;

    protected ProviderDialog(Project project) {
        super(project, true);
        this.project = project;
        this.setModal(true);
        this.setTitle("New Guice Provider");
        this.init();
        this.validateButtons();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "GuiceyIDEA.NewGuiceProvider";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = JBUI.emptyInsets();
        JPanel classNamePanel = new JPanel(new BorderLayout());
        JLabel label1 = new JLabel("Provider Class Name:");
        this.providerNameField = new JTextField();
        this.providerNameField.getDocument().addDocumentListener(this);
        label1.setDisplayedMnemonic('P');
        label1.setLabelFor(this.providerNameField);
        classNamePanel.add((Component)label1, "West");
        classNamePanel.add((Component)this.providerNameField, "Center");
        panel.add((Component)classNamePanel, gbConstraints);
        this.providedClassField = new JTextField();
        this.providedClassField.getDocument().addDocumentListener(this);
        this.classChooserButton = new FixedSizeButton((JComponent)this.providedClassField);
        this.classChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)ProviderDialog.this.project);
                TreeJavaClassChooserDialog chooser = new TreeJavaClassChooserDialog(GuiceBundle.message("select.provided.class", new Object[0]), ProviderDialog.this.project, scope, null, null);
                String classText = ProviderDialog.this.classChooserButton.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)ProviderDialog.this.project).findClass(classText, GlobalSearchScope.allScope((Project)ProviderDialog.this.project));
                if (currentClass != null) {
                    chooser.select((PsiNamedElement)currentClass);
                }
                chooser.show();
                PsiClass selectedClass = (PsiClass)chooser.getSelected();
                if (selectedClass != null) {
                    String className = selectedClass.getQualifiedName();
                    ProviderDialog.this.providedClassField.setText(className);
                    ProviderDialog.this.validateButtons();
                }
            }
        });
        panel.add((Component)this.classChooserButton, gbConstraints);
        JPanel existingClassPanel = new JPanel(new BorderLayout());
        JLabel label2 = new JLabel("Class Provided:");
        label2.setLabelFor(this.providedClassField);
        label2.setDisplayedMnemonic('C');
        existingClassPanel.add((Component)label2, "West");
        existingClassPanel.add((Component)this.providedClassField, "Center");
        existingClassPanel.add((Component)this.classChooserButton, "East");
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.gridwidth = 3;
        panel.add((Component)existingClassPanel, gbConstraints);
        return panel;
    }

    public String getProviderName() {
        return this.providerNameField.getText();
    }

    private void validateButtons() {
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.project);
        String providerName = this.getProviderName();
        String providedClass = this.getProvidedClass();
        boolean valid = nameHelper.isIdentifier(providerName) && nameHelper.isQualifiedName(providedClass);
        this.getOKAction().setEnabled(valid);
    }

    public String getProvidedClass() {
        return this.providedClassField.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.validateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.validateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.validateButtons();
    }
}

