/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;

public class MoveBindingScopeToClassPredicate
implements PsiElementPredicate {
    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!GuiceUtils.isBinding(element)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (GuiceUtils.findScopeForBinding(call) == null) {
            return false;
        }
        PsiMethodCallExpression scopeCall = GuiceUtils.findScopeCallForBinding(call);
        PsiExpression arg = scopeCall.getArgumentList().getExpressions()[0];
        String scopeAnnotation = GuiceUtils.getScopeAnnotationForScopeExpression(arg);
        if (scopeAnnotation == null) {
            return false;
        }
        PsiClass implementingClass = GuiceUtils.findImplementingClassForBinding(call);
        if (implementingClass == null) {
            return false;
        }
        return !AnnotationUtil.isAnnotated((PsiModifierListOwner)implementingClass, (String)"com.google.inject.Singleton", (boolean)true) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)implementingClass, (String)"com.google.inject.servlet.RequestScoped", (boolean)false) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)implementingClass, (String)"com.google.inject.servlet.SessionScoped", (boolean)false);
    }
}

