/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model.renderers;

import com.intellij.guice.utils.GuiceUtils;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import icons.GuiceIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceBindingClassPsiElementListCellRenderer
extends PsiElementListCellRenderer {
    public String getElementText(PsiElement element) {
        StringBuilder sb;
        PsiMethodCallExpression methodCallExpression;
        if (element instanceof PsiMethodCallExpression && GuiceBindingClassPsiElementListCellRenderer.addExpressionText(methodCallExpression = (PsiMethodCallExpression)element, sb = new StringBuilder(), "bind", true)) {
            GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "annotatedWith");
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "to")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toInstance")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toProvider")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toConstructor")) {
                return sb.toString();
            }
        }
        return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
    }

    private static boolean addToBinding(@NotNull PsiMethodCallExpression element, @NotNull StringBuilder sb, @NotNull String methodName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addToBinding"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addToBinding"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addToBinding"));
        }
        return GuiceBindingClassPsiElementListCellRenderer.addExpressionText(element, sb, methodName, false);
    }

    private static boolean addExpressionText(@NotNull PsiMethodCallExpression element, @NotNull StringBuilder sb, @NotNull String methodName, boolean firstElementInChain) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addExpressionText"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addExpressionText"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "addExpressionText"));
        }
        PsiMethodCallExpression to = GuiceUtils.findCallInChain(element, methodName);
        if (to != null) {
            if (!firstElementInChain) {
                sb.append(".");
            }
            sb.append(methodName);
            sb.append("(");
            sb.append(GuiceBindingClassPsiElementListCellRenderer.getExpressionText(to.getArgumentList().getExpressions()[0]));
            sb.append(")");
            return true;
        }
        return false;
    }

    private static String getExpressionText(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer", "getExpressionText"));
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            return expression.getText();
        }
        if (expression instanceof PsiNewExpression) {
            PsiType expressionType = expression.getType();
            if (expressionType != null) {
                boolean hasArgs;
                StringBuilder sb = new StringBuilder("new ");
                sb.append(expressionType.getPresentableText());
                sb.append("(");
                PsiExpressionList list = ((PsiNewExpression)expression).getArgumentList();
                boolean bl = hasArgs = list != null && list.getExpressions().length > 0;
                if (hasArgs) {
                    sb.append("...");
                }
                sb.append(")");
                if (expressionType instanceof PsiClassType && ((PsiClassType)expressionType).resolve() instanceof PsiAnonymousClass) {
                    sb.append("{...}");
                }
                return sb.toString();
            }
            return expression.getText();
        }
        return expression.getText();
    }

    @Nullable
    protected String getContainerText(PsiElement element, String name) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass != null) {
            return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass);
        }
        return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
    }

    protected Icon getIcon(PsiElement element) {
        return GuiceIcons.Google_small;
    }

    protected int getIconFlags() {
        return 0;
    }
}

