/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public class JsLabel
extends SourceInfoAwareJsNode
implements JsStatement,
HasName {
    private final JsName label;
    private JsStatement statement;

    public JsLabel(JsName label2) {
        this.label = label2;
    }

    public JsLabel(JsName label2, JsStatement statement) {
        this.label = label2;
        this.statement = statement;
    }

    @Override
    public JsName getName() {
        return this.label;
    }

    @Override
    public Symbol getSymbol() {
        return this.label;
    }

    public JsStatement getStatement() {
        return this.statement;
    }

    public void setStatement(JsStatement statement) {
        this.statement = statement;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitLabel(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.statement);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.statement = v.acceptStatement(this.statement);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsLabel deepCopy() {
        JsLabel jsLabel = new JsLabel(this.label, AstUtil.deepCopy(this.statement.deepCopy())).withMetadataFrom(this);
        if (jsLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsLabel", "deepCopy"));
        }
        return jsLabel;
    }
}

