/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ClassBuilderFactories {
    @NotNull
    public static ClassBuilderFactory THROW_EXCEPTION = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.full(false);
            if (classBuilderMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$1", "getClassBuilderMode"));
            }
            return classBuilderMode;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$1", "newClassBuilder"));
            }
            throw new IllegalStateException();
        }

        @Override
        public String asText(ClassBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public void close() {
            throw new IllegalStateException();
        }
    };
    public static ClassBuilderFactory TEST = new TestClassBuilderFactory(false);
    public static ClassBuilderFactory TEST_WITH_SOURCE_RETENTION_ANNOTATIONS = new TestClassBuilderFactory(true);

    @NotNull
    public static ClassBuilderFactory binaries(final boolean generateSourceRetentionAnnotations) {
        ClassBuilderFactory classBuilderFactory = new ClassBuilderFactory(){

            @Override
            @NotNull
            public ClassBuilderMode getClassBuilderMode() {
                ClassBuilderMode classBuilderMode = ClassBuilderMode.full(generateSourceRetentionAnnotations);
                if (classBuilderMode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "getClassBuilderMode"));
                }
                return classBuilderMode;
            }

            @Override
            @NotNull
            public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
                if (origin == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "newClassBuilder"));
                }
                AbstractClassBuilder.Concrete concrete = new AbstractClassBuilder.Concrete((ClassVisitor)new BinaryClassWriter());
                if (concrete == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "newClassBuilder"));
                }
                return concrete;
            }

            @Override
            public String asText(ClassBuilder builder) {
                throw new UnsupportedOperationException("BINARIES generator asked for text");
            }

            @Override
            public byte[] asBytes(ClassBuilder builder) {
                ClassWriter visitor2 = (ClassWriter)builder.getVisitor();
                return visitor2.toByteArray();
            }

            @Override
            public void close() {
            }
        };
        if (classBuilderFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories", "binaries"));
        }
        return classBuilderFactory;
    }

    private ClassBuilderFactories() {
    }

    private static class TraceBuilder
    extends AbstractClassBuilder.Concrete {
        public final BinaryClassWriter binary;

        public TraceBuilder(BinaryClassWriter binary) {
            super((ClassVisitor)new TraceClassVisitor((ClassVisitor)binary, new PrintWriter(new StringWriter())));
            this.binary = binary;
        }
    }

    private static class BinaryClassWriter
    extends ClassWriter {
        public BinaryClassWriter() {
            super(3);
        }

        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            if (type1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$BinaryClassWriter", "getCommonSuperClass"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$BinaryClassWriter", "getCommonSuperClass"));
            }
            return "java/lang/Object";
        }
    }

    private static class TestClassBuilderFactory
    implements ClassBuilderFactory {
        private final boolean generateSourceRetentionAnnotations;

        public TestClassBuilderFactory(boolean generateSourceRetentionAnnotations) {
            this.generateSourceRetentionAnnotations = generateSourceRetentionAnnotations;
        }

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.full(this.generateSourceRetentionAnnotations);
            if (classBuilderMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$TestClassBuilderFactory", "getClassBuilderMode"));
            }
            return classBuilderMode;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$TestClassBuilderFactory", "newClassBuilder"));
            }
            TraceBuilder traceBuilder = new TraceBuilder(new BinaryClassWriter());
            if (traceBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$TestClassBuilderFactory", "newClassBuilder"));
            }
            return traceBuilder;
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor2 = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor2.p.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            return ((TraceBuilder)builder).binary.toByteArray();
        }

        @Override
        public void close() {
        }
    }
}

