/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020$H\u0002J\u0006\u0010*\u001a\u00020\u000bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0006\u0010.\u001a\u00020\u000bJ\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00101\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00104\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001d\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "getSaveStackMarkerForRestoreMarker", "saveStackNodesForTryStartLabel", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getSaveStackNodesForTryStartLabel", "findMatchingSaveNodes", "", "insnNode", "restoreLabel", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "visitRestoreStackInTryCatch", "visitSaveStackBeforeTry", "backend"})
public final class FixStackContext {
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    @NotNull
    private final HashMap<LabelNode, AbstractInsnNode> saveStackNodesForTryStartLabel;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    @NotNull
    public final HashMap<LabelNode, AbstractInsnNode> getSaveStackNodesForTryStartLabel() {
        return this.saveStackNodesForTryStartLabel;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void setConsistentInlineMarkers(boolean bl) {
        this.consistentInlineMarkers = bl;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        AbstractInsnNode next2 = insnNode.getNext();
        boolean bl = next2.getOpcode() == 167;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by GOTO";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AbstractInsnNode abstractInsnNode = next2;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)abstractInsnNode);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        boolean bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        boolean bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final void visitSaveStackBeforeTry(AbstractInsnNode insnNode) {
        AbstractInsnNode tryStartLabel = insnNode.getNext();
        boolean bl = tryStartLabel instanceof LabelNode;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": save should be followed by a label";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map map2 = this.saveStackNodesForTryStartLabel;
        AbstractInsnNode abstractInsnNode = tryStartLabel;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LabelNode");
        }
        LabelNode labelNode = (LabelNode)abstractInsnNode;
        AbstractInsnNode abstractInsnNode2 = insnNode;
        map2.put(labelNode, abstractInsnNode2);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitRestoreStackInTryCatch(AbstractInsnNode insnNode) {
        Object object;
        void $receiver$iv;
        AbstractInsnNode restoreLabel;
        Object it;
        AbstractInsnNode finger$iv;
        AbstractInsnNode $receiver$iv2 = insnNode;
        for (finger$iv = $receiver$iv2.getPrevious(); finger$iv != null && !UtilKt.hasOpcode((AbstractInsnNode)(it = finger$iv)); finger$iv = finger$iv.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode = finger$iv;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        $receiver$iv2 = abstractInsnNode;
        for (finger$iv = $receiver$iv2.getPrevious(); finger$iv != null && !((it = finger$iv) instanceof LabelNode || UtilKt.hasOpcode((AbstractInsnNode)it)); finger$iv = finger$iv.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode2 = finger$iv;
        if (abstractInsnNode2 == null) {
            Intrinsics.throwNpe();
        }
        if (!((restoreLabel = abstractInsnNode2) instanceof LabelNode)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": restore should be preceded by a catch block label")));
        }
        List<AbstractInsnNode> saveNodes = this.findMatchingSaveNodes(insnNode, (LabelNode)restoreLabel);
        if (saveNodes.isEmpty()) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is not matched with save")));
        }
        if (saveNodes.size() > 1) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is matched with several saves")));
        }
        AbstractInsnNode saveNode = (AbstractInsnNode)CollectionsKt.first(saveNodes);
        it = this.saveStackMarkerForRestoreMarker;
        AbstractInsnNode $i$a$2$findPreviousOrNull = saveNode;
        it.put(insnNode, $i$a$2$findPreviousOrNull);
        it = this.restoreStackMarkersForSaveMarker;
        Object value$iv = $receiver$iv.get(saveNode);
        if (value$iv == null) {
            SmartList answer$iv = new SmartList();
            $receiver$iv.put(saveNode, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractInsnNode> findMatchingSaveNodes(AbstractInsnNode insnNode, LabelNode restoreLabel) {
        void $receiver$iv;
        SmartHashSet saveNodes = new SmartHashSet();
        Iterable iterable = this.methodNode.tryCatchBlocks;
        for (Object element$iv : $receiver$iv) {
            AbstractInsnNode abstractInsnNode;
            TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
            if (!Intrinsics.areEqual((Object)restoreLabel, (Object)tcb.start) && !Intrinsics.areEqual((Object)restoreLabel, (Object)tcb.handler)) continue;
            if (this.saveStackNodesForTryStartLabel.get(tcb.start) == null) continue;
            AbstractInsnNode it = abstractInsnNode;
            saveNodes.add((Object)it);
        }
        return (List)new SmartList((Collection)saveNodes);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasAnyMarkers() {
        Object object = this.breakContinueGotoNodes;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        object = this.fakeAlwaysTrueIfeqMarkers;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        object = this.fakeAlwaysFalseIfeqMarkers;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        object = this.saveStackNodesForTryStartLabel;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        object = this.openingInlineMethodMarker;
        if (object.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAnalysisRequired() {
        Object object = this.breakContinueGotoNodes;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        object = this.saveStackNodesForTryStartLabel;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        object = this.openingInlineMethodMarker;
        if (object.isEmpty()) return false;
        return true;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = SetsKt.linkedSetOf((Object[])new JumpInsnNode[0]);
        this.fakeAlwaysTrueIfeqMarkers = CollectionsKt.arrayListOf((Object[])new AbstractInsnNode[0]);
        this.fakeAlwaysFalseIfeqMarkers = CollectionsKt.arrayListOf((Object[])new AbstractInsnNode[0]);
        this.saveStackNodesForTryStartLabel = MapsKt.hashMapOf((Pair[])new Pair[0]);
        this.saveStackMarkerForRestoreMarker = MapsKt.hashMapOf((Pair[])new Pair[0]);
        this.restoreStackMarkersForSaveMarker = MapsKt.hashMapOf((Pair[])new Pair[0]);
        this.openingInlineMethodMarker = MapsKt.hashMapOf((Pair[])new Pair[0]);
        this.consistentInlineMarkers = true;
        AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        Stack inlineMarkersStack = new Stack();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"methodNode.instructions");
        Sequence $receiver$iv = new InsnSequence(insnList);
        for (Object element$iv : $receiver$iv) {
            Object object;
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.FIX_STACK_BEFORE_JUMP))) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ))) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ))) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.SAVE_STACK_BEFORE_TRY))) {
                this.visitSaveStackBeforeTry(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH))) {
                this.visitRestoreStackInTryCatch(insnNode);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push((Object)insnNode);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(insnNode)) continue;
            Object object2 = (Collection)inlineMarkersStack;
            boolean bl = !object2.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            object2 = this.openingInlineMethodMarker;
            Intrinsics.checkExpressionValueIsNotNull((Object)inlineMarkersStack.pop(), (String)"inlineMarkersStack.pop()");
            object2.put(insnNode, object);
        }
        Collection collection = (Collection)inlineMarkersStack;
        if (!collection.isEmpty()) {
            this.consistentInlineMarkers = false;
        }
    }
}

