/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.LocalVariablesManager;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J<\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J<\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J4\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00162\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J<\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transformAfterInlineCallMarker", "actions", "", "Lkotlin/Function0;", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "inlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "localVariablesManager", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "transformBeforeInlineCallMarker", "transformBreakContinueGotos", "fixStackContext", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "transformRestoreStackMarker", "marker", "transformSaveRestoreStackMarkers", "context", "transformSaveStackMarker", "backend"})
public final class FixStackMethodTransformer
extends MethodTransformer {
    /*
     * WARNING - void declaration
     */
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        AbstractInsnNode marker;
        Object analyzer;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        FixStackContext context = new FixStackContext(methodNode);
        if (!context.hasAnyMarkers()) {
            return;
        }
        if (!context.getConsistentInlineMarkers()) {
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"methodNode.instructions");
            Sequence sequence2 = new InsnSequence(insnList);
            for (Object element$iv : $receiver$iv) {
                AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
                if (!InlineCodegenUtil.isInlineMarker(insnNode)) continue;
                methodNode.instructions.remove(insnNode);
            }
        }
        if (context.isAnalysisRequired()) {
            void $receiver$iv2;
            Object element$iv;
            analyzer = new FixStackAnalyzer(internalClassName, methodNode, context);
            ((MethodAnalyzer)analyzer).analyze();
            methodNode.maxStack += ((FixStackAnalyzer)analyzer).getMaxExtraStackSize();
            ArrayList actions2 = CollectionsKt.arrayListOf((Object[])new Function0[0]);
            this.transformBreakContinueGotos(methodNode, context, actions2, (FixStackAnalyzer)analyzer);
            this.transformSaveRestoreStackMarkers(methodNode, context, actions2, (FixStackAnalyzer)analyzer);
            element$iv = actions2;
            for (Object element$iv2 : $receiver$iv2) {
                Function0 it = (Function0)element$iv2;
                it.invoke();
            }
        }
        analyzer = context.getFakeAlwaysTrueIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.replaceAlwaysTrueIfeqWithGoto(methodNode, marker);
        }
        $receiver$iv = context.getFakeAlwaysFalseIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.removeAlwaysFalseIfeq(methodNode, marker);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformBreakContinueGotos(MethodNode methodNode, FixStackContext fixStackContext, List<Function0<Unit>> actions2, FixStackAnalyzer analyzer) {
        void $receiver$iv;
        Iterable iterable = fixStackContext.getBreakContinueGotoNodes();
        for (Object element$iv : $receiver$iv) {
            int expectedStackSize;
            JumpInsnNode gotoNode = (JumpInsnNode)element$iv;
            int gotoIndex = methodNode.instructions.indexOf((AbstractInsnNode)gotoNode);
            int labelIndex = methodNode.instructions.indexOf((AbstractInsnNode)gotoNode.label);
            int DEAD_CODE = -1;
            Frame frame = analyzer.getFrames()[gotoIndex];
            int actualStackSize = frame != null ? frame.getStackSize() : DEAD_CODE;
            Frame frame2 = analyzer.getFrames()[labelIndex];
            int n = expectedStackSize = frame2 != null ? frame2.getStackSize() : DEAD_CODE;
            if (actualStackSize != DEAD_CODE && expectedStackSize != DEAD_CODE) {
                Frame frame3;
                boolean bl = expectedStackSize <= actualStackSize;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Label at " + labelIndex + ", jump at " + gotoIndex + ": stack underflow: " + expectedStackSize + " > " + actualStackSize;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (analyzer.getFrames()[gotoIndex] == null) {
                    Intrinsics.throwNpe();
                }
                actions2.add(new Function0<Unit>(gotoNode, expectedStackSize, frame3, methodNode, analyzer, actions2){
                    final /* synthetic */ JumpInsnNode $gotoNode;
                    final /* synthetic */ int $expectedStackSize;
                    final /* synthetic */ Frame $frame;
                    final /* synthetic */ MethodNode $methodNode$inlined;
                    final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                    final /* synthetic */ List $actions$inlined;

                    public final void invoke() {
                        AbstractInsnNode abstractInsnNode = this.$gotoNode.getPrevious();
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"gotoNode.previous");
                        StackTransformationUtilsKt.replaceMarkerWithPops(this.$methodNode$inlined, abstractInsnNode, this.$expectedStackSize, (Frame<BasicValue>)this.$frame);
                    }
                    {
                        this.$gotoNode = jumpInsnNode;
                        this.$expectedStackSize = n;
                        this.$frame = frame;
                        this.$methodNode$inlined = methodNode;
                        this.$analyzer$inlined = fixStackAnalyzer;
                        this.$actions$inlined = list2;
                        super(0);
                    }
                });
                continue;
            }
            if (actualStackSize != DEAD_CODE && expectedStackSize == DEAD_CODE) {
                throw (Throwable)((Object)new AssertionError((Object)("Live jump " + gotoIndex + " to dead label " + labelIndex)));
            }
            AbstractInsnNode marker = gotoNode.getPrevious();
            actions2.add(new Function0<Unit>(marker, methodNode, analyzer, actions2){
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ MethodNode $methodNode$inlined;
                final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                final /* synthetic */ List $actions$inlined;

                public final void invoke() {
                    this.$methodNode$inlined.instructions.remove(this.$marker);
                }
                {
                    this.$marker = abstractInsnNode;
                    this.$methodNode$inlined = methodNode;
                    this.$analyzer$inlined = fixStackAnalyzer;
                    this.$actions$inlined = list2;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSaveRestoreStackMarkers(MethodNode methodNode, FixStackContext context, List<Function0<Unit>> actions2, FixStackAnalyzer analyzer) {
        void $receiver$iv;
        LocalVariablesManager localVariablesManager = new LocalVariablesManager(context, methodNode);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"methodNode.instructions");
        Sequence sequence2 = new InsnSequence(insnList);
        for (Object element$iv : $receiver$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.SAVE_STACK_BEFORE_TRY))) {
                this.transformSaveStackMarker(methodNode, actions2, analyzer, marker, localVariablesManager);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)pseudoInsn), (Object)((Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH))) {
                this.transformRestoreStackMarker(methodNode, actions2, marker, localVariablesManager);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(marker)) {
                this.transformBeforeInlineCallMarker(methodNode, actions2, analyzer, marker, localVariablesManager);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(marker)) continue;
            this.transformAfterInlineCallMarker(methodNode, actions2, analyzer, marker, localVariablesManager);
        }
    }

    private final void transformSaveStackMarker(MethodNode methodNode, List<Function0<Unit>> actions2, FixStackAnalyzer analyzer, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer.getSavedStacks().get(marker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForSaveStackMarker(marker, savedStackValues);
            actions2.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$marker, this.$savedStackDescriptor, false);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForSaveStackMarker(marker, CollectionsKt.emptyList());
            actions2.add(new Function0<Unit>(methodNode, marker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$marker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }

    private final void transformRestoreStackMarker(MethodNode methodNode, List<Function0<Unit>> actions2, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getSavedStackDescriptor(marker);
        actions2.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
            final /* synthetic */ MethodNode $methodNode;
            final /* synthetic */ AbstractInsnNode $marker;
            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

            public final void invoke() {
                StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
            }
            {
                this.$methodNode = methodNode;
                this.$marker = abstractInsnNode;
                this.$savedStackDescriptor = savedStackDescriptor;
                super(0);
            }
        });
        localVariablesManager.markRestoreStackMarkerEmitted(marker);
    }

    private final void transformAfterInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions2, FixStackAnalyzer analyzer, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getBeforeInlineDescriptor(inlineMarker);
        FixStackAnalyzer.FixStackFrame afterInlineFrame = (FixStackAnalyzer.FixStackFrame)analyzer.getFrame(inlineMarker);
        if (afterInlineFrame != null && savedStackDescriptor.isNotEmpty()) {
            boolean bl = afterInlineFrame.getStackSize() <= 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Inline method should not leave more than 1 value on stack";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (afterInlineFrame.getStackSize() == 1) {
                List<BasicValue> afterInlineStackValues = afterInlineFrame.getStackContent();
                BasicValue returnValue = (BasicValue)CollectionsKt.last(afterInlineStackValues);
                int returnValueLocalVarIndex = localVariablesManager.createReturnValueVariable(returnValue);
                actions2.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor, returnValue, returnValueLocalVarIndex){
                    final /* synthetic */ MethodNode $methodNode;
                    final /* synthetic */ AbstractInsnNode $inlineMarker;
                    final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                    final /* synthetic */ BasicValue $returnValue;
                    final /* synthetic */ int $returnValueLocalVarIndex;

                    public final void invoke() {
                        StackTransformationUtilsKt.restoreStackWithReturnValue(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, this.$returnValue, this.$returnValueLocalVarIndex);
                    }
                    {
                        this.$methodNode = methodNode;
                        this.$inlineMarker = abstractInsnNode;
                        this.$savedStackDescriptor = savedStackDescriptor;
                        this.$returnValue = basicValue;
                        this.$returnValueLocalVarIndex = n;
                        super(0);
                    }
                });
            } else {
                actions2.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                    final /* synthetic */ MethodNode $methodNode;
                    final /* synthetic */ AbstractInsnNode $inlineMarker;
                    final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                    public final void invoke() {
                        StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                    }
                    {
                        this.$methodNode = methodNode;
                        this.$inlineMarker = abstractInsnNode;
                        this.$savedStackDescriptor = savedStackDescriptor;
                        super(0);
                    }
                });
            }
        } else {
            actions2.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
        localVariablesManager.markAfterInlineMarkerEmitted(inlineMarker);
    }

    private final void transformBeforeInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions2, FixStackAnalyzer analyzer, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer.getSavedStacks().get(inlineMarker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, savedStackValues);
            actions2.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, false);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, CollectionsKt.emptyList());
            actions2.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }
}

