/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "()V", "registrationMap", "Ljava/util/HashMap;", "Ljava/lang/reflect/Type;", "addAll", "", "descriptors", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "buildRegistrationMap", "Lcom/intellij/util/containers/MultiMap;", "tryGetEntry", "request", "container"})
public final class ComponentRegistry {
    private final HashMap<Type, Object> registrationMap = MapsKt.hashMapOf((Pair[])new Pair[0]);

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        MultiMap registrationMap = new MultiMap();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue((Object)registration, (Object)componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        MultiMap<Type, ComponentDescriptor> newRegistrationMap = this.buildRegistrationMap(descriptors);
        for (Map.Entry entry : newRegistrationMap.entrySet()) {
            Object object;
            Map map2;
            Object oldEntries = this.registrationMap.get(entry.getKey());
            if (oldEntries != null || ((Collection)entry.getValue()).size() > 1) {
                List list2 = CollectionsKt.mutableListOf((Object[])new ComponentDescriptor[0]);
                if (oldEntries instanceof Collection) {
                    Object object2 = oldEntries;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
                    }
                    list2.addAll((Collection)object2);
                } else if (oldEntries != null) {
                    Object object3 = oldEntries;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
                    }
                    list2.add((ComponentDescriptor)object3);
                }
                Collection collection = (Collection)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"entry.value");
                list2.addAll(collection);
                map2 = this.registrationMap;
                Intrinsics.checkExpressionValueIsNotNull(entry.getKey(), (String)"entry.key");
                Object object4 = (ComponentDescriptor)CollectionsKt.singleOrNull((List)list2);
                if (object4 == null) {
                    object4 = list2;
                }
                ComponentDescriptor componentDescriptor = object4;
                map2.put((Object)object, (ComponentDescriptor)componentDescriptor);
                continue;
            }
            Map map3 = this.registrationMap;
            Intrinsics.checkExpressionValueIsNotNull(entry.getKey(), (String)"entry.key");
            Intrinsics.checkExpressionValueIsNotNull((Object)CollectionsKt.single((Iterable)((Iterable)entry.getValue())), (String)"entry.value.single()");
            map3.put(map2, object);
        }
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Collection collection;
        Object value2;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = value2 = this.registrationMap.get(request);
        if (object instanceof Collection) {
            Object object2 = value2;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
            }
            collection = (Collection)object2;
        } else if (Intrinsics.areEqual((Object)object, null)) {
            collection = CollectionsKt.emptyList();
        } else {
            Object object3 = value2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
            }
            collection = CollectionsKt.listOf((Object)((ComponentDescriptor)object3));
        }
        return collection;
    }
}

