/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.UnresolvedDependenciesException;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"computeArguments", "", "", "argumentDescriptors", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "bindArguments", "Ljava/lang/reflect/Member;", "parameters", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "bindToConstructor", "Lorg/jetbrains/kotlin/container/ConstructorBinding;", "Ljava/lang/Class;", "bindToMethod", "Lorg/jetbrains/kotlin/container/MethodBinding;", "Ljava/lang/reflect/Method;", "container"})
public final class ResolveKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> computeArguments(@NotNull List<? extends ValueDescriptor> argumentDescriptors) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(argumentDescriptors, (String)"argumentDescriptors");
        Iterable $receiver$iv = argumentDescriptors;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object object = it.getValue();
            collection.add(object);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final ConstructorBinding bindToConstructor(@NotNull Class<?> $receiver, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ConstructorInfo constructorInfo = CacheKt.getInfo($receiver).getConstructorInfo();
        if (constructorInfo == null) {
            String string = "No constructor for " + $receiver + ": " + CacheKt.getInfo($receiver);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ConstructorInfo constructorInfo2 = constructorInfo;
        Constructor<?> candidate = constructorInfo2.getConstructor();
        return new ConstructorBinding(candidate, ResolveKt.bindArguments(candidate, constructorInfo2.getParameters(), context));
    }

    @NotNull
    public static final MethodBinding bindToMethod(@NotNull Method $receiver, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new MethodBinding($receiver, ResolveKt.bindArguments($receiver, ArraysKt.toList((Object[])$receiver.getGenericParameterTypes()), context));
    }

    private static final List<ValueDescriptor> bindArguments(@NotNull Member $receiver, List<? extends Type> parameters2, ValueResolveContext context) {
        ArrayList<ValueDescriptor> bound = new ArrayList<ValueDescriptor>(parameters2.size());
        List unsatisfied = null;
        for (Type type2 : parameters2) {
            ValueDescriptor descriptor2 = context.resolve(type2);
            if (descriptor2 == null) {
                if (unsatisfied == null) {
                    unsatisfied = new ArrayList();
                }
                unsatisfied.add(type2);
                continue;
            }
            bound.add(descriptor2);
        }
        if (unsatisfied != null) {
            throw (Throwable)new UnresolvedDependenciesException("Dependencies for `" + $receiver + "` cannot be satisfied:" + "\n" + "  " + unsatisfied);
        }
        return bound;
    }
}

