/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 J\u0006\u0010!\u001a\u00020\u0018J\u0012\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010%\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0'H\u0002J\b\u0010(\u001a\u00020\u0018H\u0002J\u001a\u0010)\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0'J\u001a\u0010*\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0'J\u001c\u0010+\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0'H\u0002J\u001a\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "Lcom/intellij/openapi/Disposable;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "(Lcom/intellij/ide/util/PropertiesComponent;)V", "CACHED_REQUEST_DELAY", "", "INITIAL_UPDATE_DELAY", "alarm", "Lcom/intellij/util/Alarm;", "checkQueued", "", "lastUpdateStatus", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "updateDelay", "checkUpdatesInCustomRepository", "host", "", "checkUpdatesInMainRepository", "dispose", "", "initPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "newVersion", "installPluginUpdate", "update", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "cancelCallback", "Lkotlin/Function0;", "kotlinFileEdited", "notifyNotInstalled", "message", "notifyPluginUpdateAvailable", "queueUpdateCheck", "callback", "Lkotlin/Function1;", "recordSuccessfulUpdateCheck", "runCachedUpdate", "runUpdateCheck", "updateCheck", "updateIfNotLatest", "kotlinPlugin", "Companion", "idea"})
public final class KotlinPluginUpdater
implements Disposable {
    private final long INITIAL_UPDATE_DELAY = 2000L;
    private final long CACHED_REQUEST_DELAY;
    private long updateDelay;
    private final Alarm alarm;
    private final NotificationGroup notificationGroup;
    private volatile boolean checkQueued;
    private volatile PluginUpdateStatus lastUpdateStatus;
    @NotNull
    private final PropertiesComponent propertiesComponent;
    private static final String PROPERTY_NAME = "kotlin.lastUpdateCheck";
    private static final Logger LOG;
    public static final Companion Companion;

    public final void kotlinFileEdited() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        long lastUpdateTime = Long.parseLong(this.propertiesComponent.getValue(KotlinPluginUpdater.Companion.getPROPERTY_NAME(), "0"));
        if (lastUpdateTime == 0L || System.currentTimeMillis() - lastUpdateTime > this.CACHED_REQUEST_DELAY) {
            this.queueUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(this){
                final /* synthetic */ KotlinPluginUpdater this$0;

                public final boolean invoke(@NotNull PluginUpdateStatus updateStatus) {
                    Intrinsics.checkParameterIsNotNull((Object)updateStatus, (String)"updateStatus");
                    PluginUpdateStatus pluginUpdateStatus = updateStatus;
                    if (pluginUpdateStatus instanceof PluginUpdateStatus.Update) {
                        KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0, (PluginUpdateStatus.Update)updateStatus);
                    } else if (pluginUpdateStatus instanceof PluginUpdateStatus.CheckFailed) {
                        org.jetbrains.kotlin.idea.KotlinPluginUpdater$Companion.access$getLOG$p(KotlinPluginUpdater.Companion).info("Plugin update check failed: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getMessage() + ", details: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getDetail());
                    }
                    return true;
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    super(1);
                }
            }));
        }
    }

    private final void queueUpdateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.checkQueued) {
            this.checkQueued = true;
            this.alarm.addRequest(new Runnable(this, callback2){
                final /* synthetic */ KotlinPluginUpdater this$0;
                final /* synthetic */ Function1 $callback;

                public final void run() {
                    KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    this.$callback = function1;
                }
            }, this.updateDelay);
            this.updateDelay *= (long)2;
        }
    }

    public final void runUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, callback2){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ Function1 $callback;

            public final void run() {
                KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$callback = function1;
            }
        });
    }

    public final void runCachedUpdate(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ApplicationManager.getApplication().assertIsDispatchThread();
        PluginUpdateStatus cachedStatus = this.lastUpdateStatus;
        if (cachedStatus != null && System.currentTimeMillis() - cachedStatus.getTimestamp() < this.CACHED_REQUEST_DELAY && !(cachedStatus instanceof PluginUpdateStatus.CheckFailed)) {
            callback2.invoke((Object)cachedStatus);
            return;
        }
        this.queueUpdateCheck(callback2);
    }

    private final void updateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Ref.ObjectRef updateStatus = new Ref.ObjectRef();
        try {
            updateStatus.element = this.checkUpdatesInMainRepository();
            for (String host : CollectionsKt.filterNotNull((Iterable)RepositoryHelper.getPluginHosts())) {
                PluginUpdateStatus customUpdateStatus = this.checkUpdatesInCustomRepository(host);
                updateStatus.element = ((PluginUpdateStatus)updateStatus.element).mergeWith(customUpdateStatus);
            }
        }
        catch (Exception e) {
            updateStatus.element = PluginUpdateStatus.Companion.fromException("Kotlin plugin update check failed", e);
        }
        this.lastUpdateStatus = (PluginUpdateStatus)updateStatus.element;
        this.checkQueued = false;
        if (!((PluginUpdateStatus)updateStatus.element instanceof PluginUpdateStatus.CheckFailed)) {
            this.recordSuccessfulUpdateCheck();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(callback2, updateStatus){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ Ref.ObjectRef $updateStatus;

            public final void run() {
                this.$callback.invoke((Object)((PluginUpdateStatus)this.$updateStatus.element));
            }
            {
                this.$callback = function1;
                this.$updateStatus = objectRef;
            }
        }, ModalityState.any());
        updateStatus = null;
    }

    /*
     * WARNING - void declaration
     */
    private final IdeaPluginDescriptor initPluginDescriptor(String newVersion) {
        void $receiver;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)KotlinPluginUtil.KOTLIN_PLUGIN_ID);
        if (ideaPluginDescriptor == null) {
            Intrinsics.throwNpe();
        }
        IdeaPluginDescriptor originalPlugin = ideaPluginDescriptor;
        PluginNode pluginNode = new PluginNode(KotlinPluginUtil.KOTLIN_PLUGIN_ID);
        PluginNode pluginNode2 = pluginNode;
        $receiver.setVersion(newVersion);
        $receiver.setName(originalPlugin.getName());
        $receiver.setDescription(originalPlugin.getDescription());
        return (IdeaPluginDescriptor)pluginNode;
    }

    private final PluginUpdateStatus checkUpdatesInMainRepository() {
        String newVersion;
        String buildNumber = ApplicationInfo.getInstance().getBuild().asString();
        String currentVersion = KotlinPluginUtil.getPluginVersion();
        String os = URLEncoder.encode(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, "UTF-8");
        String uid = UpdateChecker.getInstallationUID((PropertiesComponent)this.propertiesComponent);
        String url = "https://plugins.jetbrains.com/plugins/list?pluginId=6954&build=" + buildNumber + "&pluginVersion=" + currentVersion + "&os=" + os + "&uuid=" + uid;
        Element responseDoc2 = (Element)HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)checkUpdatesInMainRepository.responseDoc.1.INSTANCE);
        if (Intrinsics.areEqual((Object)responseDoc2.getName(), (Object)"plugin-repository") ^ true) {
            return new PluginUpdateStatus.CheckFailed("Unexpected plugin repository response", JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        if (responseDoc2.getChildren().isEmpty()) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        Element element2 = responseDoc2.getChild("category");
        String string = element2 != null && (element2 = element2.getChild("idea-plugin")) != null && (element2 = element2.getChild("version")) != null ? element2.getText() : (newVersion = null);
        if (newVersion == null) {
            return new PluginUpdateStatus.CheckFailed("Couldn't find plugin version in repository response", JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        IdeaPluginDescriptor pluginDescriptor = this.initPluginDescriptor(newVersion);
        return this.updateIfNotLatest(pluginDescriptor, null);
    }

    private final PluginUpdateStatus checkUpdatesInCustomRepository(String host) {
        Object v0;
        block4: {
            List list2;
            try {
                list2 = RepositoryHelper.loadPlugins((String)host, (ProgressIndicator)null);
            }
            catch (Exception e) {
                return PluginUpdateStatus.Companion.fromException("Checking custom plugin repository " + host + " failed", e);
            }
            List plugins = list2;
            Iterable iterable = plugins;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                IdeaPluginDescriptor it = (IdeaPluginDescriptor)t;
                if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)KotlinPluginUtil.KOTLIN_PLUGIN_ID)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        IdeaPluginDescriptor ideaPluginDescriptor = v0;
        if (ideaPluginDescriptor == null) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        IdeaPluginDescriptor kotlinPlugin = ideaPluginDescriptor;
        return this.updateIfNotLatest(kotlinPlugin, host);
    }

    private final PluginUpdateStatus updateIfNotLatest(IdeaPluginDescriptor kotlinPlugin, String host) {
        if (VersionComparatorUtil.compare((String)kotlinPlugin.getVersion(), (String)KotlinPluginUtil.getPluginVersion()) <= 0) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        return new PluginUpdateStatus.Update(kotlinPlugin, host);
    }

    private final void recordSuccessfulUpdateCheck() {
        this.propertiesComponent.setValue(KotlinPluginUpdater.Companion.getPROPERTY_NAME(), String.valueOf(System.currentTimeMillis()));
        this.updateDelay = this.INITIAL_UPDATE_DELAY;
    }

    private final void notifyPluginUpdateAvailable(PluginUpdateStatus.Update update) {
        Notification notification2 = this.notificationGroup.createNotification("Kotlin", "A new version " + update.getPluginDescriptor().getVersion() + " of the Kotlin plugin is available. <b><a href=" + "\"" + "#" + "\"" + ">Install</a></b>", NotificationType.INFORMATION, new NotificationListener(this, update){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginUpdateStatus.Update $update;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                notification2.expire();
                this.this$0.installPluginUpdate(this.$update, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyPluginUpdateAvailable.notification.1 this$0;

                    public final void invoke() {
                        KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0.this$0, this.this$0.$update);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$update = update;
            }
        });
        notification2.notify((Project)null);
    }

    public final void installPluginUpdate(@NotNull PluginUpdateStatus.Update update, @NotNull Function0<Unit> cancelCallback) {
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        Intrinsics.checkParameterIsNotNull(cancelCallback, (String)"cancelCallback");
        IdeaPluginDescriptor descriptor2 = update.getPluginDescriptor();
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor2, (String)update.getHostToInstallFrom(), (BuildNumber)null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, pluginDownloader, cancelCallback, null, "Downloading plugins", true){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginDownloader $pluginDownloader;
            final /* synthetic */ Function0 $cancelCallback;

            public void run(@NotNull ProgressIndicator indicator) {
                IdeaPluginDescriptor pluginDescriptor;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                boolean installed = false;
                String message2 = null;
                try {
                    bl = this.$pluginDownloader.prepareToInstall(indicator);
                }
                catch (IOException e) {
                    org.jetbrains.kotlin.idea.KotlinPluginUpdater$Companion.access$getLOG$p(KotlinPluginUpdater.Companion).info((Throwable)e);
                    message2 = e.getMessage();
                    bl = false;
                }
                boolean prepareResult = bl;
                if (prepareResult && (pluginDescriptor = this.$pluginDownloader.getDescriptor()) != null) {
                    installed = true;
                    this.$pluginDownloader.install();
                    ApplicationManager.getApplication().invokeLater((Runnable)installPluginUpdate.run.1.INSTANCE);
                }
                if (!installed) {
                    KotlinPluginUpdater.access$notifyNotInstalled(this.this$0, message2);
                }
            }

            public void onCancel() {
                this.$cancelCallback.invoke();
            }
            {
                this.this$0 = $outer;
                this.$pluginDownloader = $captured_local_variable$1;
                this.$cancelCallback = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    public static /* bridge */ /* synthetic */ void installPluginUpdate$default(KotlinPluginUpdater kotlinPluginUpdater, PluginUpdateStatus.Update update, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: installPluginUpdate");
        }
        if ((n & 2) != 0) {
            function0 = installPluginUpdate.1.INSTANCE;
        }
        kotlinPluginUpdater.installPluginUpdate(update, (Function0<Unit>)function0);
    }

    private final void notifyNotInstalled(String message2) {
        String string;
        block3: {
            block2: {
                string = message2;
                if (string == null) break block2;
                String string2 = string;
                String it = string2;
                string = ": " + it;
                if (string != null) break block3;
            }
            string = "";
        }
        String fullMessage = string;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, fullMessage){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ String $fullMessage;

            public final void run() {
                Notification notification2 = KotlinPluginUpdater.access$getNotificationGroup$p(this.this$0).createNotification("Kotlin", "Plugin update was not installed" + this.$fullMessage + ". <a href=" + "\"" + "#" + "\"" + ">See the log for more information</a>", NotificationType.INFORMATION, (NotificationListener)notifyNotInstalled.notification.1.INSTANCE);
                notification2.notify((Project)null);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$fullMessage = string;
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public final PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public KotlinPluginUpdater(@NotNull PropertiesComponent propertiesComponent) {
        Intrinsics.checkParameterIsNotNull((Object)propertiesComponent, (String)"propertiesComponent");
        this.propertiesComponent = propertiesComponent;
        this.INITIAL_UPDATE_DELAY = 2000L;
        this.CACHED_REQUEST_DELAY = TimeUnit.DAYS.toMillis(1L);
        this.updateDelay = this.INITIAL_UPDATE_DELAY;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.notificationGroup = new NotificationGroup("Kotlin plugin updates", NotificationDisplayType.STICKY_BALLOON, true);
    }

    static {
        Companion = new Companion(null);
        PROPERTY_NAME = PROPERTY_NAME;
        LOG = Logger.getInstance(KotlinPluginUpdater.class);
    }

    public static final /* synthetic */ void access$notifyPluginUpdateAvailable(KotlinPluginUpdater $this, @NotNull PluginUpdateStatus.Update update) {
        $this.notifyPluginUpdateAvailable(update);
    }

    public static final /* synthetic */ void access$updateCheck(KotlinPluginUpdater $this, @NotNull Function1 callback2) {
        $this.updateCheck((Function1<? super PluginUpdateStatus, Boolean>)callback2);
    }

    public static final /* synthetic */ void access$notifyNotInstalled(KotlinPluginUpdater $this, @Nullable String message2) {
        $this.notifyNotInstalled(message2);
    }

    @NotNull
    public static final /* synthetic */ NotificationGroup access$getNotificationGroup$p(KotlinPluginUpdater $this) {
        return $this.notificationGroup;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PROPERTY_NAME", "", "getPROPERTY_NAME", "()Ljava/lang/String;", "getInstance", "Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "idea"})
    public static final class Companion {
        private final String getPROPERTY_NAME() {
            return PROPERTY_NAME;
        }

        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final KotlinPluginUpdater getInstance() {
            KotlinPluginUpdater kotlinPluginUpdater = (KotlinPluginUpdater)ServiceManager.getService(KotlinPluginUpdater.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinPluginUpdater, (String)"ServiceManager.getServic\u2026luginUpdater::class.java)");
            return kotlinPluginUpdater;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLOG$p(Companion $this) {
            return $this.getLOG();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

