/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.frontend.di.InjectionKt;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzerForTopLevel;
import org.jetbrains.kotlin.resolve.LibrarySourceHacks;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinResolveDataProvider;", "", "()V", "topmostElementTypes", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "analyzeExpressionCodeFragment", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "findAnalyzableParent", "element", "idea-analysis"})
final class KotlinResolveDataProvider {
    private static final Class<? extends PsiElement>[] topmostElementTypes;
    public static final KotlinResolveDataProvider INSTANCE;

    @NotNull
    public final KtElement findAnalyzableParent(@NotNull KtElement element2) {
        KtElement ktElement;
        KtElement analyzableElement;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2 instanceof KtFile) {
            return element2;
        }
        KtElement topmostElement = (KtElement)KtPsiUtil.getTopmostParentOfTypes((PsiElement)element2, Arrays.copyOf(topmostElementTypes, topmostElementTypes.length));
        KtElement ktElement2 = topmostElement;
        KtElement ktElement3 = analyzableElement = ktElement2 instanceof KtAnnotationEntry || ktElement2 instanceof KtTypeConstraint || ktElement2 instanceof KtSuperTypeList || ktElement2 instanceof KtTypeParameter || ktElement2 instanceof KtParameter ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)topmostElement), (Class[])new Class[]{KtClassOrObject.class, KtCallableDeclaration.class}) : topmostElement;
        if (analyzableElement instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)analyzableElement).getContainingClassOrObject();
        }
        KtElement ktElement4 = analyzableElement;
        if (ktElement4 == null) {
            ktElement4 = ktElement = (KtElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element2), KtDeclaration.class);
        }
        if (ktElement4 == null) {
            ktElement = element2.getContainingKtFile();
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult analyze(@NotNull Project project, @NotNull ComponentProvider componentProvider, @NotNull KtElement analyzableElement) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        Intrinsics.checkParameterIsNotNull((Object)analyzableElement, (String)"analyzableElement");
        try {
            ComponentProvider $receiver$iv;
            void $receiver$iv2;
            void $receiver$iv3;
            ComponentProvider componentProvider2 = componentProvider;
            ModuleDescriptor module = DslKt.getService((ComponentProvider)$receiver$iv3, ModuleDescriptor.class);
            if (analyzableElement instanceof KtCodeFragment) {
                return AnalysisResult.Companion.success(this.analyzeExpressionCodeFragment(componentProvider, (KtCodeFragment)analyzableElement), module);
            }
            KtFile file2 = analyzableElement.getContainingKtFile();
            if (GetModuleInfoKt.getModuleInfo((PsiElement)file2) instanceof LibrarySourceInfo) {
                file2.putUserData(LibrarySourceHacks.INSTANCE.getSKIP_TOP_LEVEL_MEMBERS(), true);
            }
            ComponentProvider componentProvider3 = componentProvider;
            ResolveSession resolveSession = DslKt.getService((ComponentProvider)$receiver$iv2, ResolveSession.class);
            BindingContext bindingContext2 = resolveSession.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"resolveSession.bindingContext");
            DelegatingBindingTrace trace = new DelegatingBindingTrace(bindingContext2, "Trace for resolution of " + analyzableElement, false, null, 12, null);
            TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(analyzableElement.getContainingKtFile());
            ComponentProvider componentProvider4 = componentProvider;
            ModuleContext moduleContext = ContextKt.withModule(ContextKt.withProject(DslKt.getService($receiver$iv, GlobalContext.class), project), module);
            KotlinCodeAnalyzer kotlinCodeAnalyzer = resolveSession;
            BindingTrace bindingTrace = trace;
            TargetPlatform targetPlatform2 = targetPlatform;
            Intrinsics.checkExpressionValueIsNotNull((Object)targetPlatform2, (String)"targetPlatform");
            $receiver$iv = componentProvider;
            TargetPlatform targetPlatform3 = targetPlatform2;
            BindingTrace bindingTrace2 = bindingTrace;
            KotlinCodeAnalyzer kotlinCodeAnalyzer2 = kotlinCodeAnalyzer;
            ModuleContext moduleContext2 = moduleContext;
            BodyResolveCache bodyResolveCache = DslKt.getService($receiver$iv, BodyResolveCache.class);
            $receiver$iv = InjectionKt.createContainerForLazyBodyResolve(moduleContext2, kotlinCodeAnalyzer2, bindingTrace2, targetPlatform3, bodyResolveCache, LanguageVersionSettingsImpl.DEFAULT);
            LazyTopDownAnalyzerForTopLevel lazyTopDownAnalyzer = DslKt.getService($receiver$iv, LazyTopDownAnalyzerForTopLevel.class);
            lazyTopDownAnalyzer.analyzeDeclarations(TopDownAnalysisMode.TopLevelDeclarations, CollectionsKt.listOf((Object)analyzableElement));
            return AnalysisResult.Companion.success(trace.getBindingContext(), module);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext3 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.error(bindingContext3, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BindingContext analyzeExpressionCodeFragment(ComponentProvider componentProvider, KtCodeFragment codeFragment) {
        void $receiver$iv;
        BindingTraceContext trace = new BindingTraceContext();
        ComponentProvider componentProvider2 = componentProvider;
        DslKt.getService((ComponentProvider)$receiver$iv, CodeFragmentAnalyzer.class).analyzeCodeFragment(codeFragment, trace, BodyResolveMode.PARTIAL_FOR_COMPLETION);
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        return bindingContext2;
    }

    private KotlinResolveDataProvider() {
        INSTANCE = this;
        Class[] elements$iv = new Class[]{KtNamedFunction.class, KtAnonymousInitializer.class, KtProperty.class, KtImportDirective.class, KtPackageDirective.class, KtCodeFragment.class, KtAnnotationEntry.class, KtTypeConstraint.class, KtSuperTypeList.class, KtTypeParameter.class, KtParameter.class};
        topmostElementTypes = (Class[])((Object[])elements$iv);
    }

    static {
        new KotlinResolveDataProvider();
    }
}

