/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "getCallType", "()Lorg/jetbrains/kotlin/idea/util/CallType;", "addImport", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "handleInsert", "idea-completion"})
public abstract class KotlinCallableInsertHandler
extends BaseDeclarationInsertHandler {
    @NotNull
    private final CallType<?> callType;

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.handleInsert(context, item);
        this.addImport(context, item);
    }

    private final void addImport(InsertionContext context, LookupElement item) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
        psiDocumentManager.commitAllDocuments();
        PsiFile file2 = context.getFile();
        Object o = item.getObject();
        if (file2 instanceof KtFile && o instanceof DeclarationLookupObject) {
            DeclarationDescriptor declarationDescriptor = ((DeclarationLookupObject)o).getDescriptor();
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor descriptor2 = callableDescriptor;
            if (descriptor2.getExtensionReceiverParameter() != null || Intrinsics.areEqual(this.callType, (Object)CallType.CALLABLE_REFERENCE.INSTANCE)) {
                if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
                    Project project = context.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
                    ImportInsertHelper importInsertHelper = ImportInsertHelper.Companion.getInstance(project);
                    KtFile ktFile = (KtFile)file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
                    ImportInsertHelper.importDescriptor$default(importInsertHelper, ktFile, descriptor2, false, 4, null);
                }
            } else if (Intrinsics.areEqual(this.callType, (Object)CallType.DEFAULT.INSTANCE)) {
                FqName fqName2 = ImportsUtils.getImportableFqName(descriptor2);
                if (fqName2 == null) {
                    return;
                }
                FqName fqName3 = fqName2;
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)(RenderingUtilsKt.render(fqName3) + " "));
                psiDocumentManager.commitAllDocuments();
                KtFile ktFile = (KtFile)file2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
                ShortenReferences.DEFAULT.process(ktFile, context.getStartOffset(), context.getTailOffset() - 1);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
                if (HandlerUtilsKt.isTextAt(context.getDocument(), context.getTailOffset() - 1, " ")) {
                    context.getDocument().deleteString(context.getTailOffset() - 1, context.getTailOffset());
                }
            }
        }
    }

    @NotNull
    public final CallType<?> getCallType() {
        return this.callType;
    }

    public KotlinCallableInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkParameterIsNotNull(callType, (String)"callType");
        this.callType = callType;
    }
}

