/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a>\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u001a>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\n\u0010 \u001a\u00020\u0001*\u00020!\"\u001e\u0010\u0000\u001a\u00020\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006\""}, d2={"emulateDexDebugInTests", "", "getEmulateDexDebugInTests", "()Z", "setEmulateDexDebugInTests", "(Z)V", "getLocationsOfInlinedLine", "", "Lcom/sun/jdi/Location;", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getOriginalPositionOfInlinedLine", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "", "lineNumber", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "inlinedLinesNumbers", "inlineLineNumber", "inlineFileName", "destinationTypeFqName", "destinationFileName", "isDexDebug", "Lcom/intellij/debugger/engine/DebugProcess;", "idea"})
public final class NoStrataPositionManagerHelperKt {
    private static volatile boolean emulateDexDebugInTests;

    @Nullable
    public static final Pair<KtFile, Integer> getOriginalPositionOfInlinedLine(int lineNumber, @NotNull FqName fqName2, @NotNull String fileName, @NotNull Project project, @NotNull GlobalSearchScope searchScope2) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        String internalName = StringsKt.replace$default((String)fqName2.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(internalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope2, jvmClassName2, fileName);
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        byte[] byArray = SmapUtilKt.readClassFile$default(project, jvmClassName3, virtualFile3, (Function1)new Function1<VirtualFile, Boolean>(lineNumber, project){
            final /* synthetic */ int $lineNumber;
            final /* synthetic */ Project $project;

            public final boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SmapUtilKt.isInlineFunctionLineNumber(it, this.$lineNumber, this.$project);
            }
            {
                this.$lineNumber = n;
                this.$project = project;
                super(1);
            }
        }, null, 16, null);
        if (byArray == null) {
            return null;
        }
        byte[] bytes2 = byArray;
        SmapData smapData = SmapUtilKt.readDebugInfo(bytes2);
        if (smapData == null) {
            return null;
        }
        SmapData smapData2 = smapData;
        return SmapUtilKt.mapStacktraceLineToSource(smapData2, lineNumber, project, SourceLineKind.EXECUTED_LINE, searchScope2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position2, @NotNull GlobalSearchScope sourceSearchScope) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)sourceSearchScope, (String)"sourceSearchScope");
        int line = position2.getLine();
        PsiFile file2 = position2.getFile();
        Project project = position2.getFile().getProject();
        Integer n = KotlinRefactoringUtilKt.getLineStartOffset(file2, line);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int lineStartOffset = n;
        PsiElement psiElement = file2.findElementAt(lineStartOffset);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element2 = psiElement;
        boolean isInInline2 = (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(element2){
            final /* synthetic */ PsiElement $element;

            public final boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents(this.$element);
                    for (E element$iv : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$element = psiElement;
                super(0);
            }
        });
        if (!isInInline2) {
            return CollectionsKt.emptyList();
        }
        String string = position2.getFile().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"position.file.name");
        FqName fqName2 = new FqName(type2.name());
        String string2 = type2.sourceName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.sourceName()");
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List<Integer> lines = NoStrataPositionManagerHelperKt.inlinedLinesNumbers(line + 1, string, fqName2, string2, project2, sourceSearchScope);
        Iterable iterable = lines;
        void var12_11 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            Iterable list$iv$iv = type2.locationsOfLine(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inlineLocations = (List)destination$iv$iv;
        return inlineLocations;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project, GlobalSearchScope sourceSearchScope) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        JvmClassName jvmClassName;
        String internalName = StringsKt.replace$default((String)destinationTypeFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(internalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, sourceSearchScope, jvmClassName2, destinationFileName);
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        byte[] byArray = SmapUtilKt.readClassFile$default(project, jvmClassName3, virtualFile3, null, null, 24, null);
        if (byArray == null) {
            return CollectionsKt.emptyList();
        }
        byte[] bytes2 = byArray;
        SmapData smapData = SmapUtilKt.readDebugInfo(bytes2);
        if (smapData == null) {
            return CollectionsKt.emptyList();
        }
        SmapData smapData2 = smapData;
        SMAP sMAP = smapData2.getKotlinStrata();
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP smap = sMAP;
        Iterable iterable = smap.getFileMappings();
        void var15_14 = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            FileMapping it = (FileMapping)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv2;
        $receiver$iv$iv2 = mappingsToInlinedFile;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv;
        List mappedLines2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), (Function1)((Function1)new Function1<RangeMapping, Boolean>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final boolean invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkParameterIsNotNull((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.hasMappingForSource(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)((Function1)new Function1<RangeMapping, Integer>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final int invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkParameterIsNotNull((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.mapSourceToDest(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)inlinedLinesNumbers.mappedLines.3.INSTANCE));
        return mappedLines2;
    }

    public static final boolean getEmulateDexDebugInTests() {
        return emulateDexDebugInTests;
    }

    public static final void setEmulateDexDebugInTests(boolean bl) {
        emulateDexDebugInTests = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDexDebug(@NotNull DebugProcess $receiver) {
        Object object;
        VirtualMachineProxy virtualMachineProxy;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (emulateDexDebugInTests) {
            if (ApplicationManager.getApplication().isUnitTestMode()) return true;
        }
        if (!((virtualMachineProxy = $receiver.getVirtualMachineProxy()) instanceof VirtualMachineProxyImpl)) {
            virtualMachineProxy = null;
        }
        if (!Intrinsics.areEqual((Object)((object = (VirtualMachineProxyImpl)virtualMachineProxy) != null && (object = object.getVirtualMachine()) != null ? object.name() : null), (Object)"Dalvik")) return false;
        return true;
    }
}

