/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.sun.jdi.LocalVariable;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepActionFactory;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepOverInlineFilter;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b6\u0018\u00002\u00020\u0001:\u0004\u001d\u001e\u001f BC\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "", "position", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "lineNumber", "", "stepOverLines", "", "inlineRangeVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Lcom/intellij/xdebugger/impl/XSourcePositionImpl;Ljava/lang/Integer;Ljava/util/Set;Ljava/util/List;)V", "getInlineRangeVariables", "()Ljava/util/List;", "getLineNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPosition", "()Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "getStepOverLines", "()Ljava/util/Set;", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "RUN_TO_CURSOR", "STEP_OUT", "STEP_OVER", "STEP_OVER_INLINED", "idea"})
public abstract class Action {
    @Nullable
    private final XSourcePositionImpl position;
    @Nullable
    private final Integer lineNumber;
    @Nullable
    private final Set<Integer> stepOverLines;
    @Nullable
    private final List<LocalVariable> inlineRangeVariables;

    public final void apply(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Action action2 = this;
        if (action2 instanceof RUN_TO_CURSOR) {
            ((DebugProcessImpl.ResumeCommand)ApplicationUtilsKt.runReadAction((Function0)new Function0<DebugProcessImpl.ResumeCommand>(this, debugProcess, suspendContext, ignoreBreakpoints){
                final /* synthetic */ Action this$0;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                final /* synthetic */ SuspendContextImpl $suspendContext;
                final /* synthetic */ boolean $ignoreBreakpoints;

                @NotNull
                public final DebugProcessImpl.ResumeCommand invoke() {
                    XSourcePositionImpl xSourcePositionImpl = this.this$0.getPosition();
                    if (xSourcePositionImpl == null) {
                        Intrinsics.throwNpe();
                    }
                    return this.$debugProcess.createRunToCursorCommand(this.$suspendContext, (XSourcePosition)xSourcePositionImpl, this.$ignoreBreakpoints);
                }
                {
                    this.this$0 = action2;
                    this.$debugProcess = debugProcessImpl;
                    this.$suspendContext = suspendContextImpl;
                    this.$ignoreBreakpoints = bl;
                    super(0);
                }
            })).contextAction(suspendContext);
        } else if (action2 instanceof STEP_OUT) {
            debugProcess.createStepOutCommand(suspendContext).contextAction(suspendContext);
        } else if (action2 instanceof STEP_OVER) {
            debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction(suspendContext);
        } else if (action2 instanceof STEP_OVER_INLINED) {
            KotlinStepActionFactory kotlinStepActionFactory = new KotlinStepActionFactory(debugProcess);
            Set<Integer> set = this.stepOverLines;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            Integer n = this.lineNumber;
            int n2 = n != null ? n : -1;
            List<LocalVariable> list2 = this.inlineRangeVariables;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            kotlinStepActionFactory.createKotlinStepOverInlineAction(new KotlinStepOverInlineFilter(set, n2, list2)).contextAction(suspendContext);
        }
    }

    @Nullable
    public final XSourcePositionImpl getPosition() {
        return this.position;
    }

    @Nullable
    public final Integer getLineNumber() {
        return this.lineNumber;
    }

    @Nullable
    public final Set<Integer> getStepOverLines() {
        return this.stepOverLines;
    }

    @Nullable
    public final List<LocalVariable> getInlineRangeVariables() {
        return this.inlineRangeVariables;
    }

    private Action(XSourcePositionImpl position2, Integer lineNumber, Set<Integer> stepOverLines, List<? extends LocalVariable> inlineRangeVariables) {
        this.position = position2;
        this.lineNumber = lineNumber;
        this.stepOverLines = stepOverLines;
        this.inlineRangeVariables = inlineRangeVariables;
    }

    /* synthetic */ Action(XSourcePositionImpl xSourcePositionImpl, Integer n, Set set, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            xSourcePositionImpl = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            set = null;
        }
        if ((n2 & 8) != 0) {
            list2 = null;
        }
        this(xSourcePositionImpl, n, set, list2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$STEP_OVER;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "()V", "idea"})
    public static final class STEP_OVER
    extends Action {
        public STEP_OVER() {
            super(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$STEP_OUT;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "()V", "idea"})
    public static final class STEP_OUT
    extends Action {
        public STEP_OUT() {
            super(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$RUN_TO_CURSOR;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "position", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "(Lcom/intellij/xdebugger/impl/XSourcePositionImpl;)V", "idea"})
    public static final class RUN_TO_CURSOR
    extends Action {
        public RUN_TO_CURSOR(@NotNull XSourcePositionImpl position2) {
            Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
            super(position2, null, null, null, 14, null);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$STEP_OVER_INLINED;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "lineNumber", "", "stepOverLines", "", "inlineVariables", "", "Lcom/sun/jdi/LocalVariable;", "(ILjava/util/Set;Ljava/util/List;)V", "idea"})
    public static final class STEP_OVER_INLINED
    extends Action {
        public STEP_OVER_INLINED(int lineNumber, @NotNull Set<Integer> stepOverLines, @NotNull List<? extends LocalVariable> inlineVariables) {
            Intrinsics.checkParameterIsNotNull(stepOverLines, (String)"stepOverLines");
            Intrinsics.checkParameterIsNotNull(inlineVariables, (String)"inlineVariables");
            super(null, lineNumber, stepOverLines, inlineVariables, 1, null);
        }
    }
}

