/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class ArrayInDataClassInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitClass(@NotNull KtClass klass2) {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                if (!klass2.isData()) {
                    return;
                }
                KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
                if (ktPrimaryConstructor == null) {
                    return;
                }
                KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                if (this.hasOverriddenEqualsAndHashCode(klass2)) {
                    return;
                }
                BindingContext context = ResolutionUtils.analyze(constructor2, BodyResolveMode.PARTIAL);
                for (KtParameter parameter : constructor2.getValueParameters()) {
                    KotlinType type2;
                    if (!parameter.hasValOrVar()) continue;
                    if ((KotlinType)context.get(BindingContext.TYPE, parameter.getTypeReference()) == null) {
                        continue;
                    }
                    if (!KotlinBuiltIns.isArray(type2) && !KotlinBuiltIns.isPrimitiveArray(type2)) continue;
                    this.$holder.registerProblem((PsiElement)parameter, "Array property in data class: it's recommended to override equals() / hashCode()", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            private final boolean hasOverriddenEqualsAndHashCode(KtClass klass2) {
                boolean overriddenEquals = false;
                boolean overriddenHashCode = false;
                for (KtDeclaration declaration : klass2.getDeclarations()) {
                    if (!(declaration instanceof KtFunction) || !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
                    if (Intrinsics.areEqual((Object)((KtFunction)declaration).getNameAsName(), (Object)OperatorNameConventions.EQUALS) && ((KtFunction)declaration).getValueParameters().size() == 1) {
                        KtParameter parameter = (KtParameter)CollectionsKt.single(((KtFunction)declaration).getValueParameters());
                        BindingContext context = ResolutionUtils.analyze(declaration, BodyResolveMode.PARTIAL);
                        KotlinType type2 = (KotlinType)context.get(BindingContext.TYPE, parameter.getTypeReference());
                        if (type2 != null && KotlinBuiltIns.isNullableAny(type2)) {
                            overriddenEquals = true;
                        }
                    }
                    if (!Intrinsics.areEqual((Object)((KtFunction)declaration).getName(), (Object)"hashCode") || ((KtFunction)declaration).getValueParameters().size() != 0) continue;
                    overriddenHashCode = true;
                }
                return overriddenEquals && overriddenHashCode;
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

