/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/CanBePrimaryConstructorPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "MakeConstructorPropertyFix", "idea"})
public final class CanBePrimaryConstructorPropertyInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                if (property2.isLocal()) {
                    return;
                }
                if (property2.getGetter() != null || property2.getSetter() != null || property2.getDelegate() != null) {
                    return;
                }
                KtExpression ktExpression = property2.getInitializer();
                if (!(ktExpression instanceof KtReferenceExpression)) {
                    ktExpression = null;
                }
                KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
                if (ktReferenceExpression == null) {
                    return;
                }
                KtReferenceExpression assigned = ktReferenceExpression;
                BindingContext context = ResolutionUtils.analyzeFully(property2);
                V v = context.get(BindingContext.REFERENCE_TARGET, assigned);
                if (!(v instanceof ValueParameterDescriptor)) {
                    v = null;
                }
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)v;
                if (valueParameterDescriptor == null) {
                    return;
                }
                ValueParameterDescriptor assignedDescriptor = valueParameterDescriptor;
                if (!assignedDescriptor.getAnnotations().isEmpty() || !KtPsiUtilKt.getAnnotationEntries(assigned).isEmpty()) {
                    return;
                }
                CallableDescriptor callableDescriptor = assignedDescriptor.getContainingDeclaration();
                if (!(callableDescriptor instanceof ConstructorDescriptor)) {
                    callableDescriptor = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)callableDescriptor;
                if (constructorDescriptor == null) {
                    return;
                }
                ConstructorDescriptor containingConstructor = constructorDescriptor;
                if (containingConstructor.getContainingDeclaration().isData()) {
                    return;
                }
                KtTypeReference propertyTypeReference = property2.getTypeReference();
                KotlinType propertyType = (KotlinType)context.get(BindingContext.TYPE, propertyTypeReference);
                if (propertyType != null && Intrinsics.areEqual((Object)propertyType, (Object)assignedDescriptor.getType()) ^ true) {
                    return;
                }
                PsiElement psiElement = property2.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement;
                if (Intrinsics.areEqual((Object)nameIdentifier.getText(), (Object)assignedDescriptor.getName().asString()) ^ true) {
                    return;
                }
                PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(assignedDescriptor);
                if (!(psiElement2 instanceof KtParameter)) {
                    psiElement2 = null;
                }
                KtParameter ktParameter = (KtParameter)psiElement2;
                if (ktParameter == null) {
                    return;
                }
                KtParameter assignedParameter = ktParameter;
                if (KtPsiUtilKt.getContainingClassOrObject(property2) != KtPsiUtilKt.getContainingClassOrObject(assignedParameter)) {
                    return;
                }
                this.$holder.registerProblem(this.$holder.getManager().createProblemDescriptor(nameIdentifier, nameIdentifier, "Property is explicitly assigned to parameter " + assignedDescriptor.getName() + ", can be declared directly in constructor", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, new LocalQuickFix[]{new MakeConstructorPropertyFix(property2, assignedParameter)}));
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$isOnTheFly = $captured_local_variable$1;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/CanBePrimaryConstructorPropertyInspection$MakeConstructorPropertyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "original", "Lorg/jetbrains/kotlin/psi/KtProperty;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getOriginal", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getParameter", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class MakeConstructorPropertyFix
    implements LocalQuickFix {
        @NotNull
        private final KtProperty original;
        @NotNull
        private final KtParameter parameter;

        @NotNull
        public String getName() {
            return "Move to constructor";
        }

        @NotNull
        public String getFamilyName() {
            return "Move to constructor";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            CommentSaver commentSaver = new CommentSaver(this.original, false, 2, null);
            boolean isVar = this.original.isVar();
            KtModifierList ktModifierList = this.original.getModifierList();
            String modifiers = ktModifierList != null ? ktModifierList.getText() : null;
            KtPsiFactory factory2 = new KtPsiFactory(project);
            PsiElement valOrVar = isVar ? factory2.createVarKeyword() : factory2.createValKeyword();
            this.parameter.addBefore(valOrVar, this.parameter.getNameIdentifier());
            if (modifiers != null) {
                KtModifierList newModifiers = factory2.createModifierList(modifiers);
                this.parameter.addBefore((PsiElement)newModifiers, this.parameter.getValOrVarKeyword());
            }
            this.original.delete();
            CommentSaver.restore$default(commentSaver, this.parameter, false, 2, null);
        }

        @NotNull
        public final KtProperty getOriginal() {
            return this.original;
        }

        @NotNull
        public final KtParameter getParameter() {
            return this.parameter;
        }

        public MakeConstructorPropertyFix(@NotNull KtProperty original, @NotNull KtParameter parameter) {
            Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            this.original = original;
            this.parameter = parameter;
        }
    }
}

