/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.ReplaceSubstringIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceSubstringWithDropLastIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ReplaceSubstringIntention;", "()V", "applicabilityRangeInner", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isLengthAccess", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedReceiver", "idea"})
public final class ReplaceSubstringWithDropLastIntention
extends ReplaceSubstringIntention {
    @Override
    @Nullable
    protected TextRange applicabilityRangeInner(@NotNull KtDotQualifiedExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Object object = UtilsKt.getCallExpression(element2);
        if (object == null || (object = ((KtCallExpression)object).getValueArguments()) == null) {
            return null;
        }
        Object arguments2 = object;
        if (arguments2.size() != 2 || !this.isFirstArgumentZero(element2)) {
            return null;
        }
        KtExpression secondArgumentExpression = ((KtValueArgument)arguments2.get(1)).getArgumentExpression();
        if (!(secondArgumentExpression instanceof KtBinaryExpression)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((KtBinaryExpression)secondArgumentExpression).getOperationReference().getReferencedNameElementType(), (Object)((Object)KtTokens.MINUS)) ^ true) {
            return null;
        }
        if (this.isLengthAccess(((KtBinaryExpression)secondArgumentExpression).getLeft(), element2.getReceiverExpression())) {
            return this.getTextRange(element2);
        }
        return null;
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element2, @Nullable Editor editor) {
        KtExpression rightExpression;
        KtExpression argument2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element2);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression = ktCallExpression.getValueArguments().get(1).getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression2 = argument2 = ktExpression;
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtExpression ktExpression3 = ((KtBinaryExpression)ktExpression2).getRight();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression4 = rightExpression = ktExpression3;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"rightExpression");
        this.replaceWith(element2, "$0.dropLast($1)", ktExpression4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLengthAccess(KtExpression expression2, KtExpression expectedReceiver) {
        if (!(expression2 instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
        KtExpression it = ktExpression;
        if (!(it instanceof KtNameReferenceExpression)) return false;
        if (!Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getReferencedName(), (Object)"length")) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!IfThenUtilsKt.evaluatesTo(((KtDotQualifiedExpression)expression2).getReceiverExpression(), expectedReceiver)) return false;
        return true;
    }

    public ReplaceSubstringWithDropLastIntention() {
        super("Replace 'substring' call with 'dropLast' call");
    }
}

