/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2jsrun;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSConfigurationSettings;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSRunConfiguration;

public final class K2JSRunnerUtils {
    private K2JSRunnerUtils() {
    }

    @NotNull
    public static String constructPathToGeneratedFile(@NotNull Project project, @NotNull String outputDirPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "constructPathToGeneratedFile"));
        }
        if (outputDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirPath", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "constructPathToGeneratedFile"));
        }
        String string = outputDirPath + "/" + project.getName() + ".js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "constructPathToGeneratedFile"));
        }
        return string;
    }

    public static void copyJSFileFromOutputToDestination(@NotNull Project project, @NotNull K2JSConfigurationSettings configurationSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "copyJSFileFromOutputToDestination"));
        }
        if (configurationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationSettings", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "copyJSFileFromOutputToDestination"));
        }
        VirtualFile outputDir = K2JSRunnerUtils.getOutputDir(project);
        if (outputDir == null) {
            throw new RuntimeException("Cannot find output dir for project " + project.getName());
        }
        String pathToGeneratedJsFile = K2JSRunnerUtils.constructPathToGeneratedFile(project, outputDir.getPath());
        try {
            K2JSRunnerUtils.copyFileToDir(new File(pathToGeneratedJsFile), new File(configurationSettings.getGeneratedFilePath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Output JavaScript file was not generated or missing.", e);
        }
    }

    @Nullable
    private static VirtualFile getOutputDir(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "getOutputDir"));
        }
        Module module = K2JSRunnerUtils.getJsModule(project);
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
    }

    @NotNull
    public static Module getJsModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "getJsModule"));
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length != 1) {
            throw new UnsupportedOperationException("Kotlin to JavaScript translator temporarily does not support multiple modules.");
        }
        Module module = modules[0];
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "getJsModule"));
        }
        return module;
    }

    public static void openBrowser(@NotNull K2JSConfigurationSettings configurationSettings) {
        if (configurationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationSettings", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "openBrowser"));
        }
        if (!configurationSettings.isShouldOpenInBrowserAfterTranslation()) {
            return;
        }
        String filePath = configurationSettings.getPageToOpenFilePath();
        String url = VirtualFileManager.constructUrl((String)"file", (String)filePath);
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(configurationSettings.getBrowserFamily().getName());
        BrowserLauncher.getInstance().browse(url, browser);
    }

    @NotNull
    public static K2JSConfigurationSettings getSettings(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "getSettings"));
        }
        RunProfile profile = env.getRunProfile();
        assert (profile instanceof K2JSRunConfiguration);
        K2JSConfigurationSettings k2JSConfigurationSettings = ((K2JSRunConfiguration)profile).settings();
        if (k2JSConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "getSettings"));
        }
        return k2JSConfigurationSettings;
    }

    public static void copyFileToDir(@NotNull File file2, @NotNull File dir) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "copyFileToDir"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunnerUtils", "copyFileToDir"));
        }
        FileUtil.copy((File)file2, (File)new File(dir, file2.getName()));
    }
}

