/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "showHint", "", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;Ljava/util/Collection;Z)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$OPERATOR;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MyFactory", "idea"})
public class ArrayAccessorImportFix
extends OrdinaryImportFixBase<KtArrayAccessExpression> {
    @NotNull
    private final Collection<Name> importNames;
    private final boolean showHint;
    public static final MyFactory MyFactory = new MyFactory(null);

    @NotNull
    protected CallTypeAndReceiver.OPERATOR getCallTypeAndReceiver() {
        KtExpression ktExpression = ((KtArrayAccessExpression)this.getElement()).getArrayExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.arrayExpression!!");
        return new CallTypeAndReceiver.OPERATOR(ktExpression);
    }

    @Override
    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.showHint && super.showHint(editor);
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    public ArrayAccessorImportFix(@NotNull KtArrayAccessExpression element2, @NotNull Collection<Name> importNames, boolean showHint) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(importNames, (String)"importNames");
        super((KtExpression)element2, MyFactory);
        this.importNames = importNames;
        this.showHint = showHint;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "importName", "Lorg/jetbrains/kotlin/name/Name;", "idea"})
    public static final class MyFactory
    extends ImportFixBase.Factory {
        private final Name importName(Diagnostic diagnostic) {
            Name name2;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_GET_METHOD)) {
                name2 = OperatorNameConventions.GET;
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_SET_METHOD)) {
                name2 = OperatorNameConventions.SET;
            } else {
                throw (Throwable)new IllegalStateException("Shouldn't be called for other diagnostics");
            }
            return name2;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtArrayAccessExpression> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            boolean bl = Intrinsics.areEqual(factory2, Errors.NO_GET_METHOD) || Intrinsics.areEqual(factory2, Errors.NO_SET_METHOD);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiElement element2 = diagnostic.getPsiElement();
            if (element2 instanceof KtArrayAccessExpression && ((KtArrayAccessExpression)element2).getArrayExpression() != null) {
                KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktArrayAccessExpression, (String)"element");
                return new ArrayAccessorImportFix(ktArrayAccessExpression, (Collection<Name>)AddToStdlibKt.singletonList(this.importName(diagnostic)), true);
            }
            return null;
        }

        private MyFactory() {
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

