/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\tH\u0016J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isThis", "", "element", "(ZLorg/jetbrains/kotlin/psi/KtSecondaryConstructor;)V", "()Z", "keywordToUse", "", "getFamilyName", "getText", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "InsertSuperDelegationCallFactory", "InsertThisDelegationCallFactory", "idea"})
public final class InsertDelegationCallQuickfix
extends KotlinQuickFixAction<KtSecondaryConstructor> {
    private final String keywordToUse;
    private final boolean isThis;

    @NotNull
    public String getText() {
        return KotlinBundle.message("insert.delegation.call", this.keywordToUse);
    }

    @NotNull
    public String getFamilyName() {
        return "Insert explicit delegation call";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtConstructorDelegationCall newDelegationCall = ((KtSecondaryConstructor)this.getElement()).replaceImplicitDelegationCallWithExplicit(this.isThis);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(newDelegationCall, ResolutionUtils.analyze$default(newDelegationCall, null, 1, null));
            DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor((KtDeclaration)this.getElement());
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 != null ? ArgumentMappingKt.isReallySuccess(resolvedCall3) : false) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall2;
                if (resolvedCall4 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)resolvedCall4.getCandidateDescriptor().getOriginal(), (Object)descriptor2) ^ true) {
                    return;
                }
            }
            KtValueArgumentList ktValueArgumentList = newDelegationCall.getValueArgumentList();
            if (ktValueArgumentList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = ktValueArgumentList.getLeftParenthesis();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            int leftParOffset = psiElement.getTextOffset();
            Editor editor2 = editor;
            if (editor2 == null) break block5;
            GenerateUtilKt.moveCaret$default(editor2, leftParOffset + 1, null, 2, null);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return super.isAvailable(project, editor, file2) && ((KtSecondaryConstructor)this.getElement()).hasImplicitDelegationCall();
    }

    public final boolean isThis() {
        return this.isThis;
    }

    public InsertDelegationCallQuickfix(boolean isThis, @NotNull KtSecondaryConstructor element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
        this.isThis = isThis;
        this.keywordToUse = this.isThis ? "this" : "super";
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertThisDelegationCallFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getConstructorsCount", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "idea"})
    public static final class InsertThisDelegationCallFactory
    extends KotlinSingleIntentionActionFactory {
        public static final InsertThisDelegationCallFactory INSTANCE;

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtSecondaryConstructor> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Diagnostic $receiver$iv = diagnostic;
            PsiElement $receiver$iv$iv = $receiver$iv.getPsiElement();
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtSecondaryConstructor.class, (boolean)false);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                KtSecondaryConstructor secondaryConstructor = (KtSecondaryConstructor)psiElement2;
                if (INSTANCE.getConstructorsCount(secondaryConstructor.getContainingClassOrObject()) <= 1 || !secondaryConstructor.hasImplicitDelegationCall()) {
                    return null;
                }
                return new InsertDelegationCallQuickfix(true, secondaryConstructor);
            }
            return null;
        }

        private final int getConstructorsCount(@NotNull KtClassOrObject $receiver) {
            DeclarationDescriptor declarationDescriptor = UtilsKt.getDescriptor($receiver);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return ((ClassDescriptor)declarationDescriptor).getConstructors().size();
        }

        private InsertThisDelegationCallFactory() {
            INSTANCE = this;
        }

        static {
            new InsertThisDelegationCallFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertSuperDelegationCallFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class InsertSuperDelegationCallFactory
    extends KotlinSingleIntentionActionFactory {
        public static final InsertSuperDelegationCallFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement $receiver$iv = diagnostic.getPsiElement();
            KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtSecondaryConstructor.class, (boolean)false);
            if (ktSecondaryConstructor == null) {
                return null;
            }
            KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
            if (!secondaryConstructor.hasImplicitDelegationCall()) {
                return null;
            }
            KtClassOrObject ktClassOrObject = secondaryConstructor.getContainingClassOrObject();
            if (!(ktClassOrObject instanceof KtClass)) {
                ktClassOrObject = null;
            }
            KtClass ktClass = (KtClass)ktClassOrObject;
            if (ktClass == null) {
                return null;
            }
            KtClass klass2 = ktClass;
            if (klass2.hasPrimaryConstructor()) {
                return null;
            }
            return new InsertDelegationCallQuickfix(false, secondaryConstructor);
        }

        private InsertSuperDelegationCallFactory() {
            INSTANCE = this;
        }

        static {
            new InsertSuperDelegationCallFactory();
        }
    }
}

