/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureHandler;", "()V", "findTargetMember", "Lcom/intellij/psi/PsiElement;", "element", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getTargetNotFoundMessage", "", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "Companion", "idea"})
public final class KotlinChangeSignatureHandler
implements ChangeSignatureHandler {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file2, @NotNull Editor editor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        PsiElement psiElement2 = file2.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement2 != null) {
            PsiElement it;
            PsiElement psiElement3 = psiElement2;
            PsiElement psiElement4 = it = psiElement3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
            psiElement = this.findTargetMember(psiElement4);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return Companion.findTargetForRefactoring(element2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement psiElement = this.findTargetMember(file2, editor);
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if (psiElement == null) {
            return;
        }
        PsiElement element2 = psiElement;
        PsiElement psiElement2 = file2.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement2 == null) {
            return;
        }
        PsiElement elementAtCaret = psiElement2;
        if (!(element2 instanceof KtElement)) {
            throw (Throwable)((Object)new AssertionError((Object)("This handler must be invoked for Kotlin elements only: " + element2.getText())));
        }
        KtElement ktElement = (KtElement)element2;
        PsiElement psiElement3 = elementAtCaret;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"elementAtCaret");
        Companion.invokeChangeSignature(ktElement, psiElement3, project, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Editor editor;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        PsiElement psiElement = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement == null || (psiElement = LightClassUtilsKt.getUnwrapped(psiElement)) == null) {
            return;
        }
        PsiElement element2 = psiElement;
        if (!(element2 instanceof KtElement)) {
            throw (Throwable)((Object)new AssertionError((Object)("This handler must be invoked for Kotlin elements only: " + element2.getText())));
        }
        DataContext dataContext2 = dataContext;
        if (dataContext2 != null) {
            DataContext dataContext3 = dataContext2;
            DataContext it = dataContext3;
            editor = (Editor)CommonDataKeys.EDITOR.getData(it);
        } else {
            editor = null;
        }
        Editor editor2 = editor;
        Companion.invokeChangeSignature((KtElement)element2, element2, project, editor2);
    }

    @NotNull
    public String getTargetNotFoundMessage() {
        return KotlinRefactoringBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler$Companion;", "", "()V", "findDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findTargetForRefactoring", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "invokeChangeSignature", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "context", "idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiElement findTargetForRefactoring(@NotNull PsiElement element2) {
            KtElement calleeExpr;
            block17: {
                void $receiver$iv;
                KtCallElement $i$a$2$let;
                KtElement ktElement;
                block16: {
                    KtExpression ktExpression;
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    PsiElement elementParent = element2.getParent();
                    if (elementParent instanceof KtNamedFunction || elementParent instanceof KtClass || elementParent instanceof KtProperty) {
                        PsiElement psiElement = elementParent;
                        if (psiElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                        }
                        if (((KtNamedDeclaration)psiElement).getNameIdentifier() == element2) {
                            return elementParent;
                        }
                    }
                    if (elementParent instanceof KtParameter) {
                        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)elementParent, KtPrimaryConstructor.class);
                        if (((KtParameter)elementParent).hasValOrVar() && (((KtParameter)elementParent).getNameIdentifier() == element2 || ((KtParameter)elementParent).getValOrVarKeyword() == element2) && primaryConstructor2 != null && primaryConstructor2.getValueParameterList() == ((KtParameter)elementParent).getParent()) {
                            return elementParent;
                        }
                    }
                    if (elementParent instanceof KtSecondaryConstructor && ((KtSecondaryConstructor)elementParent).getConstructorKeyword() == element2) {
                        return elementParent;
                    }
                    Object $receiver$iv2 = element2;
                    KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtParameterList.class, (boolean)true);
                    if (ktParameterList != null) {
                        $receiver$iv2 = ktParameterList;
                        KtParameterList parameterList2 = (KtParameterList)$receiver$iv2;
                        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)parameterList2), (Class[])new Class[]{KtFunction.class, KtProperty.class, KtClass.class});
                    }
                    $receiver$iv2 = element2;
                    KtTypeParameterList ktTypeParameterList = (KtTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtTypeParameterList.class, (boolean)true);
                    if (ktTypeParameterList != null) {
                        $receiver$iv2 = ktTypeParameterList;
                        KtTypeParameterList typeParameterList = (KtTypeParameterList)$receiver$iv2;
                        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)typeParameterList), (Class[])new Class[]{KtFunction.class, KtProperty.class, KtClass.class});
                    }
                    KtCallElement call = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{KtCallExpression.class, KtSuperTypeCallEntry.class, KtConstructorDelegationCall.class});
                    ktElement = call;
                    if (ktElement == null) break block16;
                    $i$a$2$let = ktElement;
                    KtCallElement it = $i$a$2$let;
                    KtExpression callee = it.getCalleeExpression();
                    KtExpression ktExpression2 = callee;
                    if (!(ktExpression2 instanceof KtConstructorCalleeExpression)) {
                        ktExpression2 = null;
                    }
                    if (((ktExpression = (KtConstructorCalleeExpression)ktExpression2) != null && (ktExpression = ktExpression.getConstructorReferenceExpression()) != null ? (KtExpression)ktExpression : (ktElement = callee)) != null) break block17;
                }
                $i$a$2$let = element2;
                ktElement = calleeExpr = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtSimpleNameExpression.class, (boolean)true);
            }
            if (calleeExpr instanceof KtSimpleNameExpression || calleeExpr instanceof KtConstructorDelegationReferenceExpression) {
                void $receiver$iv;
                PsiElement $i$f$getStrictParentOfType = element2;
                KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtElement.class, (boolean)true);
                if (ktElement == null) {
                    return null;
                }
                KtElement jetElement = ktElement;
                BindingContext bindingContext2 = ResolutionUtils.analyze(jetElement, BodyResolveMode.FULL);
                KtElement ktElement2 = calleeExpr;
                if (ktElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                }
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)ktElement2);
                if (descriptor2 instanceof ClassDescriptor || descriptor2 instanceof CallableDescriptor) {
                    return (PsiElement)calleeExpr;
                }
            }
            return null;
        }

        public final void invokeChangeSignature(@NotNull KtElement element2, @NotNull PsiElement context, @NotNull Project project, @Nullable Editor editor) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.FULL);
            CallableDescriptor callableDescriptor = this.findDescriptor((PsiElement)element2, project, editor, bindingContext2);
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof JavaCallableMemberDescriptor) {
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, callableDescriptor2);
                if (declaration instanceof PsiClass) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return;
                }
                boolean bl = declaration instanceof PsiMethod;
                if (_Assertions.ENABLED && !bl) {
                    String string = "PsiMethod expected: " + callableDescriptor2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                PsiElement psiElement = declaration;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                }
                ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)((PsiMethod)psiElement), (Project)project);
                return;
            }
            if (DynamicCallsKt.isDynamic(callableDescriptor2)) {
                if (editor != null) {
                    CodeInsightUtils.showErrorHint(project, editor, "Change signature is not applicable to dynamically invoked functions", "Change Signature", null);
                }
                return;
            }
            KotlinChangeSignatureKt.runChangeSignature(project, callableDescriptor2, KotlinChangeSignatureConfiguration.Empty.INSTANCE, context, null);
        }

        private final DeclarationDescriptor getDescriptor(BindingContext bindingContext2, PsiElement element2) {
            PsiElement psiElement = element2;
            DeclarationDescriptor descriptor2 = psiElement instanceof KtReferenceExpression ? (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, element2) : bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
            return descriptor2 instanceof ClassDescriptor ? (DeclarationDescriptor)((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : descriptor2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CallableDescriptor findDescriptor(@NotNull PsiElement element2, @NotNull Project project, @Nullable Editor editor, @NotNull BindingContext bindingContext2) {
            CallableDescriptor callableDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element2)) {
                return null;
            }
            DeclarationDescriptor descriptor2 = this.getDescriptor(bindingContext2, element2);
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof FunctionDescriptor) {
                String message2;
                boolean bl;
                block9: {
                    void $receiver$iv;
                    Iterable iterable = ((FunctionDescriptor)descriptor2).getValueParameters();
                    for (Object element$iv : $receiver$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        if (!(it.getVarargElementType() != null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) {
                    message2 = KotlinRefactoringBundle.message("error.cant.refactor.vararg.functions", new Object[0]);
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return null;
                }
                if (((FunctionDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                    message2 = KotlinRefactoringBundle.message("cannot.refactor.synthesized.function", ((FunctionDescriptor)descriptor2).getName());
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return null;
                }
                callableDescriptor = (CallableDescriptor)descriptor2;
            } else if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof ValueParameterDescriptor) {
                DeclarationDescriptor declarationDescriptor2 = descriptor2;
                if (declarationDescriptor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                }
                callableDescriptor = (CallableDescriptor)declarationDescriptor2;
            } else {
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)KotlinRefactoringBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                callableDescriptor = null;
            }
            return callableDescriptor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

