/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u0011"}, d2={"addParameter", "", "method", "Lcom/intellij/psi/PsiMethod;", "result", "", "Lcom/intellij/psi/PsiElement;", "parameter", "Lcom/intellij/psi/PsiParameter;", "checkParametersInMethodHierarchy", "", "collectParametersHierarchy", "", "canDeleteElement", "", "cleanUpOverrides", "removeOverrideModifier", "idea"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtObjectDeclaration && ((KtObjectDeclaration)$receiver).isObjectLiteral()) {
            return false;
        }
        if ($receiver instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)$receiver).getParent();
            if (!(psiElement instanceof KtParameterList)) {
                psiElement = null;
            }
            KtParameterList ktParameterList = (KtParameterList)psiElement;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList2 = ktParameterList;
            PsiElement psiElement2 = parameterList2.getParent();
            if (!(psiElement2 instanceof KtDeclaration)) {
                psiElement2 = null;
            }
            KtDeclaration ktDeclaration = (KtDeclaration)psiElement2;
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration = ktDeclaration;
            return !(declaration instanceof KtPropertyAccessor);
        }
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtSecondaryConstructor || $receiver instanceof KtNamedFunction || $receiver instanceof PsiMethod || $receiver instanceof PsiClass || $receiver instanceof KtProperty || $receiver instanceof KtTypeParameter;
    }

    public static final void removeOverrideModifier(@NotNull PsiElement $receiver) {
        block5: {
            Object object;
            block3: {
                PsiElement psiElement;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    psiElement = $receiver;
                    if (!(psiElement instanceof KtNamedFunction) && !(psiElement instanceof KtProperty)) break block4;
                    PsiElement psiElement2 = $receiver;
                    if (psiElement2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierListOwner");
                    }
                    KtModifierList ktModifierList = ((KtModifierListOwner)psiElement2).getModifierList();
                    if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) break block5;
                    ktModifierList.delete();
                    break block5;
                }
                if (!(psiElement instanceof PsiMethod)) break block5;
                Object[] $receiver$iv = ((PsiMethod)$receiver).getModifierList().getAnnotations();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    PsiAnnotation annotation2 = (PsiAnnotation)element$iv;
                    if (!Intrinsics.areEqual((Object)annotation2.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    object = element$iv;
                    break block3;
                }
                object = null;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)object;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void cleanUpOverrides(@NotNull PsiMethod $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiMethod[] superMethods = $receiver.findSuperMethods(true);
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$receiver, (boolean)true).findAll()) {
            boolean bl;
            block2: {
                void $receiver$iv;
                Sequence currentSuperMethods;
                Sequence sequence2 = currentSuperMethods = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])overridingMethod.findSuperMethods(true)), (Sequence)ArraysKt.asSequence((Object[])superMethods));
                for (Object element$iv : $receiver$iv) {
                    PsiMethod superMethod = (PsiMethod)element$iv;
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)superMethod), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)$receiver))) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)overridingMethod);
            if (psiElement == null) continue;
            UtilsKt.removeOverrideModifier(psiElement);
        }
    }

    @Nullable
    public static final Collection<PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement = parameter.getDeclarationScope();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
        }
        PsiMethod method = (PsiMethod)psiElement;
        Set<PsiElement> parametersToDelete = UtilsKt.collectParametersHierarchy(method, parameter);
        if (parametersToDelete.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            return parametersToDelete;
        }
        String message2 = KotlinBundle.message("delete.param.in.method.hierarchy", RenderingUtilsKt.formatJavaOrLightMethod(method));
        int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? (Collection)parametersToDelete : (Collection)null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<PsiElement> collectParametersHierarchy(PsiMethod method, PsiParameter parameter) {
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet visited2 = new HashSet();
        HashSet parametersToDelete = new HashSet();
        queue.add(method);
        while (!queue.isEmpty()) {
            Object element$iv2;
            void destination$iv$iv;
            PsiMethod it;
            Object element$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            Object[] objectArray = (Object[])visited2;
            objectArray.add(currentMethod);
            PsiMethod psiMethod2 = currentMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"currentMethod");
            UtilsKt.addParameter(psiMethod2, parametersToDelete, parameter);
            objectArray = currentMethod.findSuperMethods(true);
            Iterator iterator2 = $receiver$iv;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                element$iv$iv = $receiver$iv$iv[i];
                it = (PsiMethod)element$iv$iv;
                if (!(visited2.contains(it) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv) {
                PsiMethod it2 = (PsiMethod)element$iv2;
                queue.offer(it2);
            }
            $receiver$iv = (Iterable)OverridingMethodsSearch.search((PsiMethod)currentMethod);
            $receiver$iv$iv = $receiver$iv;
            element$iv2 = new ArrayList();
            PsiMethod it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                element$iv$iv = it2.next();
                it = (PsiMethod)element$iv$iv;
                if (!(visited2.contains(it) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv) {
                it2 = (PsiMethod)element$iv2;
                queue.offer(it2);
            }
        }
        return parametersToDelete;
    }

    private static final void addParameter(PsiMethod method, Set<PsiElement> result2, PsiParameter parameter) {
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)parameter);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        int parameterIndex2 = KtPsiUtilKt.parameterIndex(psiElement);
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration instanceof KtFunction) {
                KtParameter ktParameter = ((KtFunction)declaration).getValueParameters().get(parameterIndex2);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"declaration.valueParameters[parameterIndex]");
                result2.add(ktParameter);
            }
        } else {
            PsiParameter psiParameter = method.getParameterList().getParameters()[parameterIndex2];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"method.parameterList.parameters[parameterIndex]");
            result2.add((PsiElement)psiParameter);
        }
    }
}

