/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.structureView.KotlinInheritedMembersNodeProvider;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureViewElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinStructureViewModel
extends StructureViewModelBase {
    private static final Collection<NodeProvider> NODE_PROVIDERS = Arrays.asList(new NodeProvider[]{new KotlinInheritedMembersNodeProvider()});
    private static final Sorter[] sorters = new Sorter[]{Sorter.ALPHA_SORTER};

    public KotlinStructureViewModel(@NotNull KtFile jetFile) {
        if (jetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFile", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewModel", "<init>"));
        }
        super((PsiFile)jetFile, (StructureViewTreeElement)new KotlinStructureViewElement(jetFile, false));
        this.withSuitableClasses(new Class[]{KtDeclaration.class});
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        Collection<NodeProvider> collection = NODE_PROVIDERS;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewModel", "getNodeProviders"));
        }
        return collection;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (sorters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewModel", "getSorters"));
        }
        return sorters;
    }
}

