/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.BinaryVersionedFile;
import org.jetbrains.kotlin.idea.versions.KotlinJavaScriptAbiVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.JsVirtualFileFinder;
import org.jetbrains.kotlin.idea.vfilefinder.JsVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.JsBinaryVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u0007\u001a\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\t\u001a\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00140\u00132\u0006\u0010\u0016\u001a\u00020\t\u001aU\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u00140\u0013\"\b\b\u0000\u0010\u001a*\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001c\u001a\u0002H\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u0012\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010\r\u001a\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\rH\u0000\u001a\u0016\u0010*\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0002\u001a\"\u0010,\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020/H\u0002\u001a\u001c\u00100\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u0013\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u00062"}, d2={"PLUGIN_VERSIONS_SEPARATORS", "", "", "[Ljava/lang/String;", "bundledRuntimeVersion", "pluginVersion", "findAllUsedLibraries", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getKotlinJsRuntimeMarkerClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getKotlinJvmRuntimeMarkerClass", "Lcom/intellij/psi/PsiClass;", "getLibraryRootsWithAbiIncompatibleForKotlinJs", "", "Lorg/jetbrains/kotlin/idea/versions/BinaryVersionedFile;", "Lorg/jetbrains/kotlin/utils/JsBinaryVersion;", "module", "getLibraryRootsWithAbiIncompatibleKotlinClasses", "Lorg/jetbrains/kotlin/load/kotlin/JvmMetadataVersion;", "getLibraryRootsWithAbiIncompatibleVersion", "T", "Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;", "supportedVersion", "index", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "checkVersion", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;Lcom/intellij/util/indexing/ScalarIndexExtension;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "getLocalJar", "kotlinRuntimeJar", "replaceFile", "", "updatedFile", "Ljava/io/File;", "replacedJarFile", "showRuntimeJarNotFoundDialog", "jarName", "updateJar", "fileToReplace", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "updateLibraries", "libraries", "idea"})
public final class KotlinRuntimeLibraryUtilKt {
    private static final String[] PLUGIN_VERSIONS_SEPARATORS;

    @NotNull
    public static final Collection<BinaryVersionedFile<JvmMetadataVersion>> getLibraryRootsWithAbiIncompatibleKotlinClasses(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JvmMetadataVersion.INSTANCE, KotlinMetadataVersionIndex.INSTANCE, getLibraryRootsWithAbiIncompatibleKotlinClasses.1.INSTANCE);
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JsBinaryVersion>> getLibraryRootsWithAbiIncompatibleForKotlinJs(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JsBinaryVersion.INSTANCE, KotlinJavaScriptAbiVersionIndex.INSTANCE, getLibraryRootsWithAbiIncompatibleForKotlinJs.1.INSTANCE);
    }

    public static final void updateLibraries(@NotNull Project project, @NotNull Collection<? extends Library> libraries) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        ApplicationManager.getApplication().invokeLater(new Runnable(project, libraries){
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $libraries;

            public final void run() {
                KotlinJavaModuleConfigurator kotlinJavaModuleConfigurator = (KotlinJavaModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("java");
                if (kotlinJavaModuleConfigurator == null) {
                    String string = "Configurator with given name doesn't exists: java";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KotlinJavaModuleConfigurator kJvmConfigurator = kotlinJavaModuleConfigurator;
                KotlinJsModuleConfigurator kotlinJsModuleConfigurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("js");
                if (kotlinJsModuleConfigurator == null) {
                    String string = "Configurator with given name doesn't exists: js";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KotlinJsModuleConfigurator kJsConfigurator = kotlinJsModuleConfigurator;
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                for (Library library : this.$libraries) {
                    LibraryPresentationProvider libraryPresentationProvider = JavaRuntimePresentationProvider.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)libraryPresentationProvider, (String)"JavaRuntimePresentationProvider.getInstance()");
                    if (KotlinLibraryUtilKt.isDetected(libraryPresentationProvider, library)) {
                        KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getRuntimeJar(library), LibraryJarDescriptor.RUNTIME_JAR);
                        KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getReflectJar(library), LibraryJarDescriptor.REFLECT_JAR);
                        KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getTestJar(library), LibraryJarDescriptor.TEST_JAR);
                        if (kJvmConfigurator.changeOldSourcesPathIfNeeded(library, collector2)) {
                            kJvmConfigurator.copySourcesToPathFromLibrary(library, collector2);
                            continue;
                        }
                        KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getRuntimeSrcJar(library), LibraryJarDescriptor.RUNTIME_SRC_JAR);
                        continue;
                    }
                    LibraryPresentationProvider libraryPresentationProvider2 = JSLibraryStdPresentationProvider.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)libraryPresentationProvider2, (String)"JSLibraryStdPresentationProvider.getInstance()");
                    if (!KotlinLibraryUtilKt.isDetected(libraryPresentationProvider2, library)) continue;
                    KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getJsStdLibJar(library), LibraryJarDescriptor.JS_STDLIB_JAR);
                    if (kJsConfigurator.changeOldSourcesPathIfNeeded(library, collector2)) {
                        kJsConfigurator.copySourcesToPathFromLibrary(library, collector2);
                        continue;
                    }
                    KotlinRuntimeLibraryUtilKt.access$updateJar(this.$project, KotlinLibraryUtilKt.getJsStdLibSrcJar(library), LibraryJarDescriptor.JS_STDLIB_SRC_JAR);
                }
                collector2.showNotification();
            }
            {
                this.$project = project;
                this.$libraries = collection;
            }
        });
    }

    private static final void updateJar(Project project, VirtualFile fileToReplace, LibraryJarDescriptor libraryJarDescriptor) {
        File file2;
        if (fileToReplace == null && !libraryJarDescriptor.getShouldExist()) {
            return;
        }
        KotlinPaths paths = org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin();
        switch (KotlinRuntimeLibraryUtilKt$WhenMappings.$EnumSwitchMapping$0[libraryJarDescriptor.ordinal()]) {
            case 1: {
                File file3 = paths.getRuntimePath();
                file2 = file3;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"paths.runtimePath");
                break;
            }
            case 2: {
                File file4 = paths.getReflectPath();
                file2 = file4;
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"paths.reflectPath");
                break;
            }
            case 3: {
                File file5 = paths.getKotlinTestPath();
                file2 = file5;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"paths.kotlinTestPath");
                break;
            }
            case 4: {
                File file6 = paths.getRuntimeSourcesPath();
                file2 = file6;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"paths.runtimeSourcesPath");
                break;
            }
            case 5: {
                File file7 = paths.getJsStdLibJarPath();
                file2 = file7;
                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"paths.jsStdLibJarPath");
                break;
            }
            case 6: {
                File file8 = paths.getJsStdLibSrcJarPath();
                file2 = file8;
                Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"paths.jsStdLibSrcJarPath");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File jarPath = file2;
        if (!jarPath.exists()) {
            KotlinRuntimeLibraryUtilKt.showRuntimeJarNotFoundDialog(project, libraryJarDescriptor.getJarName());
            return;
        }
        VirtualFile virtualFile2 = KotlinRuntimeLibraryUtilKt.getLocalJar(fileToReplace);
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        KotlinRuntimeLibraryUtilKt.replaceFile(jarPath, virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<Library, Module> findAllUsedLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MultiMap libraries = new MultiMap();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Module module = moduleArray[i];
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Object[] objectArray = moduleRootManager.getOrderEntries();
            void var9_9 = $receiver$iv;
            Collection collection = new ArrayList();
            for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                void element$iv$iv = $receiver$iv$iv[j];
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (LibraryOrderEntry entry : (List)destination$iv$iv) {
                Library library;
                if (entry.getLibrary() == null) {
                    continue;
                }
                libraries.putValue((Object)library, (Object)module);
            }
        }
        return libraries;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final String bundledRuntimeVersion(@NotNull String pluginVersion) {
        String string;
        int separator2;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)pluginVersion, (String)"pluginVersion");
        int placeToSplit = -1;
        String[] stringArray = PLUGIN_VERSIONS_SEPARATORS;
        for (n = 0; n < stringArray.length; ++n) {
            String separator2 = stringArray[n];
            int ideaPatternIndex = StringUtil.indexOf((CharSequence)pluginVersion, (CharSequence)separator2);
            if (ideaPatternIndex < 2 || !Character.isDigit(pluginVersion.charAt(ideaPatternIndex - 2))) continue;
            placeToSplit = ideaPatternIndex - 1;
            break;
        }
        if (placeToSplit == -1 && (separator2 = 1) <= (n = pluginVersion.length() - 1)) {
            while (true) {
                void i;
                char ch;
                if (Character.isLetter(ch = pluginVersion.charAt((int)i)) && pluginVersion.charAt((int)(i - true)) == '.') {
                    placeToSplit = i - true;
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (placeToSplit != -1) {
            String string2 = pluginVersion;
            n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, placeToSplit);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = pluginVersion;
        }
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ String bundledRuntimeVersion$default(String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bundledRuntimeVersion");
        }
        if ((n & 1) != 0) {
            String string2 = KotlinPluginUtil.getPluginVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinPluginUtil.getPluginVersion()");
            string = string2;
        }
        return KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion(string);
    }

    @JvmOverloads
    @NotNull
    public static String bundledRuntimeVersion() {
        return KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion$default(null, 1, null);
    }

    @Nullable
    public static final VirtualFile getLocalJar(@Nullable VirtualFile kotlinRuntimeJar) {
        if (kotlinRuntimeJar == null) {
            return null;
        }
        VirtualFile localJarFile = JarFileSystem.getInstance().getVirtualFileForJar(kotlinRuntimeJar);
        if (localJarFile != null) {
            return localJarFile;
        }
        return kotlinRuntimeJar;
    }

    public static final void replaceFile(@NotNull File updatedFile, @NotNull VirtualFile replacedJarFile) {
        Intrinsics.checkParameterIsNotNull((Object)updatedFile, (String)"updatedFile");
        Intrinsics.checkParameterIsNotNull((Object)replacedJarFile, (String)"replacedJarFile");
        try {
            VirtualFile replacedFile = PathUtil.getLocalFile((VirtualFile)replacedJarFile);
            String string = PathUtil.getLocalPath((VirtualFile)replacedFile);
            if (string == null) {
                String string2 = "Should be called for replacing valid root file: " + replacedJarFile;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String localPath = string;
            File libraryJarPath = new File(localPath);
            if (FileUtil.filesEqual((File)updatedFile, (File)libraryJarPath)) {
                return;
            }
            FileUtil.copy((File)updatedFile, (File)libraryJarPath);
            replacedFile.refresh(false, true);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends BinaryVersion> Collection<BinaryVersionedFile<T>> getLibraryRootsWithAbiIncompatibleVersion(Module module, T supportedVersion, ScalarIndexExtension<T> index2, Function1<? super T, Boolean> checkVersion) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void destination$iv$iv2;
        Object item$iv$iv2;
        void $receiver$iv$iv2;
        Collection $receiver$iv2;
        ID id = index2.getName();
        Set set = SetsKt.setOf((Object)module);
        Iterable iterable = ModuleUtil.getAllDependentModules((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"ModuleUtil.getAllDependentModules(module)");
        Set moduleWithAllDependencies = SetsKt.plus((Set)set, (Iterable)iterable);
        Iterable iterable2 = moduleWithAllDependencies;
        void var8_7 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv2) {
            void it;
            Module module2 = (Module)item$iv$iv2;
            void var18_12 = destination$iv$iv2;
            GlobalSearchScope globalSearchScope = it.getModuleWithLibrariesScope();
            var18_12.add(globalSearchScope);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        Collection thisCollection$iv = $receiver$iv2;
        GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
        if (globalSearchScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        GlobalSearchScope moduleWithAllDependentLibraries = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])((Object[])globalSearchScopeArray)));
        Collection allVersions = FileBasedIndex.getInstance().getAllKeys(id, module.getProject());
        Iterable $i$f$toTypedArray = allVersions;
        Iterator iterator2 = $receiver$iv;
        item$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!((Boolean)checkVersion.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet badVersions = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        HashSet badRoots = Sets.newHashSet();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)module.getProject());
        for (BinaryVersion version : badVersions) {
            Collection indexedFiles = FileBasedIndex.getInstance().getContainingFiles(id, (Object)version, moduleWithAllDependentLibraries);
            for (VirtualFile indexedFile : indexedFiles) {
                VirtualFile libraryRoot;
                if (fileIndex.getClassRootForFile(indexedFile) == null) {
                    String string = "Only library roots were requested, and only class files should be indexed with KotlinAbiVersionIndex key. " + ("File: " + indexedFile.getPath());
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                VirtualFile virtualFile2 = PathUtil.getLocalFile((VirtualFile)libraryRoot);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"getLocalFile(libraryRoot)");
                badRoots.add(new BinaryVersionedFile<BinaryVersion>(virtualFile2, version, supportedVersion));
            }
        }
        Collection collection2 = badRoots;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"badRoots");
        return collection2;
    }

    public static final void showRuntimeJarNotFoundDialog(@NotNull Project project, @NotNull String jarName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)jarName, (String)"jarName");
        Messages.showErrorDialog((Project)project, (String)(jarName + " is not found. Make sure plugin is properly installed."), (String)"No Runtime Found");
    }

    @Nullable
    public static final PsiClass getKotlinJvmRuntimeMarkerClass(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (PsiClass)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiClass>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke() {
                return (PsiClass)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<PsiClass>(this){
                    final /* synthetic */ getKotlinJvmRuntimeMarkerClass.1 this$0;

                    @Nullable
                    public final PsiClass invoke() {
                        return JavaPsiFacade.getInstance((Project)this.this$0.$project).findClass(KotlinBuiltIns.FQ_NAMES.unit.asString(), this.this$0.$scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    @Nullable
    public static final VirtualFile getKotlinJsRuntimeMarkerClass(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<VirtualFile>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final VirtualFile invoke() {
                return (VirtualFile)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<VirtualFile>(this){
                    final /* synthetic */ getKotlinJsRuntimeMarkerClass.1 this$0;

                    @Nullable
                    public final VirtualFile invoke() {
                        JsVirtualFileFinder jsVirtualFileFinder = JsVirtualFileFinderFactory.SERVICE.getInstance(this.this$0.$project).create(this.this$0.$scope);
                        ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.unit.toSafe());
                        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026s.FQ_NAMES.unit.toSafe())");
                        return jsVirtualFileFinder.findVirtualFileWithHeader(classId);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    static {
        String[] elements$iv = new String[]{"Idea", "IJ", "release", "dev", "Studio"};
        PLUGIN_VERSIONS_SEPARATORS = (String[])((Object[])elements$iv);
    }

    public static final /* synthetic */ void access$updateJar(@NotNull Project project, @Nullable VirtualFile fileToReplace, @NotNull LibraryJarDescriptor libraryJarDescriptor) {
        KotlinRuntimeLibraryUtilKt.updateJar(project, fileToReplace, libraryJarDescriptor);
    }
}

