/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u001f !BC\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;)V", "checkClashWithOtherDelegatedMember", "", "candidate", "delegatedMembers", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Ljava/util/Collection;)Z", "generateDelegatedMembers", "generateDelegatesForInterface", "existingDelegates", "delegatedInterfaceType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateDelegationCandidates", "getDelegatableMembers", "interfaceType", "Companion", "MemberExtractor", "TypeResolver", "frontend"})
public final class DelegationResolver<T extends CallableMemberDescriptor> {
    private final KtClassOrObject classOrObject;
    private final ClassDescriptor ownerDescriptor;
    private final Collection<CallableDescriptor> existingMembers;
    private final BindingTrace trace;
    private final MemberExtractor<T> memberExtractor;
    private final TypeResolver typeResolver;
    public static final Companion Companion = new Companion(null);

    private final Collection<T> generateDelegatedMembers() {
        HashSet delegatedMembers = SetsKt.hashSetOf((Object[])new CallableMemberDescriptor[0]);
        for (KtSuperTypeListEntry delegationSpecifier : this.classOrObject.getSuperTypeListEntries()) {
            KtTypeReference typeReference;
            if (!(delegationSpecifier instanceof KtDelegatedSuperTypeEntry)) continue;
            if (((KtDelegatedSuperTypeEntry)delegationSpecifier).getTypeReference() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"typeReference");
            KotlinType delegatedInterfaceType = this.typeResolver.resolve(ktTypeReference);
            if (delegatedInterfaceType == null || delegatedInterfaceType.isError()) continue;
            Collection<T> delegatesForInterface = this.generateDelegatesForInterface(delegatedMembers, delegatedInterfaceType);
            delegatedMembers.addAll(delegatesForInterface);
        }
        return delegatedMembers;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegatesForInterface(Collection<? extends T> existingDelegates, KotlinType delegatedInterfaceType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.generateDelegationCandidates(delegatedInterfaceType);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)element$iv$iv;
            if (!(!DelegationResolver.Companion.isOverridingAnyOf(candidate, this.existingMembers) && !this.checkClashWithOtherDelegatedMember(candidate, existingDelegates))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegationCandidates(KotlinType delegatedInterfaceType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.getDelegatableMembers(delegatedInterfaceType);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor callableMemberDescriptor;
            Modality modality;
            void memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)item$iv$iv;
            void var12_9 = destination$iv$iv;
            if (Intrinsics.areEqual((Object)((Object)memberDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT))) {
                modality = Modality.OPEN;
            } else {
                Modality modality2 = memberDescriptor.getModality();
                modality = modality2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality2), (String)"memberDescriptor.modality");
            }
            Modality newModality = modality;
            if (memberDescriptor.copy(this.ownerDescriptor, newModality, Visibilities.INHERITED, CallableMemberDescriptor.Kind.DELEGATION, false) == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            var12_9.add(callableMemberDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkClashWithOtherDelegatedMember(T candidate, Collection<? extends T> delegatedMembers) {
        Object v0;
        block2: {
            void $receiver$iv;
            Iterable iterable = delegatedMembers;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (!DelegationResolver.Companion.isOverridableBy(it, (CallableDescriptor)candidate)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        CallableMemberDescriptor alreadyDelegated = v0;
        if (alreadyDelegated != null) {
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.classOrObject), this.classOrObject, alreadyDelegated));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final Collection<T> getDelegatableMembers(KotlinType interfaceType) {
        block11: {
            block10: {
                block8: {
                    $receiver$iv = TypeUtils.getAllSupertypes(interfaceType);
                    var4_3 = $receiver$iv.iterator();
                    while (var4_3.hasNext()) {
                        element$iv = var4_3.next();
                        it = (KotlinType)element$iv;
                        typeConstructor = it.getConstructor().getDeclarationDescriptor();
                        if (!(typeConstructor instanceof ClassDescriptor != false && (Intrinsics.areEqual((Object)((ClassDescriptor)typeConstructor).getKind(), (Object)ClassKind.INTERFACE) ^ true) != false)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                if ((v1 = (KotlinType)v0) == null) break block10;
                $receiver$iv = v1;
                it = (KotlinType)$receiver$iv;
                v1 = this.memberExtractor.getMembersByType((KotlinType)it);
                if (v1 != null) break block11;
            }
            v1 = CollectionsKt.emptyList();
        }
        classSupertypeMembers = v1;
        $receiver$iv = this.memberExtractor.getMembersByType(interfaceType);
        it = $receiver$iv;
        $i$a$2$let = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            block9: {
                descriptor = (CallableMemberDescriptor)element$iv$iv;
                if (!ModalityKt.isOverridable(descriptor)) ** GOTO lbl-1000
                $i$f$firstOrNull = classSupertypeMembers;
                for (T element$iv : $receiver$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    if (!org.jetbrains.kotlin.resolve.DelegationResolver$Companion.access$isOverridableBy(DelegationResolver.Companion, it, descriptor)) continue;
                    v2 = true;
                    break block9;
                }
                v2 = false;
            }
            if (!v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private DelegationResolver(KtClassOrObject classOrObject, ClassDescriptor ownerDescriptor, Collection<? extends CallableDescriptor> existingMembers, BindingTrace trace, MemberExtractor<? extends T> memberExtractor, TypeResolver typeResolver) {
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = memberExtractor;
        this.typeResolver = typeResolver;
    }

    public /* synthetic */ DelegationResolver(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor memberExtractor, @NotNull TypeResolver typeResolver, DefaultConstructorMarker $constructor_marker) {
        this(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\n\b\u0001\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "getMembersByType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull KotlinType var1);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "", "resolve", "Lorg/jetbrains/kotlin/types/KotlinType;", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "frontend"})
    public static interface TypeResolver {
        @Nullable
        public KotlinType resolve(@NotNull KtTypeReference var1);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$Companion;", "", "()V", "generateDelegatedMembers", "", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "isOverridableBy", "", "memberOne", "memberTwo", "isOverridingAnyOf", "candidate", "possiblyOverriddenBy", "frontend"})
    public static final class Companion {
        @NotNull
        public final <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<? extends T> memberExtractor, @NotNull TypeResolver typeResolver) {
            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
            Intrinsics.checkParameterIsNotNull((Object)ownerDescriptor, (String)"ownerDescriptor");
            Intrinsics.checkParameterIsNotNull(existingMembers, (String)"existingMembers");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull(memberExtractor, (String)"memberExtractor");
            Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
            return new DelegationResolver(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, null).generateDelegatedMembers();
        }

        private final boolean isOverridingAnyOf(CallableMemberDescriptor candidate, Collection<? extends CallableDescriptor> possiblyOverriddenBy) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = possiblyOverriddenBy;
                for (Object element$iv : $receiver$iv) {
                    CallableDescriptor it = (CallableDescriptor)element$iv;
                    if (!Companion.isOverridableBy(it, candidate)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isOverridableBy(CallableDescriptor memberOne, CallableDescriptor memberTwo) {
            return Intrinsics.areEqual((Object)((Object)OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo, null).getResult()), (Object)((Object)OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

