/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.completion.beans;

import com.intellij.play.completion.beans.NameValueDescriptor;
import org.jetbrains.annotations.NotNull;

public class PlayTagDescriptor {
    private String tagName;
    private boolean isClosingTag;
    private NameValueDescriptor[] myDescriptors;
    public final String CLOSING_TAG = "/}";
    public final String TAG_START = "#{";
    public final String END_TAG_START = "#{/";
    public final String TAG_END = "}";

    public static PlayTagDescriptor create(@NotNull String tagName, NameValueDescriptor ... descriptors) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/play/completion/beans/PlayTagDescriptor", "create"));
        }
        return new PlayTagDescriptor(tagName, descriptors);
    }

    public static PlayTagDescriptor create(@NotNull String tagName, boolean closingTag, NameValueDescriptor ... descriptors) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/play/completion/beans/PlayTagDescriptor", "create"));
        }
        return new PlayTagDescriptor(tagName, closingTag, descriptors);
    }

    public PlayTagDescriptor(@NotNull String tagName, NameValueDescriptor ... descriptors) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/play/completion/beans/PlayTagDescriptor", "<init>"));
        }
        this(tagName, false, descriptors);
    }

    public PlayTagDescriptor(@NotNull String tagName, boolean closingTag, NameValueDescriptor ... descriptors) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/play/completion/beans/PlayTagDescriptor", "<init>"));
        }
        this.CLOSING_TAG = "/}";
        this.TAG_START = "#{";
        this.END_TAG_START = "#{/";
        this.TAG_END = "}";
        this.tagName = tagName;
        this.isClosingTag = closingTag;
        this.myDescriptors = descriptors;
    }

    public NameValueDescriptor[] getDescriptors() {
        return this.myDescriptors;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean isClosingTag() {
        return this.isClosingTag;
    }

    public String getTailText() {
        return " " + (this.isClosingTag() ? "/}" : "}#{/" + this.getTagName() + "}");
    }

    public String getPresentableText() {
        return "#{" + this.getTagName() + (this.isClosingTag() ? "" : " ...") + this.getTailText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayTagDescriptor)) {
            return false;
        }
        PlayTagDescriptor that = (PlayTagDescriptor)o;
        if (this.isClosingTag != that.isClosingTag) {
            return false;
        }
        return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
    }

    public int hashCode() {
        int result = this.tagName != null ? this.tagName.hashCode() : 0;
        result = 31 * result + (this.isClosingTag ? 1 : 0);
        return result;
    }
}

