/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.PlaySyntaxHighlighter;
import com.intellij.psi.templateLanguages.TemplateDataHighlighterWrapper;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;

public class PlayEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public PlayEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/play/language/PlayEditorHighlighter", "<init>"));
        }
        super((SyntaxHighlighter)new PlaySyntaxHighlighter(), colors);
        GroovySyntaxHighlighter groovyHighlighter = new GroovySyntaxHighlighter();
        LayerDescriptor groovyLayer = new LayerDescriptor((SyntaxHighlighter)groovyHighlighter, "\n", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
        this.registerLayer((IElementType)PlayElementTypes.GROOVY_SCRIPT, groovyLayer);
        this.registerLayer(PlayElementTypes.EL_EXPRESSION, groovyLayer);
        this.registerLayer(PlayElementTypes.ACTION_SCRIPT, groovyLayer);
        this.registerLayer(PlayElementTypes.TAG_EXPRESSION, groovyLayer);
        SyntaxHighlighter htmlHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)StdLanguages.HTML, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor htmlLayer = new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(htmlHighlighter), "\n");
        this.registerLayer((IElementType)PlayElementTypes.TEMPLATE_TEXT, htmlLayer);
    }
}

