/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.play.language.PlayActionCompositeElement;
import com.intellij.play.language.PlayCompositeElement;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.PlayFileType;
import com.intellij.play.language.TagExpressionCompositeElement;
import com.intellij.play.language.psi.PlayNameValueCompositeElement;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayTag
extends PlayCompositeElement
implements PsiNamedElement,
ContributedReferenceHost {
    public PlayTag(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/play/language/psi/PlayTag", "<init>"));
        }
        super(node);
    }

    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement == null ? "" : nameElement.getText();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/language/psi/PlayTag", "setName"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement element = this.getNameElement();
        if (element != null) {
            PsiElement newEndTagElement;
            PsiElement endTagNameElement;
            PlayPsiFile psiFile = (PlayPsiFile)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("play.html", (FileType)PlayFileType.INSTANCE, (CharSequence)("#{" + name + " }#{/" + name + " }"));
            PsiElement newElement = psiFile.getRootTags()[0].getNameElement();
            if (newElement != null) {
                element.replace(newElement);
            }
            if ((endTagNameElement = this.getEndTagNameElement()) != null && (newEndTagElement = psiFile.getRootTags()[0].getEndTagNameElement()) != null) {
                endTagNameElement.replace(newEndTagElement);
            }
        }
        return this;
    }

    @Nullable
    public PsiElement getNameElement() {
        PsiElement firstChild = this.getFirstChild();
        return firstChild == null ? null : firstChild.getNextSibling();
    }

    @Nullable
    public PsiElement getEndTagNameElement() {
        List endTags = this.findChildrenByType((IElementType)PlayElementTypes.END_TAG_START);
        if (endTags.size() == 1) {
            return ((PsiElement)endTags.get(0)).getNextSibling();
        }
        return null;
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public PlayTag[] getSubTags() {
        PlayTag[] playTagArray = (PlayTag[])this.findChildrenByClass(PlayTag.class);
        if (playTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/psi/PlayTag", "getSubTags"));
        }
        return playTagArray;
    }

    @Nullable
    public PlayNameValueCompositeElement findNameValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/language/psi/PlayTag", "findNameValue"));
        }
        for (PlayNameValueCompositeElement nameValueCompositeElement : this.getNameValues()) {
            if (!name.equals(nameValueCompositeElement.getName())) continue;
            return nameValueCompositeElement;
        }
        return null;
    }

    @NotNull
    public PlayNameValueCompositeElement[] getNameValues() {
        PlayNameValueCompositeElement[] playNameValueCompositeElementArray = (PlayNameValueCompositeElement[])this.findChildrenByClass(PlayNameValueCompositeElement.class);
        if (playNameValueCompositeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/psi/PlayTag", "getNameValues"));
        }
        return playNameValueCompositeElementArray;
    }

    @NotNull
    public TagExpressionCompositeElement[] getTagExpressions() {
        TagExpressionCompositeElement[] tagExpressionCompositeElementArray = (TagExpressionCompositeElement[])this.findChildrenByClass(TagExpressionCompositeElement.class);
        if (tagExpressionCompositeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/psi/PlayTag", "getTagExpressions"));
        }
        return tagExpressionCompositeElementArray;
    }

    @NotNull
    public PlayActionCompositeElement[] getActions() {
        PlayActionCompositeElement[] playActionCompositeElementArray = (PlayActionCompositeElement[])this.findChildrenByClass(PlayActionCompositeElement.class);
        if (playActionCompositeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/psi/PlayTag", "getActions"));
        }
        return playActionCompositeElementArray;
    }

    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = PsiReferenceService.getService().getContributedReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/psi/PlayTag", "getReferences"));
        }
        return psiReferenceArray;
    }
}

