/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayCustomTagNamePsiReference
extends PsiReferenceBase<PsiElement>
implements LocalQuickFixProvider {
    private final PlayTag myPlayTag;
    private String myTagName;
    @NotNull
    private String myFqn;
    private static final String CUSTOM_TAGS_DIR = "tags";

    public PlayCustomTagNamePsiReference(@NotNull PlayTag playTag, @NotNull String tagName, @NotNull String fqn) {
        if (playTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playTag", "com/intellij/play/references/PlayCustomTagNamePsiReference", "<init>"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/play/references/PlayCustomTagNamePsiReference", "<init>"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/play/references/PlayCustomTagNamePsiReference", "<init>"));
        }
        super((PsiElement)playTag, TextRange.from((int)playTag.getText().indexOf(tagName), (int)tagName.length()));
        this.myPlayTag = playTag;
        this.myTagName = tagName;
        this.myFqn = fqn;
    }

    public PsiElement resolve() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag);
        if (module != null) {
            Map<String, PsiFile> tags = PlayPathUtils.getCustomTags(module);
            for (Map.Entry<String, PsiFile> tag : tags.entrySet()) {
                PsiFile tagFile = tag.getValue();
                if (!(tagFile instanceof PlayPsiFile) || !this.myFqn.equals(tag.getKey())) continue;
                return tagFile;
            }
            for (PlayFastTagDescriptor descriptor : PlayPathUtils.getFastTags(module)) {
                if (!this.myFqn.equals(descriptor.getFqn())) continue;
                return descriptor.getMethod();
            }
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String tagName = PlayCustomTagNamePsiReference.getNewTagName(newElementName);
        String fqnName = this.myFqn.contains(".") ? StringUtil.getPackageName((String)this.myFqn) + "." + tagName : tagName;
        ((PlayTag)this.getElement()).setName(fqnName);
        return this.getElement();
    }

    private static String getNewTagName(String newElementName) {
        if (newElementName.contains(".")) {
            return FileUtil.getNameWithoutExtension((String)newElementName);
        }
        if (newElementName.startsWith("_")) {
            return newElementName.substring(1);
        }
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayCustomTagNamePsiReference", "bindToElement"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag);
        if (module != null) {
            Object tags;
            if (element instanceof PlayPsiFile) {
                tags = PlayPathUtils.getCustomTags(module);
                for (Map.Entry<String, Object> entry : tags.entrySet()) {
                    if (!element.equals(entry.getValue())) continue;
                    ((PlayTag)this.getElement()).setName(entry.getKey());
                    return element;
                }
            }
            if (element instanceof PsiMethod) {
                tags = PlayPathUtils.getFastTags(module);
                Iterator<Map.Entry<String, Object>> iterator = tags.iterator();
                while (iterator.hasNext()) {
                    PlayFastTagDescriptor playFastTagDescriptor = (PlayFastTagDescriptor)((Object)iterator.next());
                    if (!element.equals(playFastTagDescriptor.getMethod())) continue;
                    ((PlayTag)this.getElement()).setName(playFastTagDescriptor.getFqn());
                    return element;
                }
            }
        }
        return super.bindToElement(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayCustomTagNamePsiReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public LocalQuickFix[] getQuickFixes() {
        LocalQuickFix[] localQuickFixArray;
        LocalQuickFix fix = this.createNewCustomTagFix();
        if (fix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        }
        return localQuickFixArray;
    }

    @Nullable
    private LocalQuickFix createNewCustomTagFix() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag);
        if (module == null) {
            return null;
        }
        PsiDirectory viewsDirectory = PlayPathUtils.getViewsDirectory(module);
        if (viewsDirectory == null) {
            return null;
        }
        String newFileName = "tags/" + this.myFqn.replace(".", "/") + ".html";
        return new CreateFileFix(newFileName, viewsDirectory, "");
    }
}

