/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.beans.PlayLightMethodBuilder;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ControllerMethodsProcessor
implements PlayDeclarationsProcessor {
    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (LightMethodBuilder methodBuilder : ControllerMethodsProcessor.getControllerMethodsVariables(scope)) {
            if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)methodBuilder, (ResolveState)state)) continue;
            return false;
        }
        return true;
    }

    private static Set<LightMethodBuilder> getControllerMethodsVariables(PsiElement scope) {
        HashSet methodBuilders = new HashSet();
        PsiClass controller = PlayPathUtils.getCorrespondingController(scope.getContainingFile());
        if (controller != null) {
            for (PsiMethod psiMethod : controller.getAllMethods()) {
                if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
                methodBuilders.add(new PlayLightMethodBuilder(scope, psiMethod));
            }
        }
        return methodBuilders;
    }
}

