/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class LocalVariablesProcessor
implements PlayDeclarationsProcessor {
    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (PlayImplicitVariable playImplicitVariable : LocalVariablesProcessor.getLocalVariables(scope)) {
            if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)playImplicitVariable, (ResolveState)state)) continue;
            return false;
        }
        return true;
    }

    public static Set<PlayImplicitVariable> getLocalVariables(PsiElement scope) {
        HashSet set = new HashSet();
        PsiFile file = scope.getContainingFile().getOriginalFile();
        PsiMethod renderMethod = LocalVariablesProcessor.getTemplateRenderMethod(file);
        if (renderMethod != null) {
            renderMethod.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor((Set)set){
                final /* synthetic */ Set val$set;
                {
                    this.val$set = set;
                }

                public void visitElement(PsiElement element) {
                    if (element instanceof PsiVariable) {
                        PsiVariable psiVariable = (PsiVariable)element;
                        this.val$set.add(new PlayImplicitVariable(psiVariable.getName(), psiVariable.getType(), (PsiElement)psiVariable));
                    }
                    super.visitElement(element);
                }
            });
        }
        return set;
    }

    @Nullable
    public static PsiMethod getTemplateRenderMethod(@Nullable PsiFile file) {
        PsiClass controller;
        if (file != null && (controller = PlayPathUtils.getCorrespondingController(file)) != null) {
            for (PsiMethod psiMethod : controller.getAllMethods()) {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null || !virtualFile.getNameWithoutExtension().equals(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }
}

