/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftps.FTPSExtendedClient;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;

public final class FtpsClientFactory {
    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FtpsConnectionFactory factory = new FtpsConnectionFactory(FtpsFileSystemConfigBuilder.getInstance());
        return (FTPSClient)factory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions);
    }

    private static final class FtpsConnectionFactory
    extends FtpClientFactory.ConnectionFactory<FTPSClient, FtpsFileSystemConfigBuilder> {
        private FtpsConnectionFactory(FtpsFileSystemConfigBuilder builder) {
            super(builder);
        }

        @Override
        protected FTPSClient createClient(FileSystemOptions fileSystemOptions) throws FileSystemException {
            ServerSocketFactoryWrapper serverSocketFactoryWrapper;
            SocketFactoryWrapper socketFactoryWrapper;
            KeyManager keyManager;
            FTPSExtendedClient client = ((FtpsFileSystemConfigBuilder)this.builder).getFtpsMode(fileSystemOptions) == FtpsMode.IMPLICIT ? new FTPSExtendedClient(true) : new FTPSExtendedClient();
            TrustManager trustManager = ((FtpsFileSystemConfigBuilder)this.builder).getTrustManager(fileSystemOptions);
            if (trustManager != null) {
                client.setTrustManager(trustManager);
            }
            if ((keyManager = ((FtpsFileSystemConfigBuilder)this.builder).getKeyManager(fileSystemOptions)) != null) {
                client.setKeyManager(keyManager);
            }
            if ((socketFactoryWrapper = ((FtpsFileSystemConfigBuilder)this.builder).getSocketFactoryWrapper(fileSystemOptions)) != null) {
                client.setSocketFactoryWrapper(socketFactoryWrapper);
            }
            if ((serverSocketFactoryWrapper = ((FtpsFileSystemConfigBuilder)this.builder).getServerSocketFactoryWrapper(fileSystemOptions)) != null) {
                client.setServerSocketFactoryWrapper(serverSocketFactoryWrapper);
            }
            return client;
        }

        @Override
        protected void setupOpenConnection(FTPSClient client, FileSystemOptions fileSystemOptions) throws IOException {
            FtpsDataChannelProtectionLevel level = ((FtpsFileSystemConfigBuilder)this.builder).getDataChannelProtectionLevel(fileSystemOptions);
            if (level != null) {
                try {
                    client.execPBSZ(0L);
                    client.execPROT(level.name());
                }
                catch (SSLException e) {
                    throw new FileSystemException("vfs.provider.ftps/data-channel.level", (Throwable)e, level.toString());
                }
            }
        }

        @Override
        protected String getConnectionExceptionMessage() {
            return "vfs.provider.ftps/connect.error";
        }
    }
}

