/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class NodeModulesLibraryUpdater {
    private final Alarm myAlarm;
    private final long myDelayMillis;
    private final Runnable myTask;

    public NodeModulesLibraryUpdater(@NotNull Project project, long delayMillis) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryUpdater", "<init>"));
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myDelayMillis = delayMillis;
        this.myTask = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryUpdater", "lambda$new$1"));
            }
            WriteAction.run(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryUpdater", "lambda$null$0"));
                }
                if (!project.isDisposed()) {
                    JSLibraryManager.getInstance(project).commitChanges();
                }
            });
        };
    }

    public void scheduleUpdate() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded((Runnable)this.myTask);
        } else {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this.myTask, this.myDelayMillis);
        }
    }
}

