/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterPackage {
    public static final String INTERPRETER = "node.js.path.for.package.";
    public static final String PACKAGE = "node.js.selected.package.";
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myPackageName;
    @NotNull
    private NodeJsInterpreterRef myInterpreter;
    @NotNull
    private String myPackagePath;
    @NotNull
    private final String myInterpreterKey;
    @NotNull
    private final String myPackageKey;

    public JSLinterPackage(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/JSLinterPackage", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/JSLinterPackage", "<init>"));
        }
        this.myInterpreter = NodeJsInterpreterRef.createProjectRef();
        this.myPackagePath = "";
        this.myProject = project;
        this.myPackageName = packageName;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myInterpreterKey = INTERPRETER + this.myPackageName;
        this.myPackageKey = PACKAGE + this.myPackageName;
    }

    public void force(@Nullable NodeJsInterpreterRef interpreter, @Nullable String packagePath) {
        if (interpreter != null) {
            this.myPropertiesComponent.setValue(this.myInterpreterKey, interpreter.getReferenceName());
            this.myInterpreter = interpreter;
        }
        if (packagePath != null) {
            this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
            this.myPackagePath = packagePath;
        }
    }

    public void detect() {
        this.myInterpreter = this.loadInterpreterRef();
        this.myPackagePath = this.getPackage();
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreter() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreter;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getInterpreter"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getPackagePath() {
        String string = this.myPackagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getPackagePath"));
        }
        return string;
    }

    @NotNull
    private String getPackage() {
        String packagePath = this.myPropertiesComponent.getValue(this.myPackageKey, "");
        if (!StringUtil.isEmptyOrSpaces((String)packagePath)) {
            String string = packagePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getPackage"));
            }
            return string;
        }
        NodePackage defaultPackage = NodePackage.findDefaultPackage(this.myProject, this.myPackageName, this.myInterpreter.resolve(this.myProject));
        if (defaultPackage != null) {
            packagePath = defaultPackage.getSystemDependentPath();
            if (!this.isLocal(defaultPackage)) {
                packagePath = this.localPackageIfInDependencies(packagePath);
            }
        } else {
            packagePath = this.localPackageIfInDependencies(packagePath);
        }
        this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
        String string = packagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getPackage"));
        }
        return string;
    }

    private String localPackageIfInDependencies(String packagePath) {
        PackageJsonData data = JSLinterGuesser.getProjectPackageJsonData(this.myProject);
        if (data != null && data.getAllDependencies().contains(this.myPackageName)) {
            String basePath = FileUtil.toSystemDependentName((String)this.myProject.getBasePath());
            packagePath = (basePath.endsWith(File.separator) ? basePath : basePath + File.separator) + "node_modules" + File.separator + this.myPackageName;
        }
        return packagePath;
    }

    private boolean isLocal(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePackage", "com/intellij/javascript/nodejs/util/JSLinterPackage", "isLocal"));
        }
        if (this.myProject.isDefault()) {
            return false;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile packageVf = lfs.findFileByPathIfCached(nodePackage.getSystemIndependentPath());
        if (packageVf == null) {
            packageVf = lfs.refreshAndFindFileByIoFile(new File(nodePackage.getSystemDependentPath()));
        }
        if (packageVf == null) {
            return false;
        }
        return packageVf.getParent() != null && "node_modules".equals(packageVf.getParent().getName()) && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)packageVf, (boolean)true);
    }

    @NotNull
    private NodeJsInterpreterRef loadInterpreterRef() {
        String interpreterRefName = this.myPropertiesComponent.getValue(this.myInterpreterKey);
        if (interpreterRefName != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(interpreterRefName);
            if (nodeJsInterpreterRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "loadInterpreterRef"));
            }
            return nodeJsInterpreterRef;
        }
        NodeJsInterpreterRef ref = NodeJsInterpreterRef.createProjectRef();
        this.myPropertiesComponent.setValue(this.myInterpreterKey, ref.getReferenceName());
        NodeJsInterpreterRef nodeJsInterpreterRef = ref;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "loadInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }
}

