/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorRunConfigurationEditor;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorRunState;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
PreferableRunConfiguration {
    private ProtractorRunSettings myRunSettings;

    public ProtractorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.myRunSettings = ProtractorRunSettings.builder().build();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "getState"));
        }
        NodePackage pkg = this.getProtractorPackage();
        return new ProtractorRunState(this, environment, pkg);
    }

    @NotNull
    public ProtractorRunConfigurationEditor getConfigurationEditor() {
        ProtractorRunConfigurationEditor protractorRunConfigurationEditor = new ProtractorRunConfigurationEditor(this.getProject());
        if (protractorRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "getConfigurationEditor"));
        }
        return protractorRunConfigurationEditor;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunSettings = ProtractorUtil.readXml(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        ProtractorUtil.writeXml(element, this.myRunSettings);
    }

    @NotNull
    public ProtractorRunSettings getRunSettings() {
        ProtractorRunSettings protractorRunSettings = this.myRunSettings;
        if (protractorRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "getRunSettings"));
        }
        return protractorRunSettings;
    }

    public void setRunSettings(@NotNull ProtractorRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "setRunSettings"));
        }
        this.myRunSettings = runSettings;
    }

    @NotNull
    private NodePackage getProtractorPackage() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.getRunSettings().getInterpreterRef().resolve(project);
        NodePackage nodePackage = ProtractorUtil.getProtractorPackage(project, null, interpreter, true);
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "getProtractorPackage"));
        }
        return nodePackage;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolve(this.getProject());
        ProtractorRunConfiguration.validatePath(false, "configuration file", this.myRunSettings.getConfigFileSystemDependentPath());
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
        NodePackage pkg = this.getProtractorPackage();
        ProtractorRunConfiguration.validatePath(true, "protractor package", pkg.getSystemDependentPath());
        File protractorMainJsFile = ProtractorUtil.getProtractorMainJsFile(pkg);
        ProtractorRunConfiguration.validatePath(false, "bin/protractor file in protractor package", protractorMainJsFile.getAbsolutePath());
    }

    public void initializeFields() {
        List<VirtualFile> configs;
        ProtractorRunSettings runSettings = this.myRunSettings;
        if (runSettings.getConfigFileSystemDependentPath().isEmpty() && (configs = ProtractorUtil.listExactConfigFilesInProject(this.getProject())).size() == 1) {
            this.setConfigFile(configs.get(0));
            this.setGeneratedName();
        }
        this.setNameChangedByUser(false);
    }

    public void setConfigFile(VirtualFile config) {
        this.myRunSettings = this.myRunSettings.toBuilder().setConfigFilePath(config.getPath()).build();
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        if (otherRc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRc", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "isPreferredOver"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "isPreferredOver"));
        }
        return ProtractorUtil.isProtractorConfigFile(sourceElement.getContainingFile().getName());
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String name, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/protractor/ProtractorRunConfiguration", "validatePath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + name);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + name);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + name);
        }
    }

    public String suggestedName() {
        String name = PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath());
        return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
    }
}

