/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportHandler {
    public static final String DEFAULT_EXPORT_NAMESPACE = "\"default\"";
    private static final Key<ParameterizedCachedValue<ES6ExportCache, PsiFile>> CACHED_VALUE_KEY = Key.create((String)"es6.exported.names.cache");
    private static final ParameterizedCachedValueProvider<ES6ExportCache, PsiFile> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ES6ExportCache, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<ES6ExportCache> compute(PsiFile file) {
            StubElement fileStub;
            ES6ExportCache result = null;
            if (file instanceof PsiFileImpl && (fileStub = ((PsiFileImpl)file).getGreenStub()) != null) {
                result = this.calcExportSpecifiersAndDefaults(fileStub.getChildrenStubs().stream().map(childStub -> childStub.getPsi()));
            }
            if (result == null) {
                Spliterator spliterator = Spliterators.spliteratorUnknownSize(PsiTreeUtil.childIterator((PsiElement)file, PsiElement.class), 16);
                result = this.calcExportSpecifiersAndDefaults(StreamSupport.stream(spliterator, false));
            }
            return new CachedValueProvider.Result(result, new Object[]{file});
        }

        private ES6ExportCache calcExportSpecifiersAndDefaults(Stream<? extends PsiElement> fileElements) {
            THashSet exportSpecifiers = new THashSet();
            Ref exportDefault = Ref.create();
            fileElements.forEach(psi -> {
                String initializerReference;
                if (psi instanceof ES6ExportDeclaration) {
                    for (ES6ExportSpecifier exportSpecifier : ((ES6ExportDeclaration)psi).getExportSpecifiers()) {
                        String referenceName = exportSpecifier.getReferenceName();
                        if (referenceName == null || exportSpecifier.getAlias() != null) continue;
                        exportSpecifiers.add((Object)referenceName);
                    }
                } else if (psi instanceof ES6ExportDefaultAssignment && (initializerReference = ((ES6ExportDefaultAssignment)psi).getInitializerReference()) != null) {
                    exportDefault.set((Object)initializerReference);
                }
            });
            return new ES6ExportCache((String)exportDefault.get(), (Set)exportSpecifiers);
        }
    };

    public static boolean isExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExported"));
        }
        return element instanceof JSElementBase ? ((JSElementBase)element).isExported() : ES6ImportHandler.calculateIsExported(element);
    }

    public static boolean isExportedWithNameOrDefault(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportedWithNameOrDefault"));
        }
        if (ES6ImportHandler.isExported(element)) {
            return true;
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, true);
    }

    public static boolean calculateIsExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "calculateIsExported"));
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return true;
            }
            if (DialectDetector.isTypeScript(element) && !(element instanceof TypeScriptImportStatement)) {
                JSFile file;
                if (element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal()) {
                    return true;
                }
                if (element.getParent() instanceof TypeScriptImplicitModule) {
                    return true;
                }
                if (element.getParent() instanceof JSFile && !(file = (JSFile)element.getParent()).isCommonJSModule()) {
                    return true;
                }
                if (TypeScriptPsiUtil.isAmbientDeclaration(element)) {
                    return true;
                }
            }
            if (DialectDetector.isJSX(element) && element instanceof JSVariable && JSXHarmonyLanguageDialect.isReactComponent(((JSVariable)element).getInitializerOrStub())) {
                return true;
            }
        }
        if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportedDefaultBinding) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, false);
    }

    private static boolean isExportedViaStatement(@NotNull PsiElement element, boolean checkDefault) {
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportedViaStatement"));
        }
        String string = element instanceof ES6ImportSpecifier ? ((ES6ImportSpecifier)element).getReferenceName() : (name = element instanceof JSElement ? ((JSElement)element).getName() : null);
        if (name == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        ES6ExportCache exportedNames = (ES6ExportCache)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)file);
        return exportedNames != null && (checkDefault ? name.equals(exportedNames.myExportDefaultReference) : exportedNames.myNamedExports.contains(name));
    }

    private static class ES6ExportCache {
        @Nullable
        private final String myExportDefaultReference;
        @NotNull
        private final Set<String> myNamedExports;

        private ES6ExportCache(@Nullable String exportDefaultReference, @NotNull Set<String> exports) {
            if (exports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exports", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler$ES6ExportCache", "<init>"));
            }
            this.myExportDefaultReference = exportDefaultReference;
            this.myNamedExports = exports;
        }
    }
}

