/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.psi.PsiElement;

public class StringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BACKSLASH = '\\';

    private StringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return StringUtil.isDoubleQuotedString(value);
    }

    public static boolean isDoubleQuotedString(String value) {
        return value != null && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            return jsStringLiteral;
        }
        StringBuilder buffer = new StringBuilder(jsStringLiteral);
        boolean screened = false;
        int bufferIndex = 1;
        for (int i = 1; i < jsStringLiteral.length() - 1; ++i) {
            char c = jsStringLiteral.charAt(i);
            if (screened) {
                if (c == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c == '\\') {
                screened = true;
            } else if (c == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        buffer.setCharAt(0, newQuote);
        buffer.setCharAt(buffer.length() - 1, newQuote);
        return buffer.toString();
    }
}

