/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.lang.javascript.buildTools.TreeCellHyperlink;
import com.intellij.util.ObjectUtils;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeCellHyperlinkSupport {
    public static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private final JTree myTree;
    private final Cursor myOriginalCursor;
    private final DefaultTreeModel myTreeModel;
    private NodeInfo myCurrentNodeInfo;
    private Cursor myCurrentCursor;
    private int myCurrentMouseX;
    private int myCurrentMouseY;

    private TreeCellHyperlinkSupport(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport", "<init>"));
        }
        this.myTree = tree;
        this.myCurrentCursor = this.myOriginalCursor = tree.getCursor();
        this.myTreeModel = (DefaultTreeModel)tree.getModel();
        this.myCurrentMouseX = -1;
        this.myCurrentMouseY = -1;
    }

    private void start() {
        this.myTree.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                NodeInfo nodeInfo = TreeCellHyperlinkSupport.this.findNodeInfoAt(e.getX(), e.getY());
                TreeCellHyperlinkSupport.this.update(nodeInfo, e.getX(), e.getY());
            }
        });
        this.myTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NodeInfo nodeInfo = TreeCellHyperlinkSupport.this.findNodeInfoAt(e.getX(), e.getY());
                if (nodeInfo != null && nodeInfo.isMouseInsideHyperlink(e.getX(), e.getY())) {
                    nodeInfo.getTreeCellHyperlink().getClickHandler().run();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TreeCellHyperlinkSupport.this.update(null, -1, -1);
            }
        });
    }

    private void update(@Nullable NodeInfo newNodeInfo, int mouseX, int mouseY) {
        boolean insideHyperlinkAfter;
        NodeInfo oldNodeInfo = this.myCurrentNodeInfo;
        boolean insideHyperlinkBefore = oldNodeInfo != null && oldNodeInfo.isMouseInsideHyperlink(this.myCurrentMouseX, this.myCurrentMouseY);
        this.myCurrentMouseX = mouseX;
        this.myCurrentMouseY = mouseY;
        boolean bl = insideHyperlinkAfter = newNodeInfo != null && newNodeInfo.isMouseInsideHyperlink(this.myCurrentMouseX, this.myCurrentMouseY);
        if (insideHyperlinkBefore != insideHyperlinkAfter) {
            this.updateCursor(insideHyperlinkAfter);
            this.updateToolTipText(insideHyperlinkAfter, newNodeInfo);
            if (oldNodeInfo != null) {
                this.myTreeModel.nodeChanged(oldNodeInfo.getNode());
            }
            if (newNodeInfo != null && newNodeInfo != oldNodeInfo) {
                this.myTreeModel.nodeChanged(newNodeInfo.getNode());
            }
        }
        this.myCurrentNodeInfo = newNodeInfo;
    }

    private void updateToolTipText(boolean mouseInsideHyperLink, @Nullable NodeInfo info) {
        String toolTipText = null;
        if (mouseInsideHyperLink) {
            toolTipText = info != null ? info.getTreeCellHyperlink().getToolTipText() : null;
        }
        this.myTree.setToolTipText(toolTipText);
    }

    @Nullable
    private NodeInfo findNodeInfoAt(int x, int y) {
        NodeInfo nodeInfo = this.myCurrentNodeInfo;
        if (nodeInfo == null || !nodeInfo.containsY(y)) {
            nodeInfo = this.createNodeInfoAt(x, y);
        }
        return nodeInfo;
    }

    @Nullable
    private NodeInfo createNodeInfoAt(int x, int y) {
        TreeCellHyperlink treeCellHyperlink;
        DefaultMutableTreeNode node;
        Rectangle bounds;
        TreePath closestPath = this.myTree.getClosestPathForLocation(x, y);
        if (closestPath != null && (bounds = this.myTree.getPathBounds(closestPath)) != null && bounds.contains(x, y) && (node = TreeCellHyperlinkSupport.toNode(closestPath)) != null && (treeCellHyperlink = (TreeCellHyperlink)ObjectUtils.tryCast((Object)node.getUserObject(), TreeCellHyperlink.class)) != null) {
            return new NodeInfo(node, bounds, treeCellHyperlink);
        }
        return null;
    }

    @Nullable
    public static DefaultMutableTreeNode toNode(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public boolean isMouseInsideHyperlink() {
        NodeInfo nodeInfo = this.myCurrentNodeInfo;
        return nodeInfo != null && nodeInfo.isMouseInsideHyperlink(this.myCurrentMouseX, this.myCurrentMouseY);
    }

    private void updateCursor(boolean handCursor) {
        Cursor cursor;
        Cursor cursor2 = cursor = handCursor ? HAND_CURSOR : this.myOriginalCursor;
        if (this.myCurrentCursor != cursor) {
            this.myCurrentCursor = cursor;
            this.myTree.setCursor(cursor);
        }
    }

    @NotNull
    public static TreeCellHyperlinkSupport installOn(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport", "installOn"));
        }
        TreeCellHyperlinkSupport tracker = new TreeCellHyperlinkSupport(tree);
        tracker.start();
        TreeCellHyperlinkSupport treeCellHyperlinkSupport = tracker;
        if (treeCellHyperlinkSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport", "installOn"));
        }
        return treeCellHyperlinkSupport;
    }

    private static class NodeInfo {
        private final DefaultMutableTreeNode myNode;
        private final Rectangle myBounds;
        private final TreeCellHyperlink myTreeCellHyperlink;

        private NodeInfo(@NotNull DefaultMutableTreeNode node, @NotNull Rectangle bounds, @NotNull TreeCellHyperlink treeCellHyperlink) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport$NodeInfo", "<init>"));
            }
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport$NodeInfo", "<init>"));
            }
            if (treeCellHyperlink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeCellHyperlink", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport$NodeInfo", "<init>"));
            }
            this.myNode = node;
            this.myBounds = bounds;
            this.myTreeCellHyperlink = treeCellHyperlink;
        }

        private boolean containsY(int y) {
            return y >= this.myBounds.y && y < this.myBounds.y + this.myBounds.height;
        }

        @NotNull
        private DefaultMutableTreeNode getNode() {
            DefaultMutableTreeNode defaultMutableTreeNode = this.myNode;
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport$NodeInfo", "getNode"));
            }
            return defaultMutableTreeNode;
        }

        @NotNull
        public TreeCellHyperlink getTreeCellHyperlink() {
            TreeCellHyperlink treeCellHyperlink = this.myTreeCellHyperlink;
            if (treeCellHyperlink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TreeCellHyperlinkSupport$NodeInfo", "getTreeCellHyperlink"));
            }
            return treeCellHyperlink;
        }

        private boolean isMouseInsideHyperlink(int mouseX, int mouseY) {
            int relativeMouseX = mouseX - this.myBounds.x;
            int relativeMouseY = mouseY - this.myBounds.y;
            if (relativeMouseX < 0 || relativeMouseY < 0) {
                return false;
            }
            Rectangle hyperlinkBounds = this.myTreeCellHyperlink.getHyperlinkBounds();
            return hyperlinkBounds != null && hyperlinkBounds.contains(relativeMouseX, relativeMouseY);
        }
    }
}

