/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.execution.GruntWatchTaskListener;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class GruntRunProfileState
implements NodeLocalDebugRunProfileState {
    private static final String WATCH_TASK_NAME = "watch";
    private final ExecutionEnvironment myEnvironment;
    private final GruntRunSettings myRunSettings;
    private final GruntNonSharedSettings myNonSharedSettings;

    public GruntRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull GruntRunSettings runSettings, @NotNull GruntNonSharedSettings nonSharedSettings) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "<init>"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "<init>"));
        }
        if (nonSharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonSharedSettings", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "<init>"));
        }
        this.myEnvironment = environment;
        this.myRunSettings = runSettings;
        this.myNonSharedSettings = nonSharedSettings;
    }

    @NotNull
    public GruntRunSettings getRunSettings() {
        GruntRunSettings gruntRunSettings = this.myRunSettings;
        if (gruntRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "getRunSettings"));
        }
        return gruntRunSettings;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        ConsoleView console;
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myEnvironment.getProject());
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        ProcessHandler processHandler = JsbtUtil.createProcessHandlerWithBeepSupport(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        this.installWatchHandler(processHandler);
        if (debugPort != -1) {
            console = null;
        } else {
            console = this.createConsole(commandLine.getWorkDirectory());
            console.attachToProcess(processHandler);
            this.foldCommandLine(console, processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler);
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "execute"));
        }
        return defaultExecutionResult;
    }

    private void installWatchHandler(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "installWatchHandler"));
        }
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(this.myEnvironment.getProject());
        VirtualFile gruntfile = LocalFileFinder.findFile((String)FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        if (gruntfile != null) {
            GruntfileStructure gruntfileStructure = gruntfileManager.getCachedStructure(gruntfile);
            if (gruntfileStructure != null) {
                GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, gruntfileStructure, this.myRunSettings.getTasks());
            } else {
                gruntfileManager.fetchGruntStructure(gruntfile, new CatchingConsumer<GruntfileStructure, JsbtTaskFetchException>(){

                    public void consume(JsbtTaskFetchException e) {
                    }

                    public void consume(GruntfileStructure structure) {
                        GruntRunProfileState.installWatchHandler(GruntRunProfileState.this.myEnvironment.getProject(), processHandler, structure, GruntRunProfileState.this.myRunSettings.getTasks());
                    }
                });
            }
        } else {
            GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, null, this.myRunSettings.getTasks());
        }
    }

    private static void installWatchHandler(@NotNull Project project, @NotNull ProcessHandler processHandler, @Nullable GruntfileStructure gruntfileStructure, @NotNull List<String> taskNames) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "installWatchHandler"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "installWatchHandler"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "installWatchHandler"));
        }
        for (String taskName : taskNames) {
            String watchTaskName = GruntRunProfileState.findWatchTaskNameFor(gruntfileStructure, taskName);
            if (watchTaskName == null) continue;
            processHandler.addProcessListener((ProcessListener)new GruntWatchTaskListener(project, watchTaskName));
            return;
        }
    }

    @Nullable
    private static String findWatchTaskNameFor(@Nullable GruntfileStructure structure, @NotNull String taskName) {
        GruntTask task;
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "findWatchTaskNameFor"));
        }
        if (structure != null && (task = structure.findTaskByName(taskName)) != null) {
            Collection<GruntTask> dependentTasks = GruntTask.listAllDependentTasksFor(task);
            for (GruntTask dependentTask : dependentTasks) {
                GruntTargetTask dependentTargetTask;
                if (dependentTask instanceof GruntCoreTask && dependentTask.getName().equals(WATCH_TASK_NAME)) {
                    return dependentTask.getName();
                }
                if (!(dependentTask instanceof GruntTargetTask) || !(dependentTargetTask = (GruntTargetTask)dependentTask).getCoreTask().getName().equals(WATCH_TASK_NAME)) continue;
                return dependentTargetTask.getName();
            }
        }
        return taskName.equals(WATCH_TASK_NAME) || taskName.startsWith("watch:") ? taskName : null;
    }

    @NotNull
    private ConsoleView createConsole(@Nullable File cwd) {
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(this.myEnvironment.getProject());
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "createConsole"));
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        File workingDirectory = new File(this.myRunSettings.getGruntfilePath()).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addDebugParameters(commandLine, debugPort);
        String nodeOptions = this.myRunSettings.getNodeOptions().trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(this.myNonSharedSettings.getGruntCliPackageDirPath()));
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        String arguments = this.myRunSettings.getArguments().trim();
        if (StringUtil.isNotEmpty((String)arguments)) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        commandLine.addParameters(this.myRunSettings.getTasks());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "foldCommandLine"));
        }
        BaseOSProcessHandler osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class);
        if (osProcessHandler != null) {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"grunt"});
            String arguments = this.myRunSettings.getArguments().trim();
            if (StringUtil.isNotEmpty((String)arguments)) {
                args.addAll(ParametersListUtil.parse((String)arguments));
            }
            args.addAll(this.myRunSettings.getTasks());
            GruntRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)args));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "doFoldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "doFoldCommandLine"));
        }
        if (foldedCommandLineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedCommandLineText", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState", "doFoldCommandLine"));
        }
        final String commandLine = processHandler.getCommandLine();
        if (commandLine != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(ProcessEvent event) {
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }
                });
            }
        }
    }
}

