/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    private static final String NODE_MODULES = "node_modules";
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String TEMPLATE_NAME = "package_json";

    protected PackageJsonUtil() {
    }

    public static boolean isPackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        return file != null && PackageJsonUtil.isPackageJsonFile(file);
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getContainingPackageJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof JsonFile && FILE_NAME.equals(file.getName())) {
            return (JsonFile)file;
        }
        return null;
    }

    public static boolean isPackageJsonFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        return file instanceof JsonFile && FILE_NAME.equals(file.getName());
    }

    public static boolean isPackageJsonFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        return !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isTopLevelProperty"));
        }
        PsiElement parent = property.getParent();
        return parent != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty getProperty(@NotNull PsiElement position) {
        JsonObject object;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getProperty"));
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class, (boolean)false);
        if (property != null && (object = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            return property;
        }
        return null;
    }

    public static boolean hasScope(@NotNull String dependencyName, @NotNull String scopeName) {
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "hasScope"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "hasScope"));
        }
        return dependencyName.startsWith(scopeName) && dependencyName.length() > scopeName.length() && dependencyName.charAt(scopeName.length()) == '/';
    }

    public static boolean isInsideIndirectDependency(@NotNull VirtualFile file) {
        VirtualFile packageJson;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isInsideIndirectDependency"));
        }
        VirtualFile packageRoot = NodeModuleSearchUtil.findDependencyRoot(file);
        if (packageRoot == null) {
            return false;
        }
        VirtualFile scopeDir = null;
        VirtualFile nodeModulesDir = packageRoot.getParent();
        if (NodeModuleSearchUtil.isScopeName(nodeModulesDir)) {
            scopeDir = nodeModulesDir;
            nodeModulesDir = scopeDir.getParent();
        }
        if (nodeModulesDir == null || !StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)nodeModulesDir.getNameSequence())) {
            throw new AssertionError((Object)("Parent directory is expected to be node_modules, but actual is " + nodeModulesDir));
        }
        if (NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir) != null) {
            return true;
        }
        VirtualFile parent = nodeModulesDir.getParent();
        if (parent != null && (packageJson = parent.findChild(FILE_NAME)) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            String packageName;
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            boolean directDependency = data.isDependencyOfAnyType(packageName = PackageJsonUtil.getPackageName(scopeDir, packageRoot));
            return !directDependency;
        }
        return false;
    }

    private static String getPackageName(@Nullable VirtualFile scopeDir, @NotNull VirtualFile packageRoot) {
        if (packageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageRoot", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getPackageName"));
        }
        if (scopeDir != null) {
            return scopeDir.getName() + "/" + packageRoot.getName();
        }
        return packageRoot.getName();
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        long documentModificationStamp;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
        long l = documentModificationStamp = document != null ? document.getModificationStamp() : -1L;
        if (cached == null || cached.getFileModificationStamp() != packageJson.getModificationStamp() || cached.getDocumentModificationStamp() != documentModificationStamp) {
            PackageJsonData data = PackageJsonData.parse(packageJson, document);
            cached = new CachedPackageJsonData(data, packageJson.getModificationStamp(), documentModificationStamp);
            CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
        }
        PackageJsonData packageJsonData = cached.getData();
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        return packageJsonData;
    }

    @Nullable
    public static PsiFile createPackageJson(@NotNull PsiDirectory psiDir, boolean openFile) {
        if (psiDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDir", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "createPackageJson"));
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate(TEMPLATE_NAME);
        return CreateFileFromTemplateAction.createFileFromTemplate((String)FILE_NAME, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)openFile);
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;

        /*
         * WARNING - void declaration
         */
        public CachedPackageJsonData(@NotNull PackageJsonData data, long fileModificationStamp, long l) {
            void documentModificationStamp;
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "<init>"));
            }
            this.myData = data;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "getData"));
            }
            return packageJsonData;
        }

        public long getFileModificationStamp() {
            return this.myFileModificationStamp;
        }

        public long getDocumentModificationStamp() {
            return this.myDocumentModificationStamp;
        }

        public String toString() {
            return "data=" + this.myData + ", fileModificationStamp=" + this.myFileModificationStamp + ", documentModificationStamp=" + this.myDocumentModificationStamp;
        }
    }
}

