/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NpmRunConfigurationUtil {
    private NpmRunConfigurationUtil() {
    }

    public static void check(@NotNull Project project, @NotNull NpmRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "check"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "check"));
        }
        String packageJsonPath = settings.getPackageJsonSystemIndependentPath();
        if (packageJsonPath.isEmpty()) {
            throw new RuntimeConfigurationError("Please specify package.json");
        }
        File packageJson = new File(packageJsonPath);
        if (!packageJson.isAbsolute() || !packageJson.isFile()) {
            throw new RuntimeConfigurationError("Please specify package.json correctly");
        }
        if (settings.getCommand() == NpmCommand.RUN_SCRIPT) {
            NpmRunConfigurationUtil.validateScript(project, packageJsonPath, settings.getScriptNames());
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
    }

    private static void validateScript(@NotNull Project project, @NotNull String packageJsonPath, @NotNull List<String> scriptNames) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "validateScript"));
        }
        if (packageJsonPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonPath", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "validateScript"));
        }
        if (scriptNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptNames", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "validateScript"));
        }
        if (scriptNames.isEmpty()) {
            throw new RuntimeConfigurationError("Please specify npm scripts to run");
        }
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(packageJsonPath);
        if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
            try {
                NpmScriptsStructure structure = NpmScriptsService.getInstance().fetchBuildfileStructure(project, packageJson);
                for (String scriptName : scriptNames) {
                    if (structure.getTaskNames().contains(scriptName)) continue;
                    throw new RuntimeConfigurationError("No '" + scriptName + "' npm script");
                }
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {
                // empty catch block
            }
        }
    }
}

