/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartCompletionContributor {
    public static final LanguageExtension<JSSmartCompletionContributor> EP_NAME = new LanguageExtension("JavaScript.smartCompletionContributor");

    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getSmartCompletionVariants"));
        }
        PsiElement parent = location.getParent();
        JSType expectedClassType = JSTypeUtils.getValuableType(this.findClassType(parent));
        if (expectedClassType instanceof JSNamedType) {
            return this.getClassTypeVariants(parent, expectedClassType);
        }
        if (location.getQualifier() == null) {
            if (JSResolveUtil.isExprInJSTypeContext(location)) {
                String quote = JSCodeStyleSettings.getQuote((PsiElement)location);
                return ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, typeofValue -> {
                    String quoted = quote + typeofValue + quote;
                    return JSLookupUtilImpl.createPrioritizedLookupItem(null, quoted, JSLookupPriority.SMART_PRIORITY, false, false);
                });
            }
            return JSSmartCompletionContributor.getStringLiteralVariants((JSExpression)location, true);
        }
        return null;
    }

    @NotNull
    public List<?> getClassTypeVariants(PsiElement parent, JSType expectedClassType) {
        ArrayList<Object> variants = new ArrayList<Object>();
        String className = expectedClassType.getTypeText();
        LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, className, JSLookupPriority.SMART_PRIORITY, false, false);
        variants.add(lookupItem);
        JSSmartCompletionContributor.addAllJSClassInheritors(variants, className, parent);
        ArrayList<Object> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getClassTypeVariants"));
        }
        return arrayList;
    }

    @Nullable
    protected static List<LookupElement> getStringLiteralVariants(@NotNull JSExpression location, boolean wrapInQuotes) {
        List<LookupElement> stringLiteralVariants;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getStringLiteralVariants"));
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(location);
        if (expectedType != null && (stringLiteralVariants = JSSmartCompletionContributor.getStringLiteralVariantsForExpectedType(location, wrapInQuotes, expectedType)) != null) {
            return stringLiteralVariants;
        }
        return null;
    }

    @Nullable
    protected static List<LookupElement> getStringLiteralVariantsForExpectedType(@NotNull JSExpression location, boolean wrapInQuotes, JSType expectedType) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "getStringLiteralVariantsForExpectedType"));
        }
        List stringLiteralVariants = ContainerUtil.newSmartList();
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)type -> {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "lambda$getStringLiteralVariantsForExpectedType$1"));
            }
            if (type instanceof JSStringLiteralTypeImpl) {
                String literal = ((JSStringLiteralTypeImpl)((Object)type)).getLiteral();
                String q = wrapInQuotes ? JSCodeStyleSettings.getQuote((PsiElement)location) : "";
                LookupItem<Object> prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, q + literal + q, JSLookupPriority.SMART_PRIORITY, false, false);
                stringLiteralVariants.add(prioritizedLookupItem);
            }
            return true;
        }), expectedType);
        if (!stringLiteralVariants.isEmpty()) {
            return stringLiteralVariants;
        }
        return null;
    }

    private static void addAllJSClassInheritors(List<Object> variants, String className, PsiElement place) {
        final ArrayList all = new ArrayList();
        JSTypeEvaluateManager.iterateSubclasses(place, className, new JSTypeEvaluateManager.NamespaceProcessor(){

            @Override
            public boolean process(String qName, VirtualFile file) {
                all.add(qName);
                return true;
            }
        });
        for (String subclass : all) {
            LookupItem<Object> item = JSLookupUtilImpl.createPrioritizedLookupItem(null, subclass, JSLookupPriority.SMART_PRIORITY, false, false);
            variants.add(item);
        }
    }

    @Nullable
    protected JSType findClassType(PsiElement parent) {
        IElementType opSign;
        if (parent instanceof JSNewExpression) {
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression && ((opSign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.AS_KEYWORD || opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.INSTANCEOF_KEYWORD)) {
            JSType type = JSResolveUtil.getExpressionJSType(((JSBinaryExpression)parent).getLOperand());
            if (type != null && !(type instanceof JSAnyType) && !(type instanceof JSObjectType)) {
                return type;
            }
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        return null;
    }

    @NotNull
    protected List<Object> addVariantsForUnqualifiedReference(@NotNull JSReferenceExpression location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)location);
        if (expectedType == null) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
            }
            return list;
        }
        ArrayList<Object> variants = new ArrayList<Object>();
        this.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
        ArrayList<Object> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedReference"));
        }
        return arrayList;
    }

    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<Object> variants) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        PsiElement parent = location.getParent();
        int qualifiedStaticVariantsStart = Integer.MAX_VALUE;
        PsiElement parentInOriginalTree = PsiUtilCore.getOriginalElement((PsiElement)parent, parent.getClass());
        SinkResolveProcessor<CompletionResultSink> processor = JSSmartCompletionContributor.createProcessor(expectedType, parentInOriginalTree);
        JSClass ourClass = JSResolveUtil.getClassOfContext(parentInOriginalTree);
        this.processVariantsIfDoingSmartCompletion(expectedType, variants, parentInOriginalTree, processor, ourClass);
        this.processClasses(parentInOriginalTree, processor);
        qualifiedStaticVariantsStart = this.processContextClass(location, expectedType, parent, variants, qualifiedStaticVariantsStart, processor, ourClass);
        int i = 0;
        THashSet used = new THashSet();
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            JSParameterItem parameter;
            String referencedParameterName = null;
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)location, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            for (PsiElement o : results) {
                PsiElement element;
                JSNamedElement namedElement = (JSNamedElement)o;
                String name = namedElement.getName();
                String additionalPrefix = null;
                if ((namedElement instanceof JSVariable || namedElement instanceof JSFunction) && this.needToQualify(qualifiedStaticVariantsStart, i) && (element = JSResolveUtil.findParent((PsiElement)namedElement)) instanceof JSClass) {
                    additionalPrefix = name;
                    name = ((JSClass)element).getName() + "." + name;
                }
                if (name == null || !used.add(name)) {
                    if (i >= qualifiedStaticVariantsStart) continue;
                    --qualifiedStaticVariantsStart;
                    continue;
                }
                JSLookupPriority priority = JSLookupPriority.getSmartVariantPriority(name.equals(referencedParameterName));
                LookupItem<Object> prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)namedElement, name, priority, false, true);
                if (additionalPrefix != null) {
                    prioritizedLookupItem.addLookupStrings(new String[]{additionalPrefix});
                }
                variants.add(prioritizedLookupItem);
                ++i;
            }
        }
    }

    protected void processVariantsIfDoingSmartCompletion(@NotNull JSType expectedType, @NotNull List<Object> variants, PsiElement parentInOriginalTree, @NotNull SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "processVariantsIfDoingSmartCompletion"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "processVariantsIfDoingSmartCompletion"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "processVariantsIfDoingSmartCompletion"));
        }
        if (JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            processor.setToProcessHierarchy(true);
            processor.configureClassScope(ourClass);
            JSResolveUtil.treeWalkUp(processor, parentInOriginalTree, parentInOriginalTree.getParent(), parentInOriginalTree);
            processor.setAllowUnqualifiedStaticsFromInstance(false);
            if (expectedType instanceof JSBooleanType) {
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "true", JSLookupPriority.SMART_PRIORITY, true, true));
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "false", JSLookupPriority.SMART_PRIORITY, true, true));
            }
        }
    }

    @NotNull
    private static SinkResolveProcessor<CompletionResultSink> createProcessor(final JSType expectedType, PsiElement parentInOriginalTree) {
        final CompletionResultSink resultSink = new CompletionResultSink(parentInOriginalTree);
        resultSink.setSmartCompletionInheritanceProcessingContext(JSSmartCompletionVariantsHandler.initProcessingContext(parentInOriginalTree));
        SinkResolveProcessor<CompletionResultSink> sinkResolveProcessor = new SinkResolveProcessor<CompletionResultSink>(resultSink){
            {
                super(arg0);
                this.setAllowUnqualifiedStaticsFromInstance(true);
                this.setLocalResolve(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$2", "execute"));
                }
                return !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, expectedType, resultSink.getSmartCompletionInheritanceProcessingContext()) || super.execute(element, state);
            }
        };
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "createProcessor"));
        }
        return sinkResolveProcessor;
    }

    protected int processContextClass(@NotNull JSReferenceExpression location, JSType expectedType, PsiElement parent, List<Object> variants, int qualifiedStaticVariantsStart, SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/completion/JSSmartCompletionContributor", "processContextClass"));
        }
        return qualifiedStaticVariantsStart;
    }

    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return qualifiedStaticVariantsStart <= i;
    }

    protected void processClasses(PsiElement parentInOriginalTree, SinkResolveProcessor<?> processor) {
    }
}

